/*
 * Copyright (c) 2021, Oracle and/or its affiliates.
 *
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification, are
 * permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice, this list of
 * conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice, this list of
 * conditions and the following disclaimer in the documentation and/or other materials provided
 * with the distribution.
 *
 * 3. Neither the name of the copyright holder nor the names of its contributors may be used to
 * endorse or promote products derived from this software without specific prior written
 * permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 * COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
 * GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
 * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 */
#include <dlfcn.h>
#include <stdio.h>
#include <stdlib.h>
#include <libgen.h>

#define PATH_SIZE 1024
static char path[PATH_SIZE];

char *join(char *dir, char *file) {
#ifndef DLOPEN_TEST_NO_ABSOLUTE
    if (snprintf(path, PATH_SIZE - 1, "%s/%s", dir, file) < 0) {
        printf("Error during snprintf!\n");
        exit(-1);
    }
    return path;
#else
    return file;
#endif
}

int main(int argc, char **argv) {
    char *dir = dirname(argv[0]);
    char *path;

    path = join(dir, "libfour.so");
    void *lib_four = dlopen(path, RTLD_NOW | RTLD_GLOBAL);
    if (lib_four == NULL) {
        printf("could not dlopen(%s)\n", path);
        exit(4);
    }

    void (*four)() = dlsym(lib_four, "four");
    if (four != NULL) {
        four();
    } else {
        printf("could not dlsym(four)\n");
    }

    path = join(dir, "libone.so");
    void *lib_one = dlopen(path, RTLD_NOW | RTLD_LOCAL);
    if (lib_one == NULL) {
        printf("could not dlopen(%s)\n", path);
        exit(1);
    }

    void (*one)() = dlsym(lib_one, "one");
    void (*two)() = dlsym(lib_one, "two");
    if (one != NULL) {
        one();
    } else {
        printf("could not dlsym(one)\n");
    }

    path = join(dir, "libtwo.so");
    void *lib_two = dlopen(path, RTLD_NOW | RTLD_GLOBAL);
    if (lib_two == NULL) {
        printf("could not dlopen(%s)\n", path);
        exit(2);
    }

    if (two != NULL) {
        two();
    } else {
        printf("could not dlsym(two)\n");
    }

    path = join(dir, "libthree.so");
    void *lib_three = dlopen(path, RTLD_NOW | RTLD_GLOBAL);
    if (lib_three == NULL) {
        printf("could not dlopen(%s)\n", path);
        exit(3);
    }

    void (*three)() = dlsym(lib_three, "three");
    if (three != NULL) {
        three();
    } else {
        printf("could not dlsym(three)\n");
    }

    void (*three_global)() = dlsym(RTLD_DEFAULT, "three");
    if (three_global != NULL) {
        three_global();
    } else {
        printf("could not dlsym(three)\n");
    }

    path = join(dir, "libfive.so");
    void *lib_five = dlopen(path, RTLD_NOW | RTLD_GLOBAL);
    if (lib_five == NULL) {
        printf("could not dlopen(%s)\n", path);
        exit(5);
    }

    void *procHandle = NULL;
#ifdef __APPLE__
    procHandle = (void *) dlopen(NULL, RTLD_FIRST);
#else
    procHandle = (void *) dlopen(NULL, RTLD_LAZY);
#endif
    if (procHandle == NULL) {
        printf("could not dlopen(%s)\n", "NULL");
        exit(5);
    }

    return 0;
}
