/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.driver.launcher.json;

import com.oracle.svm.driver.launcher.json.BundleJSONParserException;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;

public class BundleJSONParser {
    private final String source;
    private final int length;
    private int pos = 0;
    private static final int EOF = -1;
    private static final String TRUE = "true";
    private static final String FALSE = "false";
    private static final String NULL = "null";
    private static final int STATE_EMPTY = 0;
    private static final int STATE_ELEMENT_PARSED = 1;
    private static final int STATE_COMMA_PARSED = 2;

    public BundleJSONParser(String source) {
        this.source = source;
        this.length = source.length();
    }

    public BundleJSONParser(Reader source) throws IOException {
        this(BundleJSONParser.readFully(source));
    }

    public Object parse() {
        Object value = this.parseLiteral();
        this.skipWhiteSpace();
        if (this.pos < this.length) {
            throw this.expectedError(this.pos, "eof", BundleJSONParser.toString(this.peek()));
        }
        return value;
    }

    private Object parseLiteral() {
        this.skipWhiteSpace();
        int c = this.peek();
        if (c == -1) {
            throw this.expectedError(this.pos, "json literal", "eof");
        }
        return switch (c) {
            case 123 -> this.parseObject();
            case 91 -> this.parseArray();
            case 34 -> this.parseString();
            case 102 -> this.parseKeyword(FALSE, Boolean.FALSE);
            case 116 -> this.parseKeyword(TRUE, Boolean.TRUE);
            case 110 -> this.parseKeyword(NULL, null);
            default -> {
                if (BundleJSONParser.isDigit(c) || c == 45) {
                    yield this.parseNumber();
                }
                if (c == 46) {
                    throw this.numberError(this.pos);
                }
                throw this.expectedError(this.pos, "json literal", BundleJSONParser.toString(c));
            }
        };
    }

    private Object parseObject() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        int state = 0;
        assert (this.peek() == 123);
        ++this.pos;
        block5: while (this.pos < this.length) {
            this.skipWhiteSpace();
            int c = this.peek();
            switch (c) {
                case 34: {
                    if (state == 1) {
                        throw this.expectedError(this.pos, ", or }", BundleJSONParser.toString(c));
                    }
                    String id = this.parseString();
                    this.expectColon();
                    Object value = this.parseLiteral();
                    result.put(id, value);
                    state = 1;
                    continue block5;
                }
                case 44: {
                    if (state != 1) {
                        throw this.error("Trailing comma is not allowed in JSON", this.pos);
                    }
                    state = 2;
                    ++this.pos;
                    continue block5;
                }
                case 125: {
                    if (state == 2) {
                        throw this.error("Trailing comma is not allowed in JSON", this.pos);
                    }
                    ++this.pos;
                    return result;
                }
            }
            throw this.expectedError(this.pos, ", or }", BundleJSONParser.toString(c));
        }
        throw this.expectedError(this.pos, ", or }", "eof");
    }

    private void expectColon() {
        this.skipWhiteSpace();
        int n = this.next();
        if (n != 58) {
            throw this.expectedError(this.pos - 1, ":", BundleJSONParser.toString(n));
        }
    }

    private Object parseArray() {
        ArrayList<Object> result = new ArrayList<Object>();
        int state = 0;
        assert (this.peek() == 91);
        ++this.pos;
        block4: while (this.pos < this.length) {
            this.skipWhiteSpace();
            int c = this.peek();
            switch (c) {
                case 44: {
                    if (state != 1) {
                        throw this.error("Trailing comma is not allowed in JSON", this.pos);
                    }
                    state = 2;
                    ++this.pos;
                    continue block4;
                }
                case 93: {
                    if (state == 2) {
                        throw this.error("Trailing comma is not allowed in JSON", this.pos);
                    }
                    ++this.pos;
                    return result;
                }
            }
            if (state == 1) {
                throw this.expectedError(this.pos, ", or ]", BundleJSONParser.toString(c));
            }
            result.add(this.parseLiteral());
            state = 1;
        }
        throw this.expectedError(this.pos, ", or ]", "eof");
    }

    private String parseString() {
        int start = ++this.pos;
        StringBuilder sb = null;
        while (this.pos < this.length) {
            int c = this.next();
            if (c <= 31) {
                throw this.syntaxError(this.pos, "String contains control character");
            }
            if (c == 92) {
                if (sb == null) {
                    sb = new StringBuilder(this.pos - start + 16);
                }
                sb.append(this.source, start, this.pos - 1);
                sb.append(this.parseEscapeSequence());
                start = this.pos;
                continue;
            }
            if (c != 34) continue;
            if (sb != null) {
                sb.append(this.source, start, this.pos - 1);
                return sb.toString();
            }
            return this.source.substring(start, this.pos - 1);
        }
        throw this.error("Missing close quote", this.pos);
    }

    private char parseEscapeSequence() {
        int c = this.next();
        return switch (c) {
            case 34 -> '\"';
            case 92 -> '\\';
            case 47 -> '/';
            case 98 -> '\b';
            case 102 -> '\f';
            case 110 -> '\n';
            case 114 -> '\r';
            case 116 -> '\t';
            case 117 -> this.parseUnicodeEscape();
            default -> throw this.error("Invalid escape character", this.pos - 1);
        };
    }

    private char parseUnicodeEscape() {
        return (char)(this.parseHexDigit() << 12 | this.parseHexDigit() << 8 | this.parseHexDigit() << 4 | this.parseHexDigit());
    }

    private int parseHexDigit() {
        int c = this.next();
        if (c >= 48 && c <= 57) {
            return c - 48;
        }
        if (c >= 65 && c <= 70) {
            return c + 10 - 65;
        }
        if (c >= 97 && c <= 102) {
            return c + 10 - 97;
        }
        throw this.error("Invalid hex digit", this.pos - 1);
    }

    private static boolean isDigit(int c) {
        return c >= 48 && c <= 57;
    }

    private void skipDigits() {
        int c;
        while (this.pos < this.length && BundleJSONParser.isDigit(c = this.peek())) {
            ++this.pos;
        }
    }

    private Number parseNumber() {
        boolean isFloating = false;
        int start = this.pos;
        int c = this.next();
        if (c == 45) {
            c = this.next();
        }
        if (!BundleJSONParser.isDigit(c)) {
            throw this.numberError(start);
        }
        if (c != 48) {
            this.skipDigits();
        }
        if (this.peek() == 46) {
            isFloating = true;
            ++this.pos;
            if (!BundleJSONParser.isDigit(this.next())) {
                throw this.numberError(this.pos - 1);
            }
            this.skipDigits();
        }
        if ((c = this.peek()) == 101 || c == 69) {
            ++this.pos;
            c = this.next();
            if (c == 45 || c == 43) {
                c = this.next();
            }
            if (!BundleJSONParser.isDigit(c)) {
                throw this.numberError(this.pos - 1);
            }
            this.skipDigits();
        }
        String literalValue = this.source.substring(start, this.pos);
        if (isFloating) {
            return Double.parseDouble(literalValue);
        }
        long l = Long.parseLong(literalValue);
        if ((long)((int)l) == l) {
            return (int)l;
        }
        return l;
    }

    private Object parseKeyword(String keyword, Object value) {
        if (!this.source.regionMatches(this.pos, keyword, 0, keyword.length())) {
            throw this.expectedError(this.pos, "json literal", "ident");
        }
        this.pos += keyword.length();
        return value;
    }

    private int peek() {
        if (this.pos >= this.length) {
            return -1;
        }
        return this.source.charAt(this.pos);
    }

    private int next() {
        int next = this.peek();
        ++this.pos;
        return next;
    }

    private void skipWhiteSpace() {
        block3: while (this.pos < this.length) {
            switch (this.peek()) {
                case 9: 
                case 10: 
                case 13: 
                case 32: {
                    ++this.pos;
                    continue block3;
                }
            }
            return;
        }
    }

    private static String toString(int c) {
        return c == -1 ? "eof" : String.valueOf((char)c);
    }

    private BundleJSONParserException error(String message, int start) {
        int lineNum = this.getLine(start);
        int columnNum = this.getColumn(start);
        String formatted = BundleJSONParser.format(message, lineNum, columnNum);
        return new BundleJSONParserException(formatted);
    }

    private int getLine(int position) {
        String d = this.source;
        int line = 1;
        for (int i = 0; i < position; ++i) {
            char ch = d.charAt(i);
            if (ch != '\n') continue;
            ++line;
        }
        return line;
    }

    private int getColumn(int position) {
        return position - this.findBOLN(position);
    }

    private int findBOLN(int position) {
        String d = this.source;
        for (int i = position - 1; i > 0; --i) {
            char ch = d.charAt(i);
            if (ch != '\n' && ch != '\r') continue;
            return i + 1;
        }
        return 0;
    }

    private static String format(String message, int line, int column) {
        return "line " + line + " column " + column + " " + message;
    }

    private BundleJSONParserException numberError(int start) {
        return this.error("Invalid JSON number format", start);
    }

    private BundleJSONParserException expectedError(int start, String expected, String found) {
        return this.error("Expected " + expected + " but found " + found, start);
    }

    private BundleJSONParserException syntaxError(int start, String reason) {
        return this.error("Invalid JSON: " + reason, start);
    }

    private static String readFully(Reader reader) throws IOException {
        char[] arr = new char[1024];
        StringBuilder sb = new StringBuilder();
        try (Reader reader2 = reader;){
            int numChars;
            while ((numChars = reader.read(arr, 0, arr.length)) > 0) {
                sb.append(arr, 0, numChars);
            }
        }
        return sb.toString();
    }
}

