/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.truffle.nfi.libffi;

import com.oracle.svm.core.OS;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.c.ProjectHeaderFile;
import com.oracle.svm.truffle.nfi.TruffleNFIFeature;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.c.CContext;

public class LibFFIHeaderDirectives
implements CContext.Directives {
    public boolean isInConfiguration() {
        return ImageSingletons.contains(TruffleNFIFeature.class);
    }

    public List<String> getHeaderFiles() {
        return Collections.singletonList("<svm_libffi.h>");
    }

    private static String basePath() {
        String libffiHeader = ProjectHeaderFile.resolve((String)"com.oracle.svm.libffi", (String)"include/svm_libffi.h");
        File libffiHeaderPath = new File(libffiHeader.substring(1));
        return libffiHeaderPath.getParentFile().getParent();
    }

    private static String multitargetSuffix() {
        String os = OS.getCurrent().asPackageName();
        String arch = SubstrateUtil.getArchitectureName();
        String libc = OS.LINUX.isCurrent() ? (String)SubstrateOptions.UseLibC.getValue() : "default";
        return os + "-" + arch + File.separator + libc;
    }

    public List<String> getOptions() {
        Function<String, String> bp = multitarget -> "-I" + LibFFIHeaderDirectives.basePath() + File.separator + multitarget + "include";
        return List.of(bp.apply(""), bp.apply(LibFFIHeaderDirectives.multitargetSuffix() + File.separator));
    }

    public List<String> getLibraryPaths() {
        return List.of(LibFFIHeaderDirectives.basePath() + File.separator + LibFFIHeaderDirectives.multitargetSuffix());
    }
}

