/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.configure;

import com.oracle.svm.configure.ConfigurationParserOption;
import com.oracle.svm.configure.ConfigurationTypeDescriptor;
import com.oracle.svm.configure.LambdaConfigurationTypeDescriptor;
import com.oracle.svm.configure.NamedConfigurationTypeDescriptor;
import com.oracle.svm.configure.ProxyConfigurationTypeDescriptor;
import com.oracle.svm.util.LogUtils;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import jdk.graal.compiler.util.json.JsonParser;
import jdk.graal.compiler.util.json.JsonParserException;
import jdk.graal.compiler.util.json.JsonPrintable;
import jdk.graal.compiler.util.json.JsonPrinter;
import jdk.graal.compiler.util.json.JsonWriter;
import org.graalvm.collections.EconomicMap;
import org.graalvm.nativeimage.ImageInfo;

public abstract class ConfigurationParser {
    public static final String NAME_KEY = "name";
    public static final String TYPE_KEY = "type";
    public static final String PROXY_KEY = "proxy";
    public static final String LAMBDA_KEY = "lambda";
    public static final String DECLARING_CLASS_KEY = "declaringClass";
    public static final String DECLARING_METHOD_KEY = "declaringMethod";
    public static final String INTERFACES_KEY = "interfaces";
    public static final String PARAMETER_TYPES_KEY = "parameterTypes";
    public static final String REFLECTION_KEY = "reflection";
    public static final String JNI_KEY = "jni";
    public static final String FOREIGN_KEY = "foreign";
    public static final String SERIALIZATION_KEY = "serialization";
    public static final String RESOURCES_KEY = "resources";
    public static final String BUNDLES_KEY = "bundles";
    public static final String GLOBS_KEY = "globs";
    public static final String MODULE_KEY = "module";
    public static final String GLOB_KEY = "glob";
    public static final String BUNDLE_KEY = "bundle";
    private final Map<String, Set<String>> seenUnknownAttributesByType = new HashMap<String, Set<String>>();
    private final EnumSet<ConfigurationParserOption> parserOptions;

    public static InputStream openStream(URI uri) throws IOException {
        URL url = uri.toURL();
        if ("file".equals(url.getProtocol()) || "jar".equalsIgnoreCase(url.getProtocol()) || ImageInfo.inImageRuntimeCode() && "resource".equals(url.getProtocol())) {
            return url.openStream();
        }
        throw new IllegalArgumentException("For security reasons, reading configurations is not supported from URIs with protocol: " + url.getProtocol());
    }

    protected ConfigurationParser(EnumSet<ConfigurationParserOption> parserOptions) {
        this.parserOptions = parserOptions;
    }

    protected EnumSet<ConfigurationParserOption> supportedOptions() {
        return EnumSet.of(ConfigurationParserOption.STRICT_CONFIGURATION);
    }

    protected final boolean checkOption(ConfigurationParserOption option) {
        if (!this.supportedOptions().contains((Object)option)) {
            throw new IllegalArgumentException(String.format("Tried to check option %s but it was not declared as a supported option", new Object[]{option}));
        }
        return this.parserOptions.contains((Object)option);
    }

    public void parseAndRegister(URI uri) throws IOException {
        try (BufferedReader reader = ConfigurationParser.openReader(uri);){
            this.parseAndRegister(new JsonParser((Reader)reader).parse(), uri);
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    protected static BufferedReader openReader(URI uri) throws IOException {
        return new BufferedReader(new InputStreamReader(ConfigurationParser.openStream(uri)));
    }

    public void parseAndRegister(Reader reader) throws IOException {
        this.parseAndRegister(new JsonParser(reader).parse(), null);
    }

    public abstract void parseAndRegister(Object var1, URI var2) throws IOException;

    public Object getFromGlobalFile(Object json, String key) {
        EconomicMap<String, Object> map = ConfigurationParser.asMap(json, "top level of reachability metadata file must be an object");
        this.checkAttributes(map, "reachability metadata", Collections.emptyList(), List.of(REFLECTION_KEY, JNI_KEY, SERIALIZATION_KEY, RESOURCES_KEY, BUNDLES_KEY, FOREIGN_KEY, "reason", "comment"));
        return map.get((Object)key);
    }

    public static List<Object> asList(Object data, String errorMessage) {
        if (data instanceof List) {
            return (List)data;
        }
        throw new JsonParserException(errorMessage);
    }

    public static EconomicMap<String, Object> asMap(Object data, String errorMessage) {
        if (data instanceof EconomicMap) {
            return (EconomicMap)data;
        }
        throw new JsonParserException(errorMessage);
    }

    protected void checkAttributes(EconomicMap<String, Object> map, String type, Collection<String> requiredAttrs, Collection<String> optionalAttrs) {
        HashSet<String> unseenRequired = new HashSet<String>(requiredAttrs);
        for (Object key2 : map.getKeys()) {
            unseenRequired.remove(key2);
        }
        if (!unseenRequired.isEmpty()) {
            throw new JsonParserException("Missing attribute(s) [" + String.join((CharSequence)", ", unseenRequired) + "] in " + type);
        }
        HashSet<String> unknownAttributes = new HashSet<String>();
        for (String key3 : map.getKeys()) {
            unknownAttributes.add(key3);
        }
        unknownAttributes.removeAll(requiredAttrs);
        unknownAttributes.removeAll(optionalAttrs);
        if (this.seenUnknownAttributesByType.containsKey(type)) {
            unknownAttributes.removeAll((Collection)this.seenUnknownAttributesByType.get(type));
        }
        if (unknownAttributes.size() > 0) {
            String message = "Unknown attribute(s) [" + String.join((CharSequence)", ", unknownAttributes) + "] in " + type;
            this.warnOrFailOnSchemaError(message);
            Set unknownAttributesForType = this.seenUnknownAttributesByType.computeIfAbsent(type, key -> new HashSet());
            unknownAttributesForType.addAll(unknownAttributes);
        }
    }

    public static void checkHasExactlyOneAttribute(EconomicMap<String, Object> map, String type, Collection<String> alternativeAttributes) {
        boolean attributeFound = false;
        for (String key : map.getKeys()) {
            if (!alternativeAttributes.contains(key)) continue;
            if (attributeFound) {
                String message = "Exactly one of [" + String.join((CharSequence)", ", alternativeAttributes) + "] must be set in " + type;
                throw new JsonParserException(message);
            }
            attributeFound = true;
        }
        if (!attributeFound) {
            String message = "Exactly one of [" + String.join((CharSequence)", ", alternativeAttributes) + "] must be set in " + type;
            throw new JsonParserException(message);
        }
    }

    protected void warnOrFailOnSchemaError(String message) {
        if (this.checkOption(ConfigurationParserOption.STRICT_CONFIGURATION)) {
            ConfigurationParser.failOnSchemaError(message);
        } else {
            LogUtils.warning((String)message);
        }
    }

    protected void checkAttributes(EconomicMap<String, Object> map, String type, Collection<String> requiredAttrs) {
        this.checkAttributes(map, type, requiredAttrs, Collections.emptyList());
    }

    public static String asString(Object value) {
        if (value instanceof String) {
            return (String)value;
        }
        throw new JsonParserException("Invalid string value \"" + String.valueOf(value) + "\".");
    }

    protected static String asString(Object value, String propertyName) {
        if (value instanceof String) {
            return (String)value;
        }
        throw new JsonParserException("Invalid string value \"" + String.valueOf(value) + "\" for element '" + propertyName + "'");
    }

    protected static String asNullableString(Object value, String propertyName) {
        return value == null ? null : ConfigurationParser.asString(value, propertyName);
    }

    protected static boolean asBoolean(Object value, String propertyName) {
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        throw new JsonParserException("Invalid boolean value '" + String.valueOf(value) + "' for element '" + propertyName + "'");
    }

    protected static long asLong(Object value, String propertyName) {
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof Integer) {
            return ((Integer)value).intValue();
        }
        throw new JsonParserException("Invalid long value '" + String.valueOf(value) + "' for element '" + propertyName + "'");
    }

    protected static JsonParserException failOnSchemaError(String message) {
        throw new JsonParserException(message);
    }

    protected static Optional<TypeDescriptorWithOrigin> parseName(EconomicMap<String, Object> data, boolean treatAllNameEntriesAsType) {
        Object name = data.get((Object)NAME_KEY);
        if (name != null) {
            NamedConfigurationTypeDescriptor typeDescriptor = NamedConfigurationTypeDescriptor.fromJSONName(ConfigurationParser.asString(name));
            return Optional.of(new TypeDescriptorWithOrigin(typeDescriptor, treatAllNameEntriesAsType));
        }
        throw ConfigurationParser.failOnSchemaError("must have type or name specified for an element");
    }

    protected Optional<ConfigurationTypeDescriptor> parseTypeContents(Object typeObject) {
        if (typeObject instanceof String) {
            String stringValue = (String)typeObject;
            return Optional.of(NamedConfigurationTypeDescriptor.fromJSONName(stringValue));
        }
        EconomicMap<String, Object> type = ConfigurationParser.asMap(typeObject, "type descriptor should be a string or object");
        if (type.containsKey((Object)PROXY_KEY)) {
            ConfigurationParser.checkHasExactlyOneAttribute(type, "type descriptor object", Set.of(PROXY_KEY));
            return Optional.of(ConfigurationParser.getProxyDescriptor(type.get((Object)PROXY_KEY)));
        }
        if (type.containsKey((Object)LAMBDA_KEY)) {
            return Optional.of(this.getLambdaDescriptor(type.get((Object)LAMBDA_KEY)));
        }
        return Optional.empty();
    }

    private static ProxyConfigurationTypeDescriptor getProxyDescriptor(Object proxyObject) {
        List<Object> proxyInterfaces = ConfigurationParser.asList(proxyObject, "proxy interface content should be an interface list");
        List<String> proxyInterfaceNames = proxyInterfaces.stream().map(obj -> ConfigurationParser.asString(obj, PROXY_KEY)).toList();
        return ProxyConfigurationTypeDescriptor.fromInterfaceTypeNames(proxyInterfaceNames);
    }

    private LambdaConfigurationTypeDescriptor getLambdaDescriptor(Object lambdaObject) {
        List<Object> interfaceNames;
        EconomicMap<String, Object> lambda = ConfigurationParser.asMap(lambdaObject, "lambda type descriptor should be an object");
        this.checkAttributes(lambda, "lambda descriptor object", List.of(DECLARING_CLASS_KEY, INTERFACES_KEY), List.of(DECLARING_METHOD_KEY));
        Optional<ConfigurationTypeDescriptor> declaringType = this.parseTypeContents(lambda.get((Object)DECLARING_CLASS_KEY));
        if (declaringType.isEmpty()) {
            throw new JsonParserException("Could not parse lambda declaring type");
        }
        ConfigurationMethodDescriptor method = null;
        if (lambda.containsKey((Object)DECLARING_METHOD_KEY)) {
            EconomicMap<String, Object> methodObject = ConfigurationParser.asMap(lambda.get((Object)DECLARING_METHOD_KEY), "lambda declaring method descriptor should be an object");
            method = this.parseMethod(methodObject);
        }
        if ((interfaceNames = ConfigurationParser.asList(lambda.get((Object)INTERFACES_KEY), "lambda implemented interfaces must be specified")).isEmpty()) {
            throw new JsonParserException("Lambda interfaces must not be empty");
        }
        List<NamedConfigurationTypeDescriptor> interfaces = interfaceNames.stream().map(s -> NamedConfigurationTypeDescriptor.fromJSONName(ConfigurationParser.asString(s))).toList();
        return new LambdaConfigurationTypeDescriptor(declaringType.get(), method, interfaces);
    }

    protected ConfigurationMethodDescriptor parseMethod(EconomicMap<String, Object> methodJson) {
        this.checkAttributes(methodJson, "method descriptor", List.of(NAME_KEY), List.of(PARAMETER_TYPES_KEY));
        String name = ConfigurationParser.asString(methodJson.get((Object)NAME_KEY));
        List<NamedConfigurationTypeDescriptor> parameterTypes = null;
        if (methodJson.containsKey((Object)PARAMETER_TYPES_KEY)) {
            List<Object> parameterTypesStrings = ConfigurationParser.asList(methodJson.get((Object)PARAMETER_TYPES_KEY), "parameter types list");
            parameterTypes = parameterTypesStrings.stream().map(s -> NamedConfigurationTypeDescriptor.fromJSONName(ConfigurationParser.asString(s))).toList();
        }
        return new ConfigurationMethodDescriptor(name, parameterTypes);
    }

    protected record TypeDescriptorWithOrigin(ConfigurationTypeDescriptor typeDescriptor, boolean definedAsType) {
    }

    public record ConfigurationMethodDescriptor(String name, List<NamedConfigurationTypeDescriptor> parameterTypes) implements JsonPrintable,
    Comparable<ConfigurationMethodDescriptor>
    {
        @Override
        public int compareTo(ConfigurationMethodDescriptor other) {
            return Comparator.comparing(ConfigurationMethodDescriptor::name).thenComparing((a, b) -> Arrays.compare((Comparable[])((ConfigurationTypeDescriptor[])a.parameterTypes.toArray(ConfigurationTypeDescriptor[]::new)), (Comparable[])((ConfigurationTypeDescriptor[])b.parameterTypes.toArray(ConfigurationTypeDescriptor[]::new)))).compare(this, other);
        }

        public void printJson(JsonWriter writer) throws IOException {
            writer.appendObjectStart();
            writer.quote(ConfigurationParser.NAME_KEY).appendFieldSeparator().quote(this.name);
            if (this.parameterTypes != null) {
                writer.appendSeparator().quote(ConfigurationParser.PARAMETER_TYPES_KEY).appendFieldSeparator();
                JsonPrinter.printCollection((JsonWriter)writer, this.parameterTypes, Comparable::compareTo, JsonPrintable::printJson);
            }
        }
    }
}

