/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.shaded.org.capnproto;

import com.oracle.svm.shaded.org.capnproto.BufferedInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;

public final class ArrayInputStream
implements BufferedInputStream {
    public final ByteBuffer buf;

    public ArrayInputStream(ByteBuffer buf) {
        this.buf = buf.asReadOnlyBuffer();
    }

    @Override
    public final int read(ByteBuffer dst) throws IOException {
        int available = this.buf.remaining();
        int size = Math.min(dst.remaining(), available);
        if (size == 0) {
            return -1;
        }
        ByteBuffer slice = this.buf.slice();
        slice.limit(size);
        dst.put(slice);
        this.buf.position(this.buf.position() + size);
        return size;
    }

    @Override
    public final ByteBuffer getReadBuffer() {
        return this.buf;
    }

    @Override
    public final void close() throws IOException {
    }

    @Override
    public final boolean isOpen() {
        return true;
    }
}

