/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.objectfile.debugentry;

import com.oracle.objectfile.debugentry.CompiledMethodEntry;
import com.oracle.objectfile.debugentry.DebugInfoBase;
import com.oracle.objectfile.debugentry.DirEntry;
import com.oracle.objectfile.debugentry.FieldEntry;
import com.oracle.objectfile.debugentry.FileEntry;
import com.oracle.objectfile.debugentry.ForeignTypeEntry;
import com.oracle.objectfile.debugentry.InterfaceClassEntry;
import com.oracle.objectfile.debugentry.LoaderEntry;
import com.oracle.objectfile.debugentry.MethodEntry;
import com.oracle.objectfile.debugentry.StructureTypeEntry;
import com.oracle.objectfile.debugentry.TypeEntry;
import com.oracle.objectfile.debugentry.range.PrimaryRange;
import com.oracle.objectfile.debugentry.range.Range;
import com.oracle.objectfile.debugentry.range.SubRange;
import com.oracle.objectfile.debuginfo.DebugInfoProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import jdk.graal.compiler.debug.DebugContext;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.collections.EconomicMap;

public class ClassEntry
extends StructureTypeEntry {
    protected ClassEntry superClass;
    protected final List<InterfaceClassEntry> interfaces = new ArrayList<InterfaceClassEntry>();
    private final FileEntry fileEntry;
    private LoaderEntry loader;
    protected final List<MethodEntry> methods = new ArrayList<MethodEntry>();
    private final EconomicMap<ResolvedJavaMethod, MethodEntry> methodsIndex = EconomicMap.create();
    private final List<CompiledMethodEntry> compiledEntries = new ArrayList<CompiledMethodEntry>();
    private final EconomicMap<Range, CompiledMethodEntry> compiledMethodIndex = EconomicMap.create();
    private final ArrayList<FileEntry> files;
    private final ArrayList<DirEntry> dirs;
    private EconomicMap<FileEntry, Integer> fileIndex;
    private EconomicMap<DirEntry, Integer> dirIndex;

    public ClassEntry(String className, FileEntry fileEntry, int size) {
        super(className, size);
        this.fileEntry = fileEntry;
        this.loader = null;
        this.files = new ArrayList();
        this.dirs = new ArrayList();
        this.fileIndex = null;
        this.dirIndex = null;
    }

    @Override
    public DebugInfoProvider.DebugTypeInfo.DebugTypeKind typeKind() {
        return DebugInfoProvider.DebugTypeInfo.DebugTypeKind.INSTANCE;
    }

    @Override
    public void addDebugInfo(DebugInfoBase debugInfoBase, DebugInfoProvider.DebugTypeInfo debugTypeInfo, DebugContext debugContext) {
        String loaderName;
        super.addDebugInfo(debugInfoBase, debugTypeInfo, debugContext);
        assert (debugTypeInfo.typeName().equals(this.typeName));
        DebugInfoProvider.DebugInstanceTypeInfo debugInstanceTypeInfo = (DebugInfoProvider.DebugInstanceTypeInfo)debugTypeInfo;
        ResolvedJavaType superType = debugInstanceTypeInfo.superClass();
        if (debugContext.isLogEnabled()) {
            debugContext.log("typename %s adding super %s%n", (Object)this.typeName, (Object)(superType != null ? superType.toJavaName() : ""));
        }
        if (superType != null) {
            this.superClass = debugInfoBase.lookupClassEntry(superType);
        }
        if (!(loaderName = debugInstanceTypeInfo.loaderName()).isEmpty()) {
            this.loader = debugInfoBase.ensureLoaderEntry(loaderName);
        }
        debugInstanceTypeInfo.interfaces().forEach(interfaceType -> this.processInterface((ResolvedJavaType)interfaceType, debugInfoBase, debugContext));
        debugInstanceTypeInfo.fieldInfoProvider().forEach(debugFieldInfo -> this.processField((DebugInfoProvider.DebugFieldInfo)debugFieldInfo, debugInfoBase, debugContext));
        debugInstanceTypeInfo.methodInfoProvider().forEach(debugMethodInfo -> this.processMethod((DebugInfoProvider.DebugMethodInfo)debugMethodInfo, debugInfoBase, debugContext));
    }

    public CompiledMethodEntry indexPrimary(PrimaryRange primary, List<DebugInfoProvider.DebugFrameSizeChange> frameSizeInfos, int frameSize) {
        assert (this.compiledMethodIndex.get((Object)primary) == null) : "repeat of primary range [0x%x, 0x%x]!".formatted(primary.getLo(), primary.getHi());
        CompiledMethodEntry compiledEntry = new CompiledMethodEntry(primary, frameSizeInfos, frameSize, this);
        this.compiledMethodIndex.put((Object)primary, (Object)compiledEntry);
        this.compiledEntries.add(compiledEntry);
        return compiledEntry;
    }

    public void indexSubRange(SubRange subrange) {
        Range primary = subrange.getPrimary();
        assert (primary != null);
        CompiledMethodEntry compiledEntry = (CompiledMethodEntry)this.compiledMethodIndex.get((Object)primary);
        assert (compiledEntry != null);
        assert (compiledEntry.getClassEntry() == this);
    }

    private void indexMethodEntry(MethodEntry methodEntry, ResolvedJavaMethod idMethod) {
        assert (this.methodsIndex.get((Object)idMethod) == null) : methodEntry.getSymbolName();
        this.methods.add(methodEntry);
        this.methodsIndex.put((Object)idMethod, (Object)methodEntry);
    }

    public String getFileName() {
        if (this.fileEntry != null) {
            return this.fileEntry.getFileName();
        }
        return "";
    }

    public String getFullFileName() {
        if (this.fileEntry != null) {
            return this.fileEntry.getFullName();
        }
        return null;
    }

    String getDirName() {
        if (this.fileEntry != null) {
            return this.fileEntry.getPathName();
        }
        return "";
    }

    public FileEntry getFileEntry() {
        return this.fileEntry;
    }

    public int getFileIdx() {
        return this.getFileIdx(this.getFileEntry());
    }

    public int getFileIdx(FileEntry file) {
        if (file == null || this.fileIndex == null) {
            return 0;
        }
        return (Integer)this.fileIndex.get((Object)file);
    }

    public DirEntry getDirEntry(FileEntry file) {
        if (file == null) {
            return null;
        }
        return file.getDirEntry();
    }

    public int getDirIdx(FileEntry file) {
        DirEntry dirEntry = this.getDirEntry(file);
        return this.getDirIdx(dirEntry);
    }

    public int getDirIdx(DirEntry dir) {
        if (dir == null || dir.getPathString().isEmpty() || this.dirIndex == null) {
            return 0;
        }
        return (Integer)this.dirIndex.get((Object)dir);
    }

    public String getLoaderId() {
        return this.loader != null ? this.loader.getLoaderId() : "";
    }

    public Stream<CompiledMethodEntry> compiledEntries() {
        return this.compiledEntries.stream();
    }

    protected void processInterface(ResolvedJavaType interfaceType, DebugInfoBase debugInfoBase, DebugContext debugContext) {
        if (debugContext.isLogEnabled()) {
            debugContext.log("typename %s adding interface %s%n", (Object)this.typeName, (Object)interfaceType.toJavaName());
        }
        ClassEntry entry = debugInfoBase.lookupClassEntry(interfaceType);
        assert (entry instanceof InterfaceClassEntry || entry instanceof ForeignTypeEntry && this instanceof ForeignTypeEntry);
        InterfaceClassEntry interfaceClassEntry = (InterfaceClassEntry)entry;
        this.interfaces.add(interfaceClassEntry);
        interfaceClassEntry.addImplementor(this, debugContext);
    }

    protected MethodEntry processMethod(DebugInfoProvider.DebugMethodInfo debugMethodInfo, DebugInfoBase debugInfoBase, DebugContext debugContext) {
        String methodName = debugMethodInfo.name();
        int line = debugMethodInfo.line();
        ResolvedJavaType resultType = debugMethodInfo.valueType();
        int modifiers = debugMethodInfo.modifiers();
        DebugInfoProvider.DebugLocalInfo[] paramInfos = debugMethodInfo.getParamInfo();
        DebugInfoProvider.DebugLocalInfo thisParam = debugMethodInfo.getThisParamInfo();
        int paramCount = paramInfos.length;
        if (debugContext.isLogEnabled()) {
            String resultTypeName = resultType.toJavaName();
            debugContext.log("typename %s adding %s method %s %s(%s)%n", (Object)this.typeName, (Object)this.memberModifiers(modifiers), (Object)resultTypeName, (Object)methodName, (Object)ClassEntry.formatParams(paramInfos));
        }
        TypeEntry resultTypeEntry = debugInfoBase.lookupTypeEntry(resultType);
        TypeEntry[] typeEntries = new TypeEntry[paramCount];
        for (int i = 0; i < paramCount; ++i) {
            typeEntries[i] = debugInfoBase.lookupTypeEntry(paramInfos[i].valueType());
        }
        FileEntry methodFileEntry = debugInfoBase.ensureFileEntry(debugMethodInfo);
        MethodEntry methodEntry = new MethodEntry(debugInfoBase, debugMethodInfo, methodFileEntry, line, methodName, this, resultTypeEntry, typeEntries, paramInfos, thisParam);
        this.indexMethodEntry(methodEntry, debugMethodInfo.idMethod());
        return methodEntry;
    }

    @Override
    protected FieldEntry createField(DebugInfoProvider.DebugFieldInfo debugFieldInfo, DebugInfoBase debugInfoBase, DebugContext debugContext) {
        FieldEntry fieldEntry = super.createField(debugFieldInfo, debugInfoBase, debugContext);
        return fieldEntry;
    }

    private static String formatParams(DebugInfoProvider.DebugLocalInfo[] paramInfo) {
        if (paramInfo.length == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < paramInfo.length; ++i) {
            if (i > 0) {
                builder.append(", ");
            }
            builder.append(paramInfo[i].typeName());
            builder.append(' ');
            builder.append(paramInfo[i].name());
        }
        return builder.toString();
    }

    public int compiledEntryCount() {
        return this.compiledEntries.size();
    }

    public boolean hasCompiledEntries() {
        return this.compiledEntryCount() != 0;
    }

    public long compiledEntriesBase() {
        assert (this.hasCompiledEntries());
        return this.compiledEntries.get(0).getPrimary().getLo();
    }

    public ClassEntry getSuperClass() {
        return this.superClass;
    }

    public MethodEntry ensureMethodEntryForDebugRangeInfo(DebugInfoProvider.DebugRangeInfo debugRangeInfo, DebugInfoBase debugInfoBase, DebugContext debugContext) {
        MethodEntry methodEntry = (MethodEntry)this.methodsIndex.get((Object)debugRangeInfo.idMethod());
        if (methodEntry == null) {
            methodEntry = this.processMethod(debugRangeInfo, debugInfoBase, debugContext);
        } else {
            methodEntry.updateRangeInfo(debugInfoBase, debugRangeInfo);
        }
        return methodEntry;
    }

    public List<MethodEntry> getMethods() {
        return this.methods;
    }

    public long lowpc() {
        assert (this.hasCompiledEntries());
        return this.compiledEntries.get(0).getPrimary().getLo();
    }

    public long hipc() {
        assert (this.hasCompiledEntries());
        return this.compiledEntries.get(this.compiledEntries.size() - 1).getPrimary().getHi();
    }

    public void includeFile(FileEntry file) {
        assert (!this.files.contains(file)) : "caller should ensure file is only included once";
        assert (this.fileIndex == null) : "cannot include files after index has been created";
        this.files.add(file);
    }

    public void includeDir(DirEntry dirEntry) {
        assert (!this.dirs.contains(dirEntry)) : "caller should ensure dir is only included once";
        assert (this.dirIndex == null) : "cannot include dirs after index has been created";
        this.dirs.add(dirEntry);
    }

    public void buildFileAndDirIndexes() {
        assert (this.fileIndex == null && this.dirIndex == null) : "file and indexes can only be generated once";
        if (this.files.isEmpty()) assert (this.dirs.isEmpty()) : "should not have included any dirs if we have no files";
        int idx = 1;
        this.fileIndex = EconomicMap.create((int)this.files.size());
        for (FileEntry file : this.files) {
            this.fileIndex.put((Object)file, (Object)idx++);
        }
        this.dirIndex = EconomicMap.create((int)this.dirs.size());
        idx = 1;
        for (DirEntry dir : this.dirs) {
            if (!dir.getPathString().isEmpty()) {
                this.dirIndex.put((Object)dir, (Object)idx++);
                continue;
            }
            assert (idx == 1);
        }
    }

    public Stream<FileEntry> fileStream() {
        if (!this.files.isEmpty()) {
            return this.files.stream();
        }
        return Stream.empty();
    }

    public Stream<DirEntry> dirStream() {
        if (!this.dirs.isEmpty()) {
            return this.dirs.stream();
        }
        return Stream.empty();
    }
}

