/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.objectfile.debugentry;

import com.oracle.objectfile.debugentry.ClassEntry;
import com.oracle.objectfile.debugentry.DebugInfoBase;
import com.oracle.objectfile.debugentry.FileEntry;
import com.oracle.objectfile.debuginfo.DebugInfoProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import jdk.graal.compiler.debug.DebugContext;

public class InterfaceClassEntry
extends ClassEntry {
    private final List<ClassEntry> implementors = new ArrayList<ClassEntry>();

    public InterfaceClassEntry(String className, FileEntry fileEntry, int size) {
        super(className, fileEntry, size);
    }

    @Override
    public DebugInfoProvider.DebugTypeInfo.DebugTypeKind typeKind() {
        return DebugInfoProvider.DebugTypeInfo.DebugTypeKind.INTERFACE;
    }

    @Override
    public void addDebugInfo(DebugInfoBase debugInfoBase, DebugInfoProvider.DebugTypeInfo debugTypeInfo, DebugContext debugContext) {
        assert (debugTypeInfo instanceof DebugInfoProvider.DebugInterfaceTypeInfo);
        super.addDebugInfo(debugInfoBase, debugTypeInfo, debugContext);
    }

    public void addImplementor(ClassEntry classEntry, DebugContext debugContext) {
        this.implementors.add(classEntry);
        if (debugContext.isLogEnabled()) {
            debugContext.log("typename %s add implementor %s%n", (Object)this.typeName, (Object)classEntry.getTypeName());
        }
    }

    public Stream<ClassEntry> implementors() {
        return this.implementors.stream();
    }

    @Override
    public int getSize() {
        int maxSize = this.size;
        for (ClassEntry implementor : this.implementors) {
            int nextSize = implementor.getSize();
            if (nextSize <= maxSize) continue;
            maxSize = nextSize;
        }
        return maxSize;
    }
}

