/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.objectfile.pecoff.cv;

import com.oracle.objectfile.debugentry.ClassEntry;
import com.oracle.objectfile.pecoff.cv.CVDebugInfo;
import com.oracle.objectfile.pecoff.cv.CVUtil;
import java.util.HashMap;
import java.util.Map;

abstract class CVSymbolSubrecord {
    private int subrecordStartPosition;
    private final short cmd;
    protected final CVDebugInfo cvDebugInfo;

    CVSymbolSubrecord(CVDebugInfo cvDebugInfo, short cmd) {
        this.cvDebugInfo = cvDebugInfo;
        this.cmd = cmd;
    }

    final int computeFullContents(byte[] buffer, int initialPos) {
        this.subrecordStartPosition = initialPos;
        int pos = initialPos;
        pos += 2;
        pos = CVUtil.putShort(this.cmd, buffer, pos);
        pos = this.computeContents(buffer, pos);
        short length = (short)(pos - initialPos - 2);
        CVUtil.putShort(length, buffer, initialPos);
        return pos;
    }

    public String toString() {
        return String.format("CVSymbolSubrecord(pos=0x%06x cmd=0x%04x)", this.subrecordStartPosition, this.cmd);
    }

    public int getPos() {
        return this.subrecordStartPosition;
    }

    public int getCommand() {
        return this.cmd;
    }

    protected abstract int computeContents(byte[] var1, int var2);

    public static class CVSymbolEndRecord
    extends CVSymbolSubrecord {
        CVSymbolEndRecord(CVDebugInfo cvDebugInfo, short cmd) {
            super(cvDebugInfo, cmd);
        }

        CVSymbolEndRecord(CVDebugInfo cvDebugInfo) {
            this(cvDebugInfo, 6);
        }

        @Override
        protected int computeContents(byte[] buffer, int initialPos) {
            return initialPos;
        }

        @Override
        public String toString() {
            return "S_END";
        }
    }

    public static final class CVSymbolUDTRecord
    extends CVSymbolSubrecord {
        private final int typeIdx;
        private final String typeName;

        CVSymbolUDTRecord(CVDebugInfo cvDebugInfo, int typeIdx, String typeName) {
            super(cvDebugInfo, (short)4360);
            this.typeIdx = typeIdx;
            this.typeName = typeName;
        }

        @Override
        protected int computeContents(byte[] buffer, int initialPos) {
            int pos = CVUtil.putInt(this.typeIdx, buffer, initialPos);
            pos = CVUtil.putUTF8StringBytes(this.typeName, buffer, pos);
            return pos;
        }

        @Override
        public String toString() {
            return String.format("S_UDT type=0x%x typename=%s", this.typeIdx, this.typeName);
        }
    }

    public static final class CVSymbolFrameProcRecord
    extends CVSymbolSubrecord {
        private final int framelen;
        private final int padLen;
        private final int padOffset;
        private final int saveRegsCount;
        private final int ehOffset;
        private final short ehSection;
        private final int flags;

        CVSymbolFrameProcRecord(CVDebugInfo cvDebugInfo, int framelen, int padLen, int padOffset, int saveRegsCount, int ehOffset, short ehSection, int flags) {
            super(cvDebugInfo, (short)4114);
            this.framelen = framelen;
            this.padLen = padLen;
            this.padOffset = padOffset;
            this.saveRegsCount = saveRegsCount;
            this.ehOffset = ehOffset;
            this.ehSection = ehSection;
            this.flags = flags;
        }

        CVSymbolFrameProcRecord(CVDebugInfo cvDebugInfo, int framelen, int flags) {
            this(cvDebugInfo, framelen, 0, 0, 0, 0, 0, flags);
        }

        @Override
        protected int computeContents(byte[] buffer, int initialPos) {
            int pos = CVUtil.putInt(this.framelen, buffer, initialPos);
            pos = CVUtil.putInt(this.padLen, buffer, pos);
            pos = CVUtil.putInt(this.padOffset, buffer, pos);
            pos = CVUtil.putInt(this.saveRegsCount, buffer, pos);
            pos = CVUtil.putInt(this.ehOffset, buffer, pos);
            pos = CVUtil.putShort(this.ehSection, buffer, pos);
            pos = CVUtil.putInt(this.flags, buffer, pos);
            return pos;
        }

        @Override
        public String toString() {
            return String.format("S_FRAMEPROC len=0x%x padlen=0x%x paddOffset=0x%x regCount=%d flags=0x%x ", this.framelen, this.padLen, this.padOffset, this.saveRegsCount, this.flags);
        }
    }

    public static class CVSymbolGProc32Record
    extends CVSymbolSubrecord {
        private final int pparent;
        private final int pend;
        private final int pnext;
        private final long proclen;
        private final int debugStart;
        private final int debugEnd;
        private final int typeIndex;
        private final short segment;
        private final byte flags;
        private final String symbolName;
        private final String displayName;

        CVSymbolGProc32Record(CVDebugInfo cvDebugInfo, String symbolName, String displayName, int pparent, int pend, int pnext, long proclen, int debugStart, int debugEnd, int typeIndex, short segment, byte flags) {
            super(cvDebugInfo, (short)4368);
            this.symbolName = symbolName;
            this.displayName = displayName;
            this.pparent = pparent;
            this.pend = pend;
            this.pnext = pnext;
            this.proclen = proclen;
            this.debugStart = debugStart;
            this.debugEnd = debugEnd;
            this.typeIndex = typeIndex;
            this.segment = segment;
            this.flags = flags;
        }

        @Override
        protected int computeContents(byte[] buffer, int initialPos) {
            int pos = CVUtil.putInt(this.pparent, buffer, initialPos);
            pos = CVUtil.putInt(this.pend, buffer, pos);
            pos = CVUtil.putInt(this.pnext, buffer, pos);
            pos = CVUtil.putLongAsInt(this.proclen, buffer, pos);
            pos = CVUtil.putInt(this.debugStart, buffer, pos);
            pos = CVUtil.putInt(this.debugEnd, buffer, pos);
            pos = CVUtil.putInt(this.typeIndex, buffer, pos);
            pos = this.cvDebugInfo.getCVSymbolSection().markRelocationSite(buffer, pos, this.symbolName);
            pos = CVUtil.putByte(this.flags, buffer, pos);
            pos = CVUtil.putUTF8StringBytes(this.displayName, buffer, pos);
            return pos;
        }

        @Override
        public String toString() {
            return String.format("S_GPROC32   name=%s/%s parent=%d debugstart=0x%x debugend=0x%x len=0x%x seg:offset=0x%x:0 type=0x%x flags=0x%x)", this.displayName, this.symbolName, this.pparent, this.debugStart, this.debugEnd, this.proclen, this.segment, this.typeIndex, this.flags);
        }
    }

    public static class CVSymbolRegRel32Record
    extends CVSymbolSubrecord {
        private final String name;
        private final int typeIndex;
        private final int offset;
        private final short register;

        CVSymbolRegRel32Record(CVDebugInfo debugInfo, String name, int typeIndex, int offset, short register) {
            super(debugInfo, (short)4369);
            this.name = name;
            this.typeIndex = typeIndex;
            this.offset = offset;
            this.register = register;
        }

        @Override
        protected int computeContents(byte[] buffer, int initialPos) {
            int pos = CVUtil.putInt(this.offset, buffer, initialPos);
            pos = CVUtil.putInt(this.typeIndex, buffer, pos);
            pos = CVUtil.putShort(this.register, buffer, pos);
            pos = CVUtil.putUTF8StringBytes(this.name, buffer, pos);
            return pos;
        }

        @Override
        public String toString() {
            return String.format("S_REGREL32   name=%s  offset=(r%d + 0x%x) type=0x%x)", this.name, this.register, this.offset, this.typeIndex);
        }
    }

    public static class CVSymbolLData32Record
    extends CVSymbolData32Record {
        CVSymbolLData32Record(CVDebugInfo cvDebugInfo, String symbolName, String displayName, int typeIndex, int offset, short segment) {
            super(cvDebugInfo, (short)4364, symbolName, displayName, typeIndex, offset, segment);
        }

        CVSymbolLData32Record(CVDebugInfo cvDebugInfo, String symbolName, int typeIndex, int offset, short segment) {
            super(cvDebugInfo, (short)4364, symbolName, symbolName, typeIndex, offset, segment);
        }

        @Override
        public String toString() {
            return String.format("S_LDATA32   name=%s(%s) offset=0x%x type=0x%x", this.symbolName, this.displayName, this.offset, this.typeIndex);
        }
    }

    public static class CVSymbolGData32Record
    extends CVSymbolData32Record {
        CVSymbolGData32Record(CVDebugInfo cvDebugInfo, String symbolName, String displayName, int typeIndex, int offset, short segment) {
            super(cvDebugInfo, (short)4365, symbolName, displayName, typeIndex, offset, segment);
        }

        @Override
        public String toString() {
            return String.format("S_GDATA32   name=%s(%s) offset=0x%x type=0x%x", this.symbolName, this.displayName, this.offset, this.typeIndex);
        }
    }

    private static abstract class CVSymbolData32Record
    extends CVSymbolSubrecord {
        protected final int typeIndex;
        protected final int offset;
        protected final short segment;
        protected final String displayName;
        protected final String symbolName;

        protected CVSymbolData32Record(CVDebugInfo cvDebugInfo, short cmd, String symbolName, String displayName, int typeIndex, int offset, short segment) {
            super(cvDebugInfo, cmd);
            assert (symbolName != null);
            this.displayName = displayName;
            this.symbolName = symbolName;
            this.typeIndex = typeIndex;
            this.offset = offset;
            this.segment = segment;
        }

        @Override
        protected int computeContents(byte[] buffer, int initialPos) {
            int pos = CVUtil.putInt(this.typeIndex, buffer, initialPos);
            pos = this.cvDebugInfo.getCVSymbolSection().markRelocationSite(buffer, pos, this.symbolName, (long)this.offset);
            pos = CVUtil.putUTF8StringBytes(this.displayName, buffer, pos);
            return pos;
        }
    }

    public static final class CVEnvBlockRecord
    extends CVSymbolSubrecord {
        private static final int ENVMAP_INITIAL_CAPACITY = 10;
        private final Map<String, String> map = new HashMap<String, String>(10);

        CVEnvBlockRecord(CVDebugInfo cvDebugInfo) {
            super(cvDebugInfo, (short)4413);
            this.map.put("cwd", System.getProperty("user.dir"));
            String fn = CVEnvBlockRecord.findFirstFile(cvDebugInfo);
            if (fn != null) {
                this.map.put("src", fn);
            }
        }

        private static String findFirstFile(CVDebugInfo cvDebugInfo) {
            String fn = null;
            for (ClassEntry classEntry : cvDebugInfo.getInstanceClasses()) {
                if (classEntry.getFileName() == null) continue;
                fn = classEntry.getFileEntry().getFileName();
                break;
            }
            return fn;
        }

        @Override
        protected int computeContents(byte[] buffer, int initialPos) {
            int pos = CVUtil.putByte((byte)0, buffer, initialPos);
            for (Map.Entry<String, String> entry : this.map.entrySet()) {
                pos = CVUtil.putUTF8StringBytes(entry.getKey(), buffer, pos);
                pos = CVUtil.putUTF8StringBytes(entry.getValue(), buffer, pos);
            }
            pos = CVUtil.putUTF8StringBytes("", buffer, pos);
            return pos;
        }

        @Override
        public String toString() {
            return "S_ENVBLOCK " + this.map.size() + " entries";
        }
    }

    public static final class CVCompile3Record
    extends CVSymbolSubrecord {
        private static final byte HAS_DEBUG_FLAG = 0;
        private static final byte HAS_NO_DEBUG_FLAG = -128;
        private final byte language;
        private final byte cf1;
        private final byte cf2;
        private final byte padding;
        private final short machine = (short)208;
        private final short feMajor = (short)2;
        private final short feMinor = (short)3;
        private final short feBuild = (short)4;
        private final short feQFE = (short)5;
        private final short beMajor = (short)6;
        private final short beMinor = (short)7;
        private final short beBuild = (short)8;
        private final short beQFE = (short)9;
        private final String compiler;

        CVCompile3Record(CVDebugInfo cvDebugInfo) {
            super(cvDebugInfo, (short)4412);
            this.language = 0;
            this.cf1 = 0;
            this.cf2 = 0;
            this.padding = 0;
            this.compiler = "graal";
        }

        @Override
        protected int computeContents(byte[] buffer, int initialPos) {
            int pos = CVUtil.putByte(this.language, buffer, initialPos);
            pos = CVUtil.putByte(this.cf1, buffer, pos);
            pos = CVUtil.putByte(this.cf2, buffer, pos);
            pos = CVUtil.putByte(this.padding, buffer, pos);
            pos = CVUtil.putShort(this.machine, buffer, pos);
            pos = CVUtil.putShort(this.feMajor, buffer, pos);
            pos = CVUtil.putShort(this.feMinor, buffer, pos);
            pos = CVUtil.putShort(this.feBuild, buffer, pos);
            pos = CVUtil.putShort(this.feQFE, buffer, pos);
            pos = CVUtil.putShort(this.beMajor, buffer, pos);
            pos = CVUtil.putShort(this.beMinor, buffer, pos);
            pos = CVUtil.putShort(this.beBuild, buffer, pos);
            pos = CVUtil.putShort(this.beQFE, buffer, pos);
            pos = CVUtil.putUTF8StringBytes(this.compiler, buffer, pos);
            return pos;
        }

        @Override
        public String toString() {
            return String.format("S_COMPILE3 machine=%d fe=%d.%d.%d.%d be=%d.%d.%d%d compiler=%s", this.machine, this.feMajor, this.feMinor, this.feBuild, this.feQFE, this.beMajor, this.beMinor, this.beBuild, this.beQFE, this.compiler);
        }
    }

    public static final class CVObjectNameRecord
    extends CVSymbolSubrecord {
        private final String objName;

        CVObjectNameRecord(CVDebugInfo cvDebugInfo, String objName) {
            super(cvDebugInfo, (short)4353);
            this.objName = objName;
        }

        CVObjectNameRecord(CVDebugInfo cvDebugInfo) {
            this(cvDebugInfo, CVObjectNameRecord.findObjectName(cvDebugInfo));
        }

        private static String findObjectName(CVDebugInfo cvDebugInfo) {
            Object fn = null;
            for (ClassEntry classEntry : cvDebugInfo.getInstanceClasses()) {
                if (classEntry.getFileName() == null) continue;
                fn = classEntry.getFileEntry().getFileName();
                if (!((String)fn).endsWith(".java")) break;
                fn = ((String)fn).substring(0, ((String)fn).lastIndexOf(".java")) + ".obj";
                break;
            }
            return fn;
        }

        boolean isValid() {
            return this.objName != null;
        }

        @Override
        protected int computeContents(byte[] buffer, int initialPos) {
            int pos = CVUtil.putInt(0, buffer, initialPos);
            pos = CVUtil.putUTF8StringBytes(this.objName, buffer, pos);
            return pos;
        }

        @Override
        public String toString() {
            return "S_OBJNAME " + this.objName;
        }
    }
}

