/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.foreign;

import com.oracle.svm.core.foreign.JavaEntryPointInfo;
import com.oracle.svm.core.jdk.InternalVMMethod;
import java.lang.invoke.MethodType;
import jdk.graal.compiler.util.Digest;
import jdk.internal.foreign.abi.VMStorage;
import jdk.vm.ci.meta.ConstantPool;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

@InternalVMMethod
public final class UpcallStubsHolder {
    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static ConstantPool getConstantPool(MetaAccessProvider metaAccess) {
        return metaAccess.lookupJavaType(UpcallStubsHolder.class).getDeclaredConstructors()[0].getConstantPool();
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static String stubName(JavaEntryPointInfo jep, boolean highLevel, boolean direct) {
        MethodType type = jep.handleType();
        StringBuilder builder = new StringBuilder();
        if (direct) {
            builder.append("direct_");
        }
        builder.append("upcall");
        builder.append(highLevel ? "High" : "Low");
        builder.append("_");
        for (Class<?> param : type.parameterArray()) {
            builder.append(JavaKind.fromJavaClass(param).getTypeChar());
        }
        builder.append("_");
        builder.append(JavaKind.fromJavaClass((Class)type.returnType()).getTypeChar());
        if (jep.buffersReturn()) {
            builder.append("_r");
        }
        StringBuilder assignmentsBuilder = new StringBuilder();
        for (VMStorage assignment : jep.parametersAssignment()) {
            assignmentsBuilder.append(assignment);
        }
        assignmentsBuilder.append('_');
        for (VMStorage assignment : jep.returnAssignment()) {
            assignmentsBuilder.append(assignment);
        }
        builder.append('_');
        builder.append(Digest.digest((String)assignmentsBuilder.toString()));
        return builder.toString();
    }

    private UpcallStubsHolder() {
    }
}

