/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.jdwp.server.impl;

import com.oracle.svm.jdwp.bridge.EventKind;
import com.oracle.svm.jdwp.server.api.BreakpointInfo;
import com.oracle.svm.jdwp.server.impl.Breakpoints;
import com.oracle.svm.jdwp.server.impl.RequestFilter;

public abstract class AbstractBreakpointInfo
implements BreakpointInfo {
    private final RequestFilter filter;
    private final Runnable breakRemoval;
    private byte suspendPolicy;

    public AbstractBreakpointInfo(RequestFilter filter, Breakpoints breakpoints) {
        this.filter = filter;
        this.breakRemoval = () -> breakpoints.remove(this);
    }

    @Override
    public RequestFilter getFilter() {
        return this.filter;
    }

    @Override
    public int getRequestId() {
        return this.filter.getRequestId();
    }

    @Override
    public EventKind getEventKind() {
        return this.filter.getEventKind();
    }

    @Override
    public void addSuspendPolicy(byte policy) {
        this.suspendPolicy = policy;
    }

    @Override
    public byte getSuspendPolicy() {
        return this.suspendPolicy;
    }

    @Override
    public long getClassId() {
        return 0L;
    }

    @Override
    public long getMethodId() {
        return 0L;
    }

    @Override
    public long getBci() {
        return 0L;
    }

    @Override
    public Runnable getBreakRemoval() {
        return this.breakRemoval;
    }
}

