/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.jdwp.server.impl;

import com.oracle.svm.jdwp.bridge.JDWPException;
import com.oracle.svm.jdwp.bridge.SymbolicRefs;
import com.oracle.svm.jdwp.server.ClassUtils;
import com.oracle.svm.jdwp.server.impl.ServerJDWP;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;

public final class ServerSymbolicRefs
implements SymbolicRefs {
    public long toTypeRef(ResolvedJavaType resolvedJavaType) {
        if (resolvedJavaType == null) {
            return 0L;
        }
        int typeRefIndex = ClassUtils.UNIVERSE.getTypeIndexFor(resolvedJavaType).orElseThrow(IllegalArgumentException::new);
        return ServerJDWP.BRIDGE.typeRefIndexToId(typeRefIndex);
    }

    public long toFieldRef(ResolvedJavaField resolvedJavaField) {
        if (resolvedJavaField == null) {
            return 0L;
        }
        int fieldRefIndex = ClassUtils.UNIVERSE.getFieldIndexFor(resolvedJavaField).orElseThrow(IllegalArgumentException::new);
        return ServerJDWP.BRIDGE.fieldRefIndexToId(fieldRefIndex);
    }

    public long toMethodRef(ResolvedJavaMethod resolvedJavaMethod) {
        if (resolvedJavaMethod == null) {
            return 0L;
        }
        int fieldRefIndex = ClassUtils.UNIVERSE.getMethodIndexFor(resolvedJavaMethod).orElseThrow(IllegalArgumentException::new);
        return ServerJDWP.BRIDGE.methodRefIndexToId(fieldRefIndex);
    }

    public ResolvedJavaType toResolvedJavaType(long typeRefId) throws JDWPException {
        if (typeRefId == 0L) {
            return null;
        }
        int typeRefIndex = ServerJDWP.BRIDGE.typeRefIdToIndex(typeRefId);
        return ClassUtils.UNIVERSE.getTypeAtIndex(typeRefIndex);
    }

    public ResolvedJavaField toResolvedJavaField(long fieldRefId) throws JDWPException {
        if (fieldRefId == 0L) {
            return null;
        }
        int fieldRefIndex = ServerJDWP.BRIDGE.fieldRefIdToIndex(fieldRefId);
        return ClassUtils.UNIVERSE.getFieldAtIndex(fieldRefIndex);
    }

    public ResolvedJavaMethod toResolvedJavaMethod(long methodRefId) throws JDWPException {
        if (methodRefId == 0L) {
            return null;
        }
        int methodRefIndex = ServerJDWP.BRIDGE.methodRefIdToIndex(methodRefId);
        return ClassUtils.UNIVERSE.getMethodAtIndex(methodRefIndex);
    }
}

