/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.collections;

import com.oracle.svm.core.Uninterruptible;

public final class EnumBitmask {
    private EnumBitmask() {
    }

    public static int computeBitmask(Enum<?>[] flags) {
        int result = 0;
        for (Enum<?> flag : flags) {
            assert (flag.ordinal() <= 31);
            result |= EnumBitmask.flagBit(flag);
        }
        return result;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static boolean hasBit(int bitmask, Enum<?> flag) {
        return (bitmask & EnumBitmask.flagBit(flag)) != 0;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static int flagBit(Enum<?> flag) {
        assert (flag.ordinal() < 32);
        return 1 << flag.ordinal();
    }
}

