/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.AlwaysInline;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.genscavenge.AlignedHeapChunk;
import com.oracle.svm.core.genscavenge.GCImpl;
import com.oracle.svm.core.genscavenge.GreyObjectsWalker;
import com.oracle.svm.core.genscavenge.GreyToBlackObjRefVisitor;
import com.oracle.svm.core.genscavenge.GreyToBlackObjectVisitor;
import com.oracle.svm.core.genscavenge.HeapChunk;
import com.oracle.svm.core.genscavenge.HeapParameters;
import com.oracle.svm.core.genscavenge.HeapVerifier;
import com.oracle.svm.core.genscavenge.OldGeneration;
import com.oracle.svm.core.genscavenge.Space;
import com.oracle.svm.core.genscavenge.Timers;
import com.oracle.svm.core.genscavenge.UnalignedHeapChunk;
import com.oracle.svm.core.genscavenge.remset.RememberedSet;
import com.oracle.svm.core.heap.ObjectVisitor;
import com.oracle.svm.core.log.Log;
import jdk.graal.compiler.word.Word;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;

final class CopyingOldGeneration
extends OldGeneration {
    private final Space fromSpace;
    private final Space toSpace;
    private final GreyObjectsWalker toGreyObjectsWalker = new GreyObjectsWalker();

    @Platforms(value={Platform.HOSTED_ONLY.class})
    CopyingOldGeneration(String name) {
        super(name);
        int age = HeapParameters.getMaxSurvivorSpaces() + 1;
        this.fromSpace = new Space("Old", "O", false, age);
        this.toSpace = new Space("Old To", "O", true, age);
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    void tearDown() {
        this.fromSpace.tearDown();
        this.toSpace.tearDown();
    }

    @Override
    public void walkObjects(ObjectVisitor visitor) {
        this.getFromSpace().walkObjects(visitor);
        this.getToSpace().walkObjects(visitor);
    }

    @Override
    @AlwaysInline(value="GC performance")
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public Object promoteAlignedObject(Object original, AlignedHeapChunk.AlignedHeader originalChunk, Space originalSpace) {
        assert (originalSpace.isFromSpace());
        return this.getToSpace().copyAlignedObject(original, originalSpace);
    }

    @Override
    @AlwaysInline(value="GC performance")
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    protected Object promoteUnalignedObject(Object original, UnalignedHeapChunk.UnalignedHeader originalChunk, Space originalSpace) {
        assert (originalSpace.isFromSpace());
        this.getToSpace().promoteUnalignedHeapChunk(originalChunk, originalSpace);
        return original;
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    protected boolean promotePinnedObject(Object obj, HeapChunk.Header<?> originalChunk, boolean isAligned, Space originalSpace) {
        assert (originalSpace.isFromSpace());
        if (isAligned) {
            this.getToSpace().promoteAlignedHeapChunk((AlignedHeapChunk.AlignedHeader)originalChunk, originalSpace);
        } else {
            this.getToSpace().promoteUnalignedHeapChunk((UnalignedHeapChunk.UnalignedHeader)originalChunk, originalSpace);
        }
        return true;
    }

    @Override
    void releaseSpaces(GCImpl.ChunkReleaser chunkReleaser) {
        this.getFromSpace().releaseChunks(chunkReleaser);
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    void beginPromotion(boolean incrementalGc) {
        if (incrementalGc) {
            this.emptyFromSpaceIntoToSpace();
        }
        this.toGreyObjectsWalker.setScanStart(this.getToSpace());
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    boolean scanGreyObjects(boolean incrementalGc) {
        if (!this.toGreyObjectsWalker.haveGreyObjects()) {
            return false;
        }
        this.toGreyObjectsWalker.walkGreyObjects();
        return true;
    }

    @Override
    public void logUsage(Log log) {
        this.getFromSpace().logUsage(log, true);
        this.getToSpace().logUsage(log, false);
    }

    @Override
    public void logChunks(Log log) {
        this.getFromSpace().logChunks(log);
        this.getToSpace().logChunks(log);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    Space getFromSpace() {
        return this.fromSpace;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    Space getToSpace() {
        return this.toSpace;
    }

    @Override
    void appendChunk(AlignedHeapChunk.AlignedHeader hdr) {
        this.getToSpace().appendAlignedHeapChunk(hdr, null);
    }

    @Override
    void swapSpaces() {
        assert (this.getFromSpace().isEmpty()) : "fromSpace should be empty.";
        this.getFromSpace().absorb(this.getToSpace());
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    void blackenDirtyCardRoots(GreyToBlackObjectVisitor visitor, GreyToBlackObjRefVisitor refVisitor) {
        RememberedSet.get().walkDirtyObjects(this.toSpace.getFirstAlignedHeapChunk(), this.toSpace.getFirstUnalignedHeapChunk(), (UnalignedHeapChunk.UnalignedHeader)Word.nullPointer(), visitor, refVisitor, true);
    }

    @Override
    boolean isInSpace(Pointer ptr) {
        return this.fromSpace.contains(ptr) || this.toSpace.contains(ptr);
    }

    @Override
    boolean printLocationInfo(Log log, Pointer ptr) {
        return this.fromSpace.printLocationInfo(log, ptr) || this.toSpace.printLocationInfo(log, ptr);
    }

    @Override
    boolean verifyRememberedSets() {
        boolean success = true;
        success &= HeapVerifier.verifyRememberedSet(this.toSpace);
        return success &= HeapVerifier.verifyRememberedSet(this.fromSpace);
    }

    @Override
    boolean verifySpaces() {
        boolean success = true;
        if (!this.toSpace.isEmpty()) {
            Log.log().string("Old generation to-space contains chunks: firstAlignedChunk: ").zhex((WordBase)this.toSpace.getFirstAlignedHeapChunk()).string(", firstUnalignedChunk: ").zhex((WordBase)this.toSpace.getFirstUnalignedHeapChunk()).newline();
            success = false;
        }
        success &= HeapVerifier.verifySpace(this.fromSpace);
        return success &= HeapVerifier.verifySpace(this.toSpace);
    }

    @Override
    void sweepAndCompact(Timers timers, GCImpl.ChunkReleaser chunkReleaser) {
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    void emptyFromSpaceIntoToSpace() {
        this.getToSpace().absorb(this.getFromSpace());
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    UnsignedWord getChunkBytes() {
        return this.fromSpace.getChunkBytes().add(this.toSpace.getChunkBytes());
    }

    @Override
    UnsignedWord computeObjectBytes() {
        return this.fromSpace.computeObjectBytes().add(this.toSpace.computeObjectBytes());
    }

    @Override
    void checkSanityBeforeCollection() {
        assert (this.toSpace.isEmpty()) : "toSpace should be empty before a collection.";
    }

    @Override
    void checkSanityAfterCollection() {
        assert (this.toSpace.isEmpty()) : "toSpace should be empty after a collection.";
    }
}

