/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.AlwaysInline;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.genscavenge.HeapChunk;
import com.oracle.svm.core.genscavenge.HeapImpl;
import com.oracle.svm.core.genscavenge.remset.RememberedSet;
import com.oracle.svm.core.heap.ObjectVisitor;
import com.oracle.svm.core.heap.UninterruptibleObjectVisitor;
import com.oracle.svm.core.util.HostedByteBufferPointer;
import com.oracle.svm.core.util.UnsignedUtils;
import jdk.graal.compiler.api.directives.GraalDirectives;
import jdk.graal.compiler.word.Word;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.struct.RawStructure;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;

public final class UnalignedHeapChunk {
    private UnalignedHeapChunk() {
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static void initialize(HostedByteBufferPointer chunk, UnsignedWord objectSize) {
        UnsignedWord objectStartOffset = UnalignedHeapChunk.calculateObjectStartOffset(objectSize);
        RememberedSet.get().setObjectStartOffsetOfUnalignedChunk(chunk, objectStartOffset);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static void initialize(UnalignedHeader chunk, UnsignedWord chunkSize, UnsignedWord objectSize) {
        assert (chunk.isNonNull());
        UnsignedWord objectStartOffset = UnalignedHeapChunk.calculateObjectStartOffset(objectSize);
        HeapChunk.initialize(chunk, HeapChunk.asPointer(chunk).add(objectStartOffset), chunkSize);
        UnalignedHeapChunk.setObjectStartOffset(chunk, objectStartOffset);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static Pointer getObjectStart(UnalignedHeader that) {
        return HeapChunk.asPointer(that).add(UnalignedHeapChunk.getObjectStartOffset(that));
    }

    public static Pointer getObjectEnd(UnalignedHeader that) {
        return HeapChunk.getEndPointer(that);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    static UnsignedWord getChunkSizeForObject(UnsignedWord objectSize) {
        UnsignedWord objectStart = RememberedSet.get().getHeaderSizeOfUnalignedChunk(objectSize);
        UnsignedWord alignment = Word.unsigned((int)ConfigurationValues.getObjectLayout().getAlignment());
        return UnsignedUtils.roundUp(objectStart.add(objectSize), alignment);
    }

    @Uninterruptible(reason="Returns uninitialized memory.", callerMustBe=true)
    public static Pointer allocateMemory(UnalignedHeader that, UnsignedWord size) {
        UnsignedWord available = HeapChunk.availableObjectMemory(that);
        Pointer result = (Pointer)Word.nullPointer();
        if (size.belowOrEqual(available)) {
            result = HeapChunk.getTopPointer(that);
            Pointer newTop = result.add(size);
            HeapChunk.setTopPointerCarefully(that, newTop);
        }
        return result;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static UnalignedHeader getEnclosingChunk(Object obj) {
        Word objPointer = Word.objectToUntrackedPointer((Object)obj);
        return UnalignedHeapChunk.getEnclosingChunkFromObjectPointer((Pointer)objPointer);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    static UnalignedHeader getEnclosingChunkFromObjectPointer(Pointer ptr) {
        if (!GraalDirectives.inIntrinsic()) assert (HeapImpl.isImageHeapAligned() || !HeapImpl.getHeapImpl().isInImageHeap(ptr)) : "can't be used for the image heap because the image heap is not aligned to the chunk size";
        Pointer chunkPointer = ptr.subtract(UnalignedHeapChunk.getOffsetForObject(ptr));
        return (UnalignedHeader)chunkPointer;
    }

    public static void initializeObjectStartOffset(UnalignedHeader that, UnsignedWord objectSize) {
        UnsignedWord objectStartOffset = UnalignedHeapChunk.calculateObjectStartOffset(objectSize);
        UnalignedHeapChunk.setObjectStartOffset(that, objectStartOffset);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static UnsignedWord calculateObjectStartOffset(UnsignedWord objectSize) {
        return RememberedSet.get().getHeaderSizeOfUnalignedChunk(objectSize);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static void setObjectStartOffset(UnalignedHeader that, UnsignedWord objectStartOffset) {
        RememberedSet.get().setObjectStartOffsetOfUnalignedChunk(that, objectStartOffset);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static UnsignedWord getObjectStartOffset(UnalignedHeader that) {
        return RememberedSet.get().getObjectStartOffsetOfUnalignedChunk(that);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static UnsignedWord getOffsetForObject(Pointer objPtr) {
        return RememberedSet.get().getOffsetForObjectInUnalignedChunk(objPtr);
    }

    public static void walkObjects(UnalignedHeader that, ObjectVisitor visitor) {
        HeapChunk.walkObjectsFrom(that, UnalignedHeapChunk.getObjectStart(that), visitor);
    }

    @AlwaysInline(value="GC performance")
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static void walkObjectsInline(UnalignedHeader that, UninterruptibleObjectVisitor visitor) {
        HeapChunk.walkObjectsFromInline(that, UnalignedHeapChunk.getObjectStart(that), visitor);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static UnsignedWord getCommittedObjectMemory(UnalignedHeader that) {
        return HeapChunk.getEndOffset(that).subtract(UnalignedHeapChunk.getObjectStartOffset(that));
    }

    @RawStructure
    public static interface UnalignedHeader
    extends HeapChunk.Header<UnalignedHeader> {
    }
}

