/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge.graal;

import com.oracle.svm.core.GCRelatedMXBeans;
import com.oracle.svm.core.SubstrateGCOptions;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.genscavenge.AddressRangeCommittedMemoryProvider;
import com.oracle.svm.core.genscavenge.ChunkedImageHeapLayouter;
import com.oracle.svm.core.genscavenge.GenScavengeMemoryPoolMXBeans;
import com.oracle.svm.core.genscavenge.HeapImpl;
import com.oracle.svm.core.genscavenge.HeapVerifier;
import com.oracle.svm.core.genscavenge.ImageHeapInfo;
import com.oracle.svm.core.genscavenge.PinnedObjectSupportImpl;
import com.oracle.svm.core.genscavenge.SerialGCOptions;
import com.oracle.svm.core.genscavenge.TlabOptionCache;
import com.oracle.svm.core.genscavenge.UseSerialOrEpsilonGC;
import com.oracle.svm.core.genscavenge.graal.BarrierSnippets;
import com.oracle.svm.core.genscavenge.graal.GenScavengeAllocationSnippets;
import com.oracle.svm.core.genscavenge.graal.GenScavengeAllocationSupport;
import com.oracle.svm.core.genscavenge.graal.GenScavengeRelatedMXBeans;
import com.oracle.svm.core.genscavenge.jvmstat.EpsilonGCPerfData;
import com.oracle.svm.core.genscavenge.jvmstat.SerialGCPerfData;
import com.oracle.svm.core.genscavenge.remset.CardTableBasedRememberedSet;
import com.oracle.svm.core.genscavenge.remset.NoRememberedSet;
import com.oracle.svm.core.genscavenge.remset.RememberedSet;
import com.oracle.svm.core.graal.meta.RuntimeConfiguration;
import com.oracle.svm.core.graal.meta.SubstrateForeignCallsProvider;
import com.oracle.svm.core.graal.snippets.GCAllocationSupport;
import com.oracle.svm.core.graal.snippets.NodeLoweringProvider;
import com.oracle.svm.core.graal.snippets.SubstrateAllocationSnippets;
import com.oracle.svm.core.heap.AllocationFeature;
import com.oracle.svm.core.heap.BarrierSetProvider;
import com.oracle.svm.core.heap.Heap;
import com.oracle.svm.core.image.ImageHeapLayouter;
import com.oracle.svm.core.imagelayer.ImageLayerBuildingSupport;
import com.oracle.svm.core.jdk.RuntimeSupportFeature;
import com.oracle.svm.core.jdk.SystemPropertiesSupport;
import com.oracle.svm.core.jvmstat.PerfDataFeature;
import com.oracle.svm.core.jvmstat.PerfDataHolder;
import com.oracle.svm.core.jvmstat.PerfManager;
import com.oracle.svm.core.layeredimagesingleton.LayeredImageSingletonSupport;
import com.oracle.svm.core.os.CommittedMemoryProvider;
import com.oracle.svm.core.os.OSCommittedMemoryProvider;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.phases.util.Providers;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.impl.PinnedObjectSupport;

@AutomaticallyRegisteredFeature
class GenScavengeGCFeature
implements InternalFeature {
    GenScavengeGCFeature() {
    }

    public boolean isInConfiguration(Feature.IsInConfigurationAccess access) {
        return new UseSerialOrEpsilonGC().getAsBoolean();
    }

    public List<Class<? extends Feature>> getRequiredFeatures() {
        return Arrays.asList(RuntimeSupportFeature.class, PerfDataFeature.class, AllocationFeature.class);
    }

    public void afterRegistration(Feature.AfterRegistrationAccess access) {
        RememberedSet rememberedSet = GenScavengeGCFeature.createRememberedSet();
        ImageSingletons.add(RememberedSet.class, (Object)rememberedSet);
        ImageSingletons.add(BarrierSetProvider.class, (Object)rememberedSet);
        GenScavengeMemoryPoolMXBeans memoryPoolMXBeans = new GenScavengeMemoryPoolMXBeans();
        ImageSingletons.add(GenScavengeMemoryPoolMXBeans.class, (Object)memoryPoolMXBeans);
        ImageSingletons.add(GCRelatedMXBeans.class, (Object)new GenScavengeRelatedMXBeans(memoryPoolMXBeans));
    }

    public void duringSetup(Feature.DuringSetupAccess access) {
        ImageSingletons.add(Heap.class, (Object)new HeapImpl());
        ImageSingletons.add(ImageHeapInfo.class, (Object)new ImageHeapInfo());
        ImageSingletons.add(GCAllocationSupport.class, (Object)new GenScavengeAllocationSupport());
        ImageSingletons.add(TlabOptionCache.class, (Object)new TlabOptionCache());
        if (ImageLayerBuildingSupport.firstImageBuild()) {
            ImageSingletons.add(PinnedObjectSupport.class, (Object)new PinnedObjectSupportImpl());
        }
        if (ImageSingletons.contains(PerfManager.class)) {
            ((PerfManager)ImageSingletons.lookup(PerfManager.class)).register(GenScavengeGCFeature.createPerfData());
        }
        if (SubstrateGCOptions.VerifyHeap.getValue().booleanValue()) {
            ImageSingletons.add(HeapVerifier.class, (Object)new HeapVerifier());
        }
    }

    @Override
    public void registerLowerings(RuntimeConfiguration runtimeConfig, OptionValues options, Providers providers, Map<Class<? extends Node>, NodeLoweringProvider<?>> lowerings, boolean hosted) {
        if (SerialGCOptions.useRememberedSet()) {
            BarrierSnippets barrierSnippets = new BarrierSnippets(options, providers);
            barrierSnippets.registerLowerings(providers.getMetaAccess(), lowerings);
        }
        SubstrateAllocationSnippets allocationSnippets = (SubstrateAllocationSnippets)((Object)ImageSingletons.lookup(SubstrateAllocationSnippets.class));
        SubstrateAllocationSnippets.Templates templates = new SubstrateAllocationSnippets.Templates(options, providers, allocationSnippets);
        templates.registerLowering(lowerings);
        GenScavengeAllocationSnippets.Templates genScavengeTemplates = new GenScavengeAllocationSnippets.Templates(options, providers, templates);
        genScavengeTemplates.registerLowering(lowerings);
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        if (!ImageSingletons.contains(CommittedMemoryProvider.class)) {
            ImageSingletons.add(CommittedMemoryProvider.class, (Object)GenScavengeGCFeature.createCommittedMemoryProvider());
        }
        SystemPropertiesSupport.singleton().setLibGraalRuntimeProperty("gc", Heap.getHeap().getGC().getName());
        access.registerAsUsed(Object[].class);
        TlabOptionCache.registerOptionValidations();
    }

    private static ImageHeapInfo getCurrentLayerImageHeapInfo() {
        return LayeredImageSingletonSupport.singleton().lookup(ImageHeapInfo.class, false, true);
    }

    public void afterAnalysis(Feature.AfterAnalysisAccess access) {
        ChunkedImageHeapLayouter heapLayouter = new ChunkedImageHeapLayouter(GenScavengeGCFeature.getCurrentLayerImageHeapInfo(), Heap.getHeap().getImageHeapOffsetInAddressSpace());
        ImageSingletons.add(ImageHeapLayouter.class, (Object)heapLayouter);
    }

    public void beforeCompilation(Feature.BeforeCompilationAccess access) {
        access.registerAsImmutable((Object)GenScavengeGCFeature.getCurrentLayerImageHeapInfo());
    }

    @Override
    public void registerForeignCalls(SubstrateForeignCallsProvider foreignCalls) {
        BarrierSnippets.registerForeignCalls(foreignCalls);
        GenScavengeAllocationSupport.registerForeignCalls(foreignCalls);
    }

    private static RememberedSet createRememberedSet() {
        if (SerialGCOptions.useRememberedSet()) {
            return new CardTableBasedRememberedSet();
        }
        return new NoRememberedSet();
    }

    private static PerfDataHolder createPerfData() {
        if (SubstrateOptions.useSerialOrParallelGC()) {
            return new SerialGCPerfData();
        }
        assert (SubstrateOptions.useEpsilonGC());
        return new EpsilonGCPerfData();
    }

    private static CommittedMemoryProvider createCommittedMemoryProvider() {
        if (SubstrateOptions.SpawnIsolates.getValue().booleanValue()) {
            return new AddressRangeCommittedMemoryProvider();
        }
        return new OSCommittedMemoryProvider();
    }
}

