/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.heap;

import com.oracle.svm.core.AlwaysInline;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.heap.Heap;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.image.ImageHeapObject;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import jdk.graal.compiler.api.replacements.Fold;
import jdk.graal.compiler.nodes.NamedLocationIdentity;
import jdk.graal.compiler.word.Word;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.word.LocationIdentity;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;

public abstract class ObjectHeader {
    protected static final String INLINE_INITIALIZE_HEADER_INIT_REASON = "Methods that write to INIT_LOCATION must be inlined into a caller that emits an ALLOCATION_INIT barrier.";

    @Platforms(value={Platform.HOSTED_ONLY.class})
    protected ObjectHeader() {
    }

    public abstract int getReservedHubBitsMask();

    public abstract long encodeHubPointerForImageHeap(ImageHeapObject var1, long var2);

    public abstract Word encodeAsTLABObjectHeader(DynamicHub var1);

    public abstract long encodeAsTLABObjectHeader(long var1);

    public abstract int constantHeaderSize();

    public abstract Word encodeAsUnmanagedObjectHeader(DynamicHub var1);

    public abstract void verifyDynamicHubOffsetInImageHeap(long var1);

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public DynamicHub dynamicHubFromObjectHeader(Word header) {
        return (DynamicHub)this.extractPotentialDynamicHubFromHeader(header).toObject();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static DynamicHub readDynamicHubFromObject(Object o) {
        return KnownIntrinsics.readHub(o);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public abstract Word readHeaderFromPointer(Pointer var1);

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public abstract Word readHeaderFromObject(Object var1);

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public DynamicHub readDynamicHubFromPointer(Pointer ptr) {
        Word header = this.readHeaderFromPointer(ptr);
        return this.dynamicHubFromObjectHeader(header);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public Pointer readPotentialDynamicHubFromPointer(Pointer ptr) {
        Word potentialHeader = this.readHeaderFromPointer(ptr);
        return this.extractPotentialDynamicHubFromHeader(potentialHeader);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public abstract Pointer extractPotentialDynamicHubFromHeader(Word var1);

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    @AlwaysInline(value="Methods that write to INIT_LOCATION must be inlined into a caller that emits an ALLOCATION_INIT barrier.")
    public final void initializeHeaderOfNewObjectInit(Pointer ptr, Word header, boolean isArrayLike) {
        this.initializeObjectHeader(ptr, header, isArrayLike, InitLocationMemWriter.INSTANCE);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public final void initializeHeaderOfNewObjectOffHeap(Pointer ptr, Word header, boolean isArrayLike) {
        this.initializeObjectHeader(ptr, header, isArrayLike, OffHeapLocationMemWriter.INSTANCE);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    @AlwaysInline(value="Methods that write to INIT_LOCATION must be inlined into a caller that emits an ALLOCATION_INIT barrier.")
    protected abstract void initializeObjectHeader(Pointer var1, Word var2, boolean var3, MemWriter var4);

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean pointsToObjectHeader(Pointer ptr) {
        Pointer potentialDynamicHub = this.readPotentialDynamicHubFromPointer(ptr);
        return this.isDynamicHub(potentialDynamicHub);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean isEncodedObjectHeader(Word potentialHeader) {
        Pointer potentialDynamicHub = this.extractPotentialDynamicHubFromHeader(potentialHeader);
        return this.isDynamicHub(potentialDynamicHub);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public abstract boolean hasOptionalIdentityHashField(Word var1);

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public abstract boolean hasIdentityHashFromAddress(Word var1);

    @Uninterruptible(reason="Prevent a GC interfering with the object's identity hash state.", callerMustBe=true)
    public abstract void setIdentityHashFromAddress(Pointer var1, Word var2);

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private boolean isDynamicHub(Pointer potentialDynamicHub) {
        if (Heap.getHeap().isInImageHeap(potentialDynamicHub)) {
            Pointer potentialHubOfDynamicHub = this.readPotentialDynamicHubFromPointer(potentialDynamicHub);
            return potentialHubOfDynamicHub.equal((UnsignedWord)Word.objectToUntrackedPointer(DynamicHub.class));
        }
        return false;
    }

    @Fold
    protected static int getReferenceSize() {
        return ConfigurationValues.getObjectLayout().getReferenceSize();
    }

    @Fold
    public static int getHubOffset() {
        return ConfigurationValues.getObjectLayout().getHubOffset();
    }

    private static final class InitLocationMemWriter
    implements MemWriter {
        private static final InitLocationMemWriter INSTANCE = new InitLocationMemWriter();

        private InitLocationMemWriter() {
        }

        @Override
        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        @AlwaysInline(value="Methods that write to INIT_LOCATION must be inlined into a caller that emits an ALLOCATION_INIT barrier.")
        public void writeWord(Pointer ptr, int offset, Word word) {
            ptr.writeWord(offset, (WordBase)word, LocationIdentity.INIT_LOCATION);
        }

        @Override
        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        @AlwaysInline(value="Methods that write to INIT_LOCATION must be inlined into a caller that emits an ALLOCATION_INIT barrier.")
        public void writeInt(Pointer ptr, int offset, int val) {
            ptr.writeInt(offset, val, LocationIdentity.INIT_LOCATION);
        }

        @Override
        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        @AlwaysInline(value="Methods that write to INIT_LOCATION must be inlined into a caller that emits an ALLOCATION_INIT barrier.")
        public void writeLong(Pointer ptr, int offset, long val) {
            ptr.writeLong(offset, val, LocationIdentity.INIT_LOCATION);
        }
    }

    protected static interface MemWriter {
        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public void writeWord(Pointer var1, int var2, Word var3);

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public void writeInt(Pointer var1, int var2, int var3);

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public void writeLong(Pointer var1, int var2, long var3);
    }

    private static final class OffHeapLocationMemWriter
    implements MemWriter {
        private static final OffHeapLocationMemWriter INSTANCE = new OffHeapLocationMemWriter();

        private OffHeapLocationMemWriter() {
        }

        @Override
        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public void writeWord(Pointer ptr, int offset, Word word) {
            ptr.writeWord(offset, (WordBase)word, NamedLocationIdentity.OFF_HEAP_LOCATION);
        }

        @Override
        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public void writeInt(Pointer ptr, int offset, int val) {
            ptr.writeInt(offset, val, NamedLocationIdentity.OFF_HEAP_LOCATION);
        }

        @Override
        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public void writeLong(Pointer ptr, int offset, long val) {
            ptr.writeLong(offset, val, NamedLocationIdentity.OFF_HEAP_LOCATION);
        }
    }
}

