/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.hub.registry;

import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.hub.RuntimeClassLoading;
import com.oracle.svm.core.hub.registry.AbstractClassRegistry;
import com.oracle.svm.core.hub.registry.BootClassRegistry;
import com.oracle.svm.core.hub.registry.ClassRegistries;
import com.oracle.svm.core.hub.registry.UserDefinedClassRegistry;
import com.oracle.svm.core.jdk.Target_java_lang_ClassLoader;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.espresso.classfile.ClassfileParser;
import com.oracle.svm.espresso.classfile.ClassfileStream;
import com.oracle.svm.espresso.classfile.ParserConstantPool;
import com.oracle.svm.espresso.classfile.ParserException;
import com.oracle.svm.espresso.classfile.ParserKlass;
import com.oracle.svm.espresso.classfile.ParsingContext;
import com.oracle.svm.espresso.classfile.attributes.InnerClassesAttribute;
import com.oracle.svm.espresso.classfile.attributes.NestHostAttribute;
import com.oracle.svm.espresso.classfile.attributes.PermittedSubclassesAttribute;
import com.oracle.svm.espresso.classfile.attributes.RecordAttribute;
import com.oracle.svm.espresso.classfile.attributes.SignatureAttribute;
import com.oracle.svm.espresso.classfile.attributes.SourceFileAttribute;
import com.oracle.svm.espresso.classfile.descriptors.ParserSymbols;
import com.oracle.svm.espresso.classfile.descriptors.Symbol;
import com.oracle.svm.espresso.classfile.descriptors.Type;
import com.oracle.svm.espresso.classfile.descriptors.ValidationException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import jdk.internal.misc.Unsafe;
import jdk.vm.ci.meta.MetaUtil;
import org.graalvm.nativeimage.impl.ClassLoading;

public abstract sealed class AbstractRuntimeClassRegistry
extends AbstractClassRegistry
permits BootClassRegistry, UserDefinedClassRegistry {
    private static final Unsafe UNSAFE = Unsafe.getUnsafe();
    private static final Class<?>[] EMPTY_CLASS_ARRAY = new Class[0];
    private final Collection<Class<?>> strongHiddenClasses = new ArrayList();

    AbstractRuntimeClassRegistry() {
        super(new ConcurrentHashMap<Symbol<Type>, Object>());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Class<?> loadClass(Symbol<Type> name) throws ClassNotFoundException {
        Class<?> aotClass = this.findAOTLoadedClass(name);
        if (aotClass != null) {
            return aotClass;
        }
        if (this.isParallelClassLoader()) {
            return this.loadClassInner(name);
        }
        Object v = this.runtimeClasses.get(name);
        if (v instanceof Class) {
            Class entry = (Class)v;
            return entry;
        }
        ClassLoader classLoader = this.getClassLoader();
        synchronized (classLoader) {
            return this.loadClassInner(name);
        }
    }

    private Class<?> loadClassInner(Symbol<Type> name) throws ClassNotFoundException {
        Placeholder placeholder;
        if (this.getClassLoader() != null && this.isParallelClassLoader()) {
            throw VMError.unimplemented("Parallel class loading:" + String.valueOf(this.getClassLoader()));
        }
        Object existing = this.runtimeClasses.get(name);
        if (existing instanceof Class) {
            Class entry = (Class)existing;
            return entry;
        }
        if (existing instanceof Placeholder && (placeholder = (Placeholder)existing).isSuperProbingThread()) {
            throw new ClassCircularityError(name.toString());
        }
        Class<?> result = this.doLoadClass(name);
        if (result == null) {
            return null;
        }
        Class<?> prev = this.runtimeClasses.put(name, result);
        assert (prev == null || prev == result) : prev;
        return result;
    }

    protected boolean isParallelClassLoader() {
        return AbstractRuntimeClassRegistry.isParallelClassLoader(this.getClassLoader());
    }

    private static boolean isParallelClassLoader(ClassLoader loader) {
        if (loader == null) {
            return true;
        }
        return SubstrateUtil.cast((Object)loader, Target_java_lang_ClassLoader.class).parallelLockMap != null;
    }

    protected abstract Class<?> doLoadClass(Symbol<Type> var1) throws ClassNotFoundException;

    protected abstract boolean loaderIsBootOrPlatform();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Class<?> defineClass(Symbol<Type> typeOrNull, byte[] b, int off, int len, RuntimeClassLoading.ClassDefinitionInfo info) {
        if (this.isParallelClassLoader()) {
            return this.defineClassInner(typeOrNull, b, off, len, info);
        }
        ClassLoader classLoader = this.getClassLoader();
        synchronized (classLoader) {
            return this.defineClassInner(typeOrNull, b, off, len, info);
        }
    }

    private Class<?> defineClassInner(Symbol<Type> typeOrNull, byte[] b, int off, int len, RuntimeClassLoading.ClassDefinitionInfo info) {
        Class<?> clazz;
        Symbol type;
        if (this.isParallelClassLoader() || this.getClassLoader() == null) {
            throw VMError.unimplemented("Parallel class loading:" + String.valueOf(this.getClassLoader()));
        }
        byte[] data = b;
        if (off != 0 || b.length != len) {
            if (len < 0) {
                throw new ArrayIndexOutOfBoundsException("Length " + len + " is negative");
            }
            if (off < 0 || off > b.length - len) {
                throw new ArrayIndexOutOfBoundsException("Array region " + off + ".." + ((long)off + (long)len) + " out of bounds for length " + len);
            }
            data = Arrays.copyOfRange(data, off, off + len);
        }
        ParserKlass parsed = this.parseClass(typeOrNull, info, data);
        Symbol symbol = type = typeOrNull == null ? parsed.getType() : typeOrNull;
        assert (typeOrNull == null || type == parsed.getType());
        if (info.addedToRegistry() && this.findLoadedClass((Symbol<Type>)type) != null) {
            String kind = Modifier.isInterface(parsed.getFlags()) ? "interface" : (Modifier.isAbstract(parsed.getFlags()) ? "abstract class" : "class");
            String externalName = AbstractRuntimeClassRegistry.getExternalName(parsed, info);
            throw new LinkageError("Loader " + ClassRegistries.loaderNameAndId(this.getClassLoader()) + " attempted duplicate " + kind + " definition for " + externalName + ".");
        }
        try {
            clazz = this.createClass(parsed, info, (Symbol<Type>)type);
        }
        catch (ParserException.ClassFormatError error) {
            throw new ClassFormatError(error.getMessage());
        }
        if (info.addedToRegistry()) {
            this.registerClass(clazz, (Symbol<Type>)type);
        } else if (info.isStrongHidden()) {
            this.registerStrongHiddenClass(clazz);
        }
        return clazz;
    }

    private ParserKlass parseClass(Symbol<Type> typeOrNull, RuntimeClassLoading.ClassDefinitionInfo info, byte[] data) {
        boolean verifiable = RuntimeClassLoading.Options.ClassVerification.getValue().needsVerification(this.getClassLoader());
        try {
            return ClassfileParser.parse((ParsingContext)ClassRegistries.getParsingContext(), (ClassfileStream)new ClassfileStream(data, null), (boolean)verifiable, (boolean)this.loaderIsBootOrPlatform(), typeOrNull, (boolean)info.isHidden(), (boolean)info.forceAllowVMAnnotations(), (boolean)verifiable);
        }
        catch (ParserException.ClassFormatError | ValidationException validationOrBadFormat) {
            throw new ClassFormatError(validationOrBadFormat.getMessage());
        }
        catch (ParserException.UnsupportedClassVersionError unsupportedClassVersionError) {
            throw new UnsupportedClassVersionError(unsupportedClassVersionError.getMessage());
        }
        catch (ParserException.NoClassDefFoundError noClassDefFoundError) {
            throw new NoClassDefFoundError(noClassDefFoundError.getMessage());
        }
        catch (ParserException parserException) {
            throw VMError.shouldNotReachHere("Not a validation nor parser exception", parserException);
        }
    }

    private Class<?> createClass(ParserKlass parsed, RuntimeClassLoading.ClassDefinitionInfo info, Symbol<Type> type) {
        Symbol superKlassType = parsed.getSuperKlass();
        assert (superKlassType != null);
        Symbol[] superInterfacesTypes = parsed.getSuperInterfaces();
        Class<?>[] superInterfaces = superInterfacesTypes.length == 0 ? EMPTY_CLASS_ARRAY : new Class[superInterfacesTypes.length];
        for (int i = 0; i < superInterfacesTypes.length; ++i) {
            superInterfaces[i] = this.loadSuperType(type, (Symbol<Type>)superInterfacesTypes[i]);
            if (superInterfaces[i].isInterface()) continue;
            throw new IncompatibleClassChangeError("Class " + String.valueOf(parsed.getType()) + " cannot implement " + String.valueOf(superInterfaces[i]) + ", because it is not an interface");
        }
        Class<?> superClass = this.loadSuperType(type, (Symbol<Type>)superKlassType);
        if (superClass.isInterface()) {
            throw new IncompatibleClassChangeError("Class " + String.valueOf(parsed.getType()) + " has interface " + String.valueOf(superKlassType) + " as super class");
        }
        if (Modifier.isFinal(superClass.getModifiers())) {
            throw new IncompatibleClassChangeError("Class " + String.valueOf(parsed.getType()) + " is a subclass of final class " + String.valueOf(superKlassType));
        }
        String externalName = AbstractRuntimeClassRegistry.getExternalName(parsed, info);
        String simpleBinaryName = AbstractRuntimeClassRegistry.getSimpleBinaryName(parsed);
        String sourceFile = AbstractRuntimeClassRegistry.getSourceFile(parsed);
        Class<?> nestHost = AbstractRuntimeClassRegistry.getNestHost(parsed);
        Class<?> enclosingClass = AbstractRuntimeClassRegistry.getEnclosingClass(parsed);
        String classSignature = AbstractRuntimeClassRegistry.getClassSignature(parsed);
        int modifiers = AbstractRuntimeClassRegistry.getClassModifiers(parsed);
        boolean isInterface = Modifier.isInterface(modifiers);
        boolean isRecord = Modifier.isFinal(modifiers) && superClass == Record.class && parsed.getAttribute(RecordAttribute.NAME) != null;
        boolean assertionsEnabled = true;
        boolean declaresDefaultMethods = false;
        boolean hasDefaultMethods = declaresDefaultMethods || AbstractRuntimeClassRegistry.hasInheritedDefaultMethods(superClass, superInterfaces);
        boolean isSealed = AbstractRuntimeClassRegistry.isSealed(parsed);
        short flags = DynamicHub.makeFlags(false, isInterface, info.isHidden(), isRecord, assertionsEnabled, hasDefaultMethods, declaresDefaultMethods, isSealed, false, false, false, false);
        DynamicHub[] interfacesEncoding = null;
        if (superInterfaces.length == 1) {
            interfacesEncoding = DynamicHub.fromClass(superInterfaces[0]);
        } else if (superInterfaces.length > 1) {
            DynamicHub[] superHubs = new DynamicHub[superInterfaces.length];
            for (int i = 0; i < superHubs.length; ++i) {
                superHubs[i] = DynamicHub.fromClass(superInterfaces[i]);
            }
            interfacesEncoding = superHubs;
        }
        DynamicHub hub = DynamicHub.allocate(externalName, DynamicHub.fromClass(superClass), interfacesEncoding, null, sourceFile, modifiers, flags, this.getClassLoader(), nestHost, simpleBinaryName, enclosingClass, classSignature);
        return DynamicHub.toClass(hub);
    }

    private static boolean isSealed(ParserKlass parsed) {
        PermittedSubclassesAttribute permittedSubclasses = (PermittedSubclassesAttribute)parsed.getAttribute(PermittedSubclassesAttribute.NAME);
        return permittedSubclasses != null && permittedSubclasses.getClasses().length > 0;
    }

    private static boolean hasInheritedDefaultMethods(Class<?> superClass, Class<?>[] superInterfaces) {
        if (DynamicHub.fromClass(superClass).hasDefaultMethods()) {
            return true;
        }
        for (Class<?> superInterface : superInterfaces) {
            if (!DynamicHub.fromClass(superInterface).hasDefaultMethods()) continue;
            return true;
        }
        return false;
    }

    private static int getClassModifiers(ParserKlass parsed) {
        int modifiers = parsed.getFlags();
        InnerClassesAttribute innerClassesAttribute = (InnerClassesAttribute)parsed.getAttribute(InnerClassesAttribute.NAME);
        if (innerClassesAttribute != null) {
            ParserConstantPool pool = parsed.getConstantPool();
            for (int i = 0; i < innerClassesAttribute.entryCount(); ++i) {
                Symbol innerClassName;
                InnerClassesAttribute.Entry entry = innerClassesAttribute.entryAt(i);
                if (entry.innerClassIndex == 0 || !(innerClassName = pool.className(entry.innerClassIndex)).equals((Object)parsed.getName())) continue;
                modifiers = entry.innerClassAccessFlags;
                break;
            }
        }
        return modifiers & 0xFFFFFFDF & Short.MAX_VALUE;
    }

    private static Class<?> getNestHost(ParserKlass parsed) {
        Class<?> nestHost = null;
        NestHostAttribute nestHostAttribute = (NestHostAttribute)parsed.getAttribute(NestHostAttribute.NAME);
        if (nestHostAttribute != null) {
            throw VMError.unimplemented("nest host is not supported yet");
        }
        return nestHost;
    }

    private static String getExternalName(ParserKlass parsed, RuntimeClassLoading.ClassDefinitionInfo info) {
        String externalName = MetaUtil.internalNameToJava((String)parsed.getType().toString(), (boolean)true, (boolean)true);
        if (info.isHidden()) {
            int idx = externalName.lastIndexOf(43);
            char[] chars = externalName.toCharArray();
            chars[idx] = 47;
            externalName = new String(chars);
        }
        return externalName;
    }

    private static Class<?> getEnclosingClass(ParserKlass parsed) {
        InnerClassesAttribute innerClassesAttribute = (InnerClassesAttribute)parsed.getAttribute(InnerClassesAttribute.NAME);
        if (innerClassesAttribute == null) {
            return null;
        }
        throw VMError.unimplemented("enclosing class is not supported yet");
    }

    private static String getSimpleBinaryName(ParserKlass parsed) {
        InnerClassesAttribute innerClassesAttribute = (InnerClassesAttribute)parsed.getAttribute(InnerClassesAttribute.NAME);
        if (innerClassesAttribute == null) {
            return null;
        }
        ParserConstantPool pool = parsed.getConstantPool();
        for (int i = 0; i < innerClassesAttribute.entryCount(); ++i) {
            InnerClassesAttribute.Entry entry = innerClassesAttribute.entryAt(i);
            int innerClassIndex = entry.innerClassIndex;
            if (innerClassIndex == 0 || pool.className(innerClassIndex) != parsed.getName()) continue;
            if (entry.innerNameIndex == 0) break;
            Symbol innerName = pool.utf8At(entry.innerNameIndex, "inner class name");
            return innerName.toString();
        }
        return null;
    }

    private static String getSourceFile(ParserKlass parsed) {
        String sourceFile = null;
        SourceFileAttribute sourceFileAttribute = (SourceFileAttribute)parsed.getAttribute(ParserSymbols.ParserNames.SourceFile);
        if (sourceFileAttribute != null) {
            sourceFile = parsed.getConstantPool().utf8At(sourceFileAttribute.getSourceFileIndex()).toString();
        }
        return sourceFile;
    }

    private static String getClassSignature(ParserKlass parsed) {
        String sourceFile = null;
        SignatureAttribute signatureAttribute = (SignatureAttribute)parsed.getAttribute(ParserSymbols.ParserNames.Signature);
        if (signatureAttribute != null) {
            sourceFile = parsed.getConstantPool().utf8At(signatureAttribute.getSignatureIndex()).toString();
        }
        return sourceFile;
    }

    public final Class<?> loadSuperType(Symbol<Type> name, Symbol<Type> superName) {
        Placeholder placeholder = new Placeholder();
        Placeholder prev = this.runtimeClasses.putIfAbsent(name, placeholder);
        if (prev instanceof Placeholder) {
            Placeholder otherPlaceHolder = prev;
            if (otherPlaceHolder.isSuperProbingThread()) {
                throw new ClassCircularityError(name.toString());
            }
            otherPlaceHolder.addSuperProbingThread();
        }
        assert (prev == null) : prev;
        try {
            Class<?> clazz;
            block14: {
                ClassLoading.ArbitraryClassLoadingScope scope = ClassLoading.allowArbitraryClassLoading();
                try {
                    clazz = this.loadClass(superName);
                    if (scope == null) break block14;
                }
                catch (Throwable throwable) {
                    try {
                        if (scope != null) {
                            try {
                                scope.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (ClassNotFoundException e) {
                        NoClassDefFoundError error = new NoClassDefFoundError(superName.toString());
                        error.initCause(e);
                        throw error;
                    }
                }
                scope.close();
            }
            return clazz;
        }
        finally {
            this.runtimeClasses.remove(name, placeholder);
        }
    }

    private void registerClass(Class<?> clazz, Symbol<Type> type) {
        Class<?> previous = this.runtimeClasses.put(type, clazz);
        assert (previous == null);
    }

    private void registerStrongHiddenClass(Class<?> clazz) {
        this.strongHiddenClasses.add(clazz);
    }

    private static final class Placeholder
    extends CompletableFuture<Class<?>> {
        private static final long SUPER_PROBING_OFFSET = UNSAFE.objectFieldOffset(Placeholder.class, "otherSuperProbingThreads");
        private static final long THREAD_ARRAY_BASE_OFFSET = UNSAFE.arrayBaseOffset(Thread[].class);
        private static final long THREAD_ELEMENT_SIZE = UNSAFE.arrayIndexScale(Thread[].class);
        private static final AtomicInteger NEXT_ID = new AtomicInteger(0);
        private final int id = NEXT_ID.getAndIncrement();
        private final Thread thread = Thread.currentThread();
        private volatile Object otherSuperProbingThreads;

        Placeholder() {
        }

        @Override
        public String toString() {
            return "#" + this.id + " " + String.valueOf(this.thread);
        }

        public boolean isSuperProbingThread() {
            Thread t = Thread.currentThread();
            if (t == this.thread) {
                return true;
            }
            Object others = this.otherSuperProbingThreads;
            if (t == others) {
                return true;
            }
            if (others instanceof Thread[]) {
                Thread[] otherThreads;
                for (Thread other : otherThreads = (Thread[])others) {
                    if (other != t) continue;
                    return true;
                }
            }
            return false;
        }

        public void addSuperProbingThread() {
            Thread t = Thread.currentThread();
            if (t == this.thread) {
                return;
            }
            Object others = this.otherSuperProbingThreads;
            if (others == null) {
                Object found = UNSAFE.compareAndExchangeReference(this, SUPER_PROBING_OFFSET, null, t);
                if (found == null) {
                    return;
                }
                others = found;
            }
            if (others == t) {
                return;
            }
            if (others instanceof Thread) {
                Thread otherThread = (Thread)others;
                Object found = UNSAFE.compareAndExchangeReference(this, SUPER_PROBING_OFFSET, otherThread, new Thread[]{otherThread, t});
                if (found == otherThread) {
                    return;
                }
                others = found;
            }
            Thread[] otherThreads = (Thread[])others;
            while (true) {
                for (int i = 0; i < otherThreads.length; ++i) {
                    if (otherThreads[i] == t) {
                        return;
                    }
                    if (otherThreads[i] != null || !UNSAFE.compareAndSetReference(otherThreads, THREAD_ARRAY_BASE_OFFSET + (long)i * THREAD_ELEMENT_SIZE, null, t)) continue;
                    return;
                }
                Thread[] newArray = Arrays.copyOf(otherThreads, Math.max(otherThreads.length << 1, otherThreads.length + 1));
                newArray[otherThreads.length] = t;
                Object found = UNSAFE.compareAndExchangeReference(this, SUPER_PROBING_OFFSET, otherThreads, newArray);
                if (found == otherThreads) {
                    return;
                }
                otherThreads = (Thread[])found;
            }
        }
    }
}

