/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.memory;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.memory.NullableNativeMemory;
import com.oracle.svm.core.nmt.NmtCategory;
import jdk.graal.compiler.word.Word;
import org.graalvm.word.PointerBase;
import org.graalvm.word.UnsignedWord;

public class NativeMemory {
    public static <T extends PointerBase> T malloc(UnsignedWord size, NmtCategory category) {
        Object result = NullableNativeMemory.malloc(size, category);
        if (result.isNull()) {
            throw new OutOfMemoryError("Memory allocation failed: malloc returned null.");
        }
        return result;
    }

    public static <T extends PointerBase> T malloc(int size, NmtCategory category) {
        assert (size >= 0);
        return NativeMemory.malloc(Word.unsigned((int)size), category);
    }

    public static <T extends PointerBase> T calloc(UnsignedWord size, NmtCategory category) {
        Object result = NullableNativeMemory.calloc(size, category);
        if (result.isNull()) {
            throw new OutOfMemoryError("Memory allocation failed: calloc returned null.");
        }
        return result;
    }

    public static <T extends PointerBase> T calloc(int size, NmtCategory category) {
        assert (size >= 0);
        return NativeMemory.calloc(Word.unsigned((int)size), category);
    }

    public static <T extends PointerBase> T realloc(T ptr, UnsignedWord size, NmtCategory category) {
        T result = NullableNativeMemory.realloc(ptr, size, category);
        if (result.isNull()) {
            throw new OutOfMemoryError("Memory allocation failed: realloc returned null.");
        }
        return result;
    }

    public static <T extends PointerBase> T realloc(T ptr, int size, NmtCategory category) {
        assert (size >= 0);
        return NativeMemory.realloc(ptr, Word.unsigned((int)size), category);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static void free(PointerBase ptr) {
        NullableNativeMemory.free(ptr);
    }
}

