/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.SubstrateSegfaultHandler;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.c.function.CEntryPointOptions;
import com.oracle.svm.core.feature.AutomaticallyRegisteredImageSingleton;
import com.oracle.svm.core.headers.LibC;
import com.oracle.svm.core.heap.RestrictHeapAccess;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.os.MemoryProtectionProvider;
import com.oracle.svm.core.posix.PosixSignalHandlerSupport;
import com.oracle.svm.core.posix.headers.Signal;
import com.oracle.svm.core.util.VMError;
import org.graalvm.nativeimage.c.function.CEntryPoint;
import org.graalvm.nativeimage.c.function.CEntryPointLiteral;
import org.graalvm.nativeimage.c.type.VoidPointer;
import org.graalvm.word.PointerBase;

@AutomaticallyRegisteredImageSingleton(value={SubstrateSegfaultHandler.class, PosixSubstrateSegfaultHandler.class})
class PosixSubstrateSegfaultHandler
extends SubstrateSegfaultHandler {
    static final CEntryPointLiteral<Signal.AdvancedSignalDispatcher> SIGNAL_HANDLER = CEntryPointLiteral.create(PosixSubstrateSegfaultHandler.class, (String)"dispatch", (Class[])new Class[]{Integer.TYPE, Signal.siginfo_t.class, Signal.ucontext_t.class});

    PosixSubstrateSegfaultHandler() {
    }

    @CEntryPoint(include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    @CEntryPointOptions(prologue=CEntryPointOptions.NoPrologue.class, epilogue=CEntryPointOptions.NoEpilogue.class)
    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate in segfault signal handler.")
    @Uninterruptible(reason="Must be uninterruptible until it gets immune to safepoints")
    private static void dispatch(int signalNumber, Signal.siginfo_t sigInfo, Signal.ucontext_t uContext) {
        if (MemoryProtectionProvider.isAvailable()) {
            MemoryProtectionProvider.singleton().handleSegfault(sigInfo);
        }
        if (PosixSubstrateSegfaultHandler.tryEnterIsolate(uContext)) {
            PosixSubstrateSegfaultHandler.dump(sigInfo, uContext, true);
            throw VMError.shouldNotReachHereAtRuntime();
        }
        LibC.abort();
    }

    @Override
    protected void printSignalInfo(Log log, PointerBase signalInfo) {
        if (MemoryProtectionProvider.isAvailable()) {
            MemoryProtectionProvider.singleton().printSignalInfo(signalInfo);
        } else {
            Signal.siginfo_t sigInfo = (Signal.siginfo_t)signalInfo;
            log.string("siginfo: si_signo: ").signed(sigInfo.si_signo()).string(", si_code: ").signed(sigInfo.si_code());
            if (sigInfo.si_errno() != 0) {
                log.string(", si_errno: ").signed(sigInfo.si_errno());
            }
            VoidPointer addr = sigInfo.si_addr();
            log.string(", si_addr: ");
            PosixSubstrateSegfaultHandler.printSegfaultAddressInfo(log, addr.rawValue());
            log.newline();
        }
    }

    @Override
    public void install() {
        boolean isSignalHandlingAllowed = SubstrateOptions.EnableSignalHandling.getValue();
        PosixSignalHandlerSupport.installNativeSignalHandler(Signal.SignalEnum.SIGSEGV, (Signal.AdvancedSignalDispatcher)SIGNAL_HANDLER.getFunctionPointer(), Signal.SA_NODEFER(), isSignalHandlingAllowed);
        PosixSignalHandlerSupport.installNativeSignalHandler(Signal.SignalEnum.SIGBUS, (Signal.AdvancedSignalDispatcher)SIGNAL_HANDLER.getFunctionPointer(), Signal.SA_NODEFER(), isSignalHandlingAllowed);
    }
}

