/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.thread;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.thread.RecurringCallbackSupport;
import com.oracle.svm.core.thread.VMOperationControl;
import com.oracle.svm.core.thread.VMThreads;
import com.oracle.svm.core.threadlocal.FastThreadLocalFactory;
import com.oracle.svm.core.threadlocal.FastThreadLocalInt;
import com.oracle.svm.core.threadlocal.VMThreadLocalOffsetProvider;
import org.graalvm.nativeimage.CurrentIsolate;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.word.LocationIdentity;

public class SafepointCheckCounter {
    private static final FastThreadLocalInt valueTL = (FastThreadLocalInt)FastThreadLocalFactory.createInt("SafepointCheckCounter.value").setMaxOffset(63);
    static final int MAX_VALUE = Integer.MAX_VALUE;

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    static boolean compareAndSet(IsolateThread thread, int oldValue, int newValue) {
        return valueTL.compareAndSet(thread, oldValue, newValue);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    static void setVolatile(IsolateThread thread, int value) {
        assert (CurrentIsolate.getCurrentThread() == thread || VMThreads.StatusSupport.isStatusCreated(thread) || VMOperationControl.mayExecuteVmOperations());
        assert (RecurringCallbackSupport.isEnabled() && value > 0 || !RecurringCallbackSupport.isEnabled() && (value == 0 || value == Integer.MAX_VALUE));
        valueTL.setVolatile(thread, value);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    static void setVolatile(int value) {
        assert (value >= 0);
        valueTL.setVolatile(value);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    static int getVolatile(IsolateThread thread) {
        return valueTL.getVolatile(thread);
    }

    public static LocationIdentity getLocationIdentity() {
        return valueTL.getLocationIdentity();
    }

    public static int getThreadLocalOffset() {
        return VMThreadLocalOffsetProvider.getOffset(valueTL);
    }

    public static class TestingBackdoor {
        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public static int getValue() {
            return SafepointCheckCounter.getVolatile(CurrentIsolate.getCurrentThread());
        }
    }
}

