/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.util;

import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.util.TimeUtils;
import jdk.graal.compiler.word.Word;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;

public class MetricsLogUtils {
    static final int INDENT_LEVEL_0 = 0;
    static final int INDENT_LEVEL_1 = 2;
    static final int INDENT_LEVEL_2 = 4;
    static final int CATEGORY_FILL = 25;
    static final int VALUE_FILL = 10;
    static final int UNIT_FILL = 3;
    private static final TimeUnit DEFAULT_TIME_UNIT = TimeUnit.MILLIS;
    private static final MemoryUnit DEFAULT_MEMORY_UNIT = MemoryUnit.KILO;

    public static void logSection(String section) {
        MetricsLogUtils.logSection(section, 0);
    }

    public static void logSubSection(String section) {
        MetricsLogUtils.logSection(section, 2);
    }

    public static void logSection(String section, int ident) {
        Log log = Log.log();
        log.newline();
        log.spaces(ident);
        log.string(section);
        log.newline();
    }

    public static void logMemoryMetric(String category, long bytes) {
        MetricsLogUtils.logMemoryMetric(category, Word.unsigned((long)bytes));
    }

    public static void logMemoryMetric(String category, UnsignedWord bytes) {
        MetricsLogUtils.logMemoryMetric(category, bytes, DEFAULT_MEMORY_UNIT);
    }

    public static void logMemoryMetric(String category, UnsignedWord bytes, MemoryUnit unit) {
        Log log = Log.log();
        log.spaces(4);
        log.string(category, 25, 1).unsigned((WordBase)MetricsLogUtils.bytesToUnit(bytes, unit), 10, 2).string(unit.symbol(), 3, 2).newline();
    }

    public static void logTimeMetric(String category, long nanos) {
        MetricsLogUtils.logTimeMetric(category, nanos, DEFAULT_TIME_UNIT);
    }

    public static void logTimeMetric(String category, long nanos, TimeUnit unit) {
        Log log = Log.log();
        log.spaces(4);
        log.string(category, 25, 1).unsigned(MetricsLogUtils.nanosToUnit(nanos, unit), 10, 2).string(unit.symbol(), 3, 2).newline();
    }

    public static void logCounterMetric(String category, UnsignedWord value) {
        MetricsLogUtils.logCounterMetric(category, value.rawValue());
    }

    public static void logCounterMetric(String category, long value) {
        Log log = Log.log();
        log.spaces(4);
        log.string(category, 25, 1).unsigned(value, 10, 2).string("#", 3, 2).newline();
    }

    public static void logCounterMetric(String category, String value) {
        Log log = Log.log();
        log.spaces(4);
        log.string(category, 25, 1).string(value, 10, 2).string("#", 3, 2).newline();
    }

    public static void logPercentMetric(String category, long value) {
        Log log = Log.log();
        log.spaces(4);
        log.string(category, 25, 1).unsigned(value, 10, 2).string("%", 3, 2).newline();
    }

    public static void logPercentMetric(String category, String value) {
        Log log = Log.log();
        log.spaces(4);
        log.string(category, 25, 1).string(value, 10, 2).string("%", 3, 2).newline();
    }

    public static void logConfig(String category, String value) {
        Log log = Log.log();
        log.spaces(4);
        log.string(category, 25, 1).string(value, 10, 2).newline();
    }

    public static long nanosToUnit(long nanos, TimeUnit unit) {
        return unit.fromNanos(nanos);
    }

    public static UnsignedWord bytesToUnit(UnsignedWord bytes) {
        return MetricsLogUtils.bytesToUnit(bytes, DEFAULT_MEMORY_UNIT);
    }

    public static UnsignedWord bytesToUnit(UnsignedWord bytes, MemoryUnit unit) {
        return unit.fromBytes(bytes);
    }

    protected static enum MemoryUnit {
        BYTE("B"){

            @Override
            UnsignedWord fromBytes(UnsignedWord bytes) {
                return bytes;
            }
        }
        ,
        KILO("KB"){

            @Override
            UnsignedWord fromBytes(UnsignedWord bytes) {
                return MemoryUnit.toKilo(bytes);
            }
        }
        ,
        MEGA("MB"){

            @Override
            UnsignedWord fromBytes(UnsignedWord bytes) {
                return MemoryUnit.toKilo(MemoryUnit.toKilo(bytes));
            }
        }
        ,
        GIGA("GB"){

            @Override
            UnsignedWord fromBytes(UnsignedWord bytes) {
                return MemoryUnit.toKilo(MemoryUnit.toKilo(MemoryUnit.toKilo(bytes)));
            }
        };

        private final String symbol;

        private MemoryUnit(String symbol) {
            this.symbol = symbol;
        }

        public String symbol() {
            return this.symbol;
        }

        abstract UnsignedWord fromBytes(UnsignedWord var1);

        private static UnsignedWord toKilo(UnsignedWord bytes) {
            UnsignedWord bytedPerKilo = Word.unsigned((long)1024L);
            UnsignedWord result = bytes.unsignedDivide(bytedPerKilo);
            return result;
        }
    }

    private static enum TimeUnit {
        NANOS("ns"){

            @Override
            long fromNanos(long nanos) {
                return nanos;
            }
        }
        ,
        MILLIS("ms"){

            @Override
            long fromNanos(long nanos) {
                return TimeUtils.roundNanosToMillis(nanos);
            }
        }
        ,
        SECONDS("s"){

            @Override
            long fromNanos(long nanos) {
                return TimeUtils.roundNanosToSeconds(nanos);
            }
        };

        private final String symbol;

        private TimeUnit(String unit) {
            this.symbol = unit;
        }

        public String symbol() {
            return this.symbol;
        }

        abstract long fromNanos(long var1);
    }
}

