/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.graal.substitutions;

import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.graal.GraalCompilerSupport;
import com.oracle.svm.graal.hosted.GraalCompilerFeature;
import java.util.List;
import jdk.graal.compiler.core.gen.NodeLIRBuilder;
import jdk.graal.compiler.core.match.MatchRuleRegistry;
import jdk.graal.compiler.core.match.MatchStatement;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.options.OptionValues;
import org.graalvm.collections.EconomicMap;

@TargetClass(value=MatchRuleRegistry.class, onlyWith={GraalCompilerFeature.IsEnabled.class})
final class Target_jdk_graal_compiler_core_match_MatchRuleRegistry {
    Target_jdk_graal_compiler_core_match_MatchRuleRegistry() {
    }

    @Substitute
    public static EconomicMap<Class<? extends Node>, List<MatchStatement>> lookup(Class<? extends NodeLIRBuilder> theClass, OptionValues options, DebugContext debug) {
        EconomicMap<Class<? extends Node>, List<MatchStatement>> result = GraalCompilerSupport.get().matchRuleRegistry.get(theClass);
        if (result == null) {
            throw VMError.shouldNotReachHere(String.format("MatchRuleRegistry.lookup(): unexpected class %s", theClass.getName()));
        }
        return result;
    }
}

