/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.graal.substitutions;

import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.RecomputeFieldValue;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.graal.hosted.GraalCompilerFeature;
import com.oracle.svm.util.ReflectionUtil;
import jdk.graal.compiler.debug.DebugContext;
import org.graalvm.nativeimage.hosted.FieldValueTransformer;

@TargetClass(value=DebugContext.class, innerClass={"Immutable"}, onlyWith={GraalCompilerFeature.IsEnabled.class})
final class Target_jdk_graal_compiler_debug_DebugContext_Immutable {
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Custom, declClass=ClearImmutableCache.class)
    private static Target_jdk_graal_compiler_debug_DebugContext_Immutable[] CACHE;

    Target_jdk_graal_compiler_debug_DebugContext_Immutable() {
    }

    static class ClearImmutableCache
    implements FieldValueTransformer {
        ClearImmutableCache() {
        }

        public Object transform(Object receiver, Object originalValue) {
            for (Class<?> c : DebugContext.class.getDeclaredClasses()) {
                if (!c.getSimpleName().equals("Immutable")) continue;
                Object[] cache = (Object[])ReflectionUtil.readStaticField(c, (String)"CACHE");
                Object[] clearedCache = (Object[])cache.clone();
                for (int i = 0; i < clearedCache.length; ++i) {
                    clearedCache[i] = null;
                }
                return clearedCache;
            }
            throw VMError.shouldNotReachHere(String.format("Cannot find %s.Immutable", DebugContext.class.getName()));
        }
    }
}

