/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.jdk;

import com.oracle.graal.pointsto.heap.ImageHeapConstant;
import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.imagelayer.ImageLayerBuildingSupport;
import com.oracle.svm.core.jdk.DeferredCommonPool;
import com.oracle.svm.core.layeredimagesingleton.FeatureSingleton;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.imagelayer.CrossLayerConstantRegistry;
import java.util.concurrent.ForkJoinPool;
import jdk.vm.ci.meta.JavaConstant;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticallyRegisteredFeature
class ForkJoinPoolFeature
implements InternalFeature,
FeatureSingleton {
    private static final String KEY_NAME = "ForkJoinPool#commonPool";

    ForkJoinPoolFeature() {
    }

    public void duringSetup(Feature.DuringSetupAccess access) {
        CrossLayerConstantRegistry registry = CrossLayerConstantRegistry.singletonOrNull();
        if (ImageLayerBuildingSupport.buildingExtensionLayer() && registry.constantExists(KEY_NAME)) {
            ((FeatureImpl.DuringSetupAccessImpl)access).registerObjectToConstantReplacer(obj -> (ImageHeapConstant)ForkJoinPoolFeature.replaceCommonPoolWithLayerConstant(registry, obj));
        } else {
            DeferredCommonPool commonPool = new DeferredCommonPool();
            access.registerObjectReplacer(obj -> ForkJoinPoolFeature.replaceCommonPoolWithRuntimeObject(obj, commonPool));
            if (ImageLayerBuildingSupport.buildingSharedLayer()) {
                registry.registerConstantCandidate(KEY_NAME, commonPool);
            }
        }
    }

    private static Object replaceCommonPoolWithRuntimeObject(Object original, DeferredCommonPool commonPool) {
        if (original == ForkJoinPool.commonPool()) {
            return commonPool;
        }
        return original;
    }

    private static JavaConstant replaceCommonPoolWithLayerConstant(CrossLayerConstantRegistry registry, Object original) {
        if (original == ForkJoinPool.commonPool()) {
            return registry.getConstant(KEY_NAME);
        }
        return null;
    }
}

