/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.thread;

import com.oracle.svm.core.feature.AutomaticallyRegisteredImageSingleton;
import com.oracle.svm.core.layeredimagesingleton.ImageSingletonLoader;
import com.oracle.svm.core.layeredimagesingleton.ImageSingletonWriter;
import com.oracle.svm.core.layeredimagesingleton.LayeredImageSingleton;
import com.oracle.svm.core.layeredimagesingleton.LayeredImageSingletonBuilderFlags;
import java.util.EnumSet;
import org.graalvm.nativeimage.ImageSingletons;

@AutomaticallyRegisteredImageSingleton
class HostedJavaThreadsMetadata
implements LayeredImageSingleton {
    long maxThreadId;
    int maxAutonumber;

    HostedJavaThreadsMetadata() {
        this.maxThreadId = 0L;
        this.maxAutonumber = -1;
    }

    static HostedJavaThreadsMetadata singleton() {
        return (HostedJavaThreadsMetadata)ImageSingletons.lookup(HostedJavaThreadsMetadata.class);
    }

    private HostedJavaThreadsMetadata(long maxThreadId, int maxAutonumber) {
        this.maxThreadId = maxThreadId;
        this.maxAutonumber = maxAutonumber;
    }

    @Override
    public EnumSet<LayeredImageSingletonBuilderFlags> getImageBuilderFlags() {
        return LayeredImageSingletonBuilderFlags.BUILDTIME_ACCESS_ONLY;
    }

    @Override
    public LayeredImageSingleton.PersistFlags preparePersist(ImageSingletonWriter writer) {
        writer.writeLong("maxThreadId", this.maxThreadId);
        writer.writeInt("maxAutonumber", this.maxAutonumber);
        return LayeredImageSingleton.PersistFlags.CREATE;
    }

    public static Object createFromLoader(ImageSingletonLoader loader) {
        long maxThreadId = loader.readLong("maxThreadId");
        int maxAutonumber = loader.readInt("maxAutonumber");
        return new HostedJavaThreadsMetadata(maxThreadId, maxAutonumber);
    }
}

