/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.util;

import com.oracle.svm.hosted.ImageClassLoader;
import java.lang.management.ManagementFactory;
import java.nio.file.Path;
import java.util.List;
import java.util.stream.Collectors;

public class DiagnosticUtils {
    public static List<String> getClassPath(ImageClassLoader imageClassLoader) {
        return imageClassLoader.classpath().stream().map(Path::toString).collect(Collectors.toList());
    }

    public static List<String> getModulePath(ImageClassLoader imageClassLoader) {
        return imageClassLoader.modulepath().stream().map(Path::toString).collect(Collectors.toList());
    }

    public static List<String> getBuilderArguments(ImageClassLoader imageClassLoader) {
        return imageClassLoader.classLoaderSupport.getHostedOptionParser().getArguments();
    }

    public static List<String> getBuilderProperties() {
        return ManagementFactory.getRuntimeMXBean().getInputArguments().stream().filter(arg -> arg.startsWith("-D")).sorted().collect(Collectors.toList());
    }
}

