/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.jdwp.resident.impl;

import com.oracle.svm.core.code.FrameSourceInfo;
import com.oracle.svm.core.jdk.StackTraceUtils;
import com.oracle.svm.core.stack.JavaStackFrameVisitor;
import org.graalvm.word.Pointer;

abstract class AbstractJDWPJavaFrameInfoVisitor
extends JavaStackFrameVisitor {
    private final boolean filterExceptions;
    int currentFrameDepth;

    AbstractJDWPJavaFrameInfoVisitor(boolean filterExceptions) {
        this.filterExceptions = filterExceptions;
        this.currentFrameDepth = 0;
    }

    protected boolean ignoreFrame(FrameSourceInfo frameInfo) {
        if (!StackTraceUtils.shouldShowFrame(frameInfo, false, true, false)) {
            return true;
        }
        if (this.filterExceptions && this.currentFrameDepth == 0 && Throwable.class.isAssignableFrom(frameInfo.getSourceClass())) {
            return true;
        }
        String sourceClassName = null;
        Class<?> sourceClass = frameInfo.getSourceClass();
        if (sourceClass != null) {
            sourceClassName = sourceClass.getName();
        }
        return this.currentFrameDepth == 0 && sourceClassName != null && sourceClassName.startsWith("com.oracle.svm.jdwp.");
    }

    @Override
    public boolean visitFrame(FrameSourceInfo frameInfo, Pointer sp) {
        if (this.ignoreFrame(frameInfo)) {
            return true;
        }
        return this.processFrame(frameInfo, sp);
    }

    protected boolean processFrame(FrameSourceInfo frameInfo, Pointer sp) {
        ++this.currentFrameDepth;
        return true;
    }
}

