/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.jvmtiagentbase.jvmti;

import com.oracle.svm.core.OS;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import org.graalvm.nativeimage.c.CContext;

class JvmtiDirectives
implements CContext.Directives {
    private final Path jdkIncludeDir = Paths.get(System.getProperty("java.home"), new String[0]).resolve("include");

    JvmtiDirectives() {
    }

    public List<String> getHeaderFiles() {
        return Collections.singletonList("\"" + String.valueOf(this.jdkIncludeDir.resolve("jvmti.h")) + "\"");
    }

    public List<String> getOptions() {
        return Collections.singletonList("-I" + String.valueOf(this.jdkIncludeDir.resolve(OS.getCurrent() == OS.WINDOWS ? "win32" : OS.getCurrent().asPackageName())));
    }
}

