/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.espresso.classfile.attributes;

import com.oracle.svm.espresso.classfile.ConstantPool;
import com.oracle.svm.espresso.classfile.attributes.Attribute;
import com.oracle.svm.espresso.classfile.descriptors.Name;
import com.oracle.svm.espresso.classfile.descriptors.ParserSymbols;
import com.oracle.svm.espresso.classfile.descriptors.Symbol;
import java.util.HashSet;
import java.util.Set;

public class PermittedSubclassesAttribute
extends Attribute {
    public static final Symbol<Name> NAME = ParserSymbols.ParserNames.PermittedSubclasses;
    public static final PermittedSubclassesAttribute EMPTY = new PermittedSubclassesAttribute(NAME, new char[0]);
    private final char[] classes;

    public PermittedSubclassesAttribute(Symbol<Name> name, char[] classes) {
        assert (name == NAME);
        this.classes = classes;
    }

    public char[] getClasses() {
        return this.classes;
    }

    @Override
    public boolean isSame(Attribute other, ConstantPool thisPool, ConstantPool otherPool) {
        if (!super.isSame(other, thisPool, otherPool)) {
            return false;
        }
        PermittedSubclassesAttribute otherPermittedSubclassAttribute = (PermittedSubclassesAttribute)other;
        Set<Symbol<Name>> thisSymbols = PermittedSubclassesAttribute.fillSymbols(this.classes, thisPool);
        Set<Symbol<Name>> otherSymbols = PermittedSubclassesAttribute.fillSymbols(otherPermittedSubclassAttribute.classes, otherPool);
        return thisSymbols.equals(otherSymbols);
    }

    private static Set<Symbol<Name>> fillSymbols(char[] classIndices, ConstantPool pool) {
        HashSet<Symbol<Name>> symbols = new HashSet<Symbol<Name>>();
        for (char classIndex : classIndices) {
            symbols.add(pool.className(classIndex));
        }
        return symbols;
    }

    @Override
    public Symbol<Name> getName() {
        return NAME;
    }
}

