/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.espresso.shared.verifier;

import com.oracle.svm.espresso.classfile.ConstantPool;
import com.oracle.svm.espresso.classfile.bytecode.BytecodeStream;
import com.oracle.svm.espresso.classfile.descriptors.Symbol;
import com.oracle.svm.espresso.classfile.descriptors.Type;
import com.oracle.svm.espresso.classfile.descriptors.TypeSymbols;
import com.oracle.svm.espresso.shared.verifier.VerificationTypeInfo;

final class UninitializedVariable
extends VerificationTypeInfo {
    private final int newOffset;

    UninitializedVariable(int newOffset) {
        this.newOffset = newOffset;
    }

    @Override
    public int getTag() {
        return 8;
    }

    @Override
    public int getNewOffset() {
        return this.newOffset;
    }

    @Override
    protected String fromCP(ConstantPool pool) {
        return "new " + String.valueOf(pool.className(this.newOffset));
    }

    @Override
    public Symbol<Type> getType(ConstantPool pool, TypeSymbols types, BytecodeStream bs) {
        return types.fromClassNameEntry(pool.className(bs.readCPI(this.getNewOffset())));
    }
}

