/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.flow.context.bytecode;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.PointsToAnalysis;
import com.oracle.graal.pointsto.flow.context.object.AnalysisObject;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.typestate.PointsToStats;
import com.oracle.graal.pointsto.typestate.SingleTypeState;
import com.oracle.graal.pointsto.typestate.TypeState;
import java.util.Arrays;
import java.util.Iterator;
import jdk.vm.ci.meta.JavaConstant;

public class ContextSensitiveSingleTypeState
extends SingleTypeState {
    protected final AnalysisObject[] objects;

    public ContextSensitiveSingleTypeState(boolean canBeNull, AnalysisType type, AnalysisObject ... objects) {
        super(canBeNull, type);
        this.objects = objects;
        assert (ContextSensitiveSingleTypeState.checkObjects(objects));
    }

    protected ContextSensitiveSingleTypeState(boolean canBeNull, ContextSensitiveSingleTypeState other) {
        super(canBeNull, other);
        this.objects = other.objects;
    }

    private static boolean checkObjects(AnalysisObject[] objects) {
        for (int idx = 0; idx < objects.length - 1; ++idx) {
            AnalysisObject o0 = objects[idx];
            AnalysisObject o1 = objects[idx + 1];
            assert (o0 != null && o1 != null) : "Object state must contain non null elements.";
            assert (o0.type().equals(o1.type())) : "Single type state objects must have the same type.";
            assert (o0.getId() < o1.getId()) : "Analysis objects must be sorted by ID.";
        }
        return true;
    }

    @Override
    public final int objectsCount() {
        return this.objects.length;
    }

    @Override
    public Iterator<AnalysisObject> objectsIterator(BigBang bb) {
        return Arrays.asList(this.objects).iterator();
    }

    @Override
    protected Iterator<AnalysisObject> objectsIterator(final AnalysisType t) {
        return new Iterator<AnalysisObject>(this){
            private final boolean typesEqual;
            private int idx;
            final /* synthetic */ ContextSensitiveSingleTypeState this$0;
            {
                this.this$0 = this$0;
                this.typesEqual = this.this$0.type.equals(t);
                this.idx = 0;
            }

            @Override
            public boolean hasNext() {
                return this.typesEqual && this.idx < this.this$0.objects.length;
            }

            @Override
            public AnalysisObject next() {
                return this.this$0.objects[this.idx++];
            }
        };
    }

    @Override
    public TypeState forCanBeNull(PointsToAnalysis bb, boolean stateCanBeNull) {
        if (stateCanBeNull == this.canBeNull()) {
            return this;
        }
        return PointsToStats.registerTypeState(bb, new ContextSensitiveSingleTypeState(stateCanBeNull, this));
    }

    @Override
    public void noteMerge(PointsToAnalysis bb) {
        assert (bb.analysisPolicy().isMergingEnabled()) : "policy mismatch";
        if (!this.merged) {
            for (AnalysisObject obj : this.objects) {
                obj.noteMerge(bb);
            }
            this.merged = true;
        }
    }

    @Override
    public boolean isMerged() {
        return this.merged;
    }

    @Override
    public boolean isAllocation() {
        return this.objects[0].isAllocationContextSensitiveObject();
    }

    @Override
    public JavaConstant asConstant() {
        JavaConstant result = null;
        for (AnalysisObject object : this.objects) {
            JavaConstant objectConstant = object.asConstant();
            if (objectConstant == null || result != null && !result.equals((Object)objectConstant)) {
                return null;
            }
            result = objectConstant;
        }
        return result;
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.objects);
        result = 31 * result + (this.canBeNull ? 1 : 0);
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContextSensitiveSingleTypeState that = (ContextSensitiveSingleTypeState)o;
        return this.canBeNull == that.canBeNull && this.exactType().equals(that.exactType()) && Arrays.equals(this.objects, that.objects);
    }

    @Override
    public String toString() {
        return "1TypeMObject<" + (this.canBeNull ? "null," : "") + Arrays.toString(this.objects) + ">";
    }
}

