/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.util;

import java.util.Objects;
import jdk.graal.compiler.api.replacements.SnippetReflectionProvider;
import jdk.graal.compiler.api.runtime.GraalJVMCICompiler;
import jdk.graal.compiler.api.runtime.GraalRuntime;
import jdk.graal.compiler.core.target.Backend;
import jdk.graal.compiler.phases.util.Providers;
import jdk.graal.compiler.runtime.RuntimeProvider;
import jdk.vm.ci.code.TargetDescription;
import jdk.vm.ci.runtime.JVMCI;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

@Platforms(value={Platform.HOSTED_ONLY.class})
public final class GraalAccess {
    private static final GraalRuntime graalRuntime = ((GraalJVMCICompiler)JVMCI.getRuntime().getCompiler()).getGraalRuntime();
    private static final TargetDescription originalTarget;
    private static final Providers originalProviders;
    private static final SnippetReflectionProvider originalSnippetReflection;

    private GraalAccess() {
    }

    public static TargetDescription getOriginalTarget() {
        return originalTarget;
    }

    public static Providers getOriginalProviders() {
        return originalProviders;
    }

    public static SnippetReflectionProvider getOriginalSnippetReflection() {
        return originalSnippetReflection;
    }

    public static <T> T getGraalCapability(Class<T> clazz) {
        return (T)graalRuntime.getCapability(clazz);
    }

    static {
        Backend hostBackend = GraalAccess.getGraalCapability(RuntimeProvider.class).getHostBackend();
        originalTarget = Objects.requireNonNull(hostBackend.getTarget());
        originalProviders = Objects.requireNonNull(hostBackend.getProviders());
        originalSnippetReflection = Objects.requireNonNull(GraalAccess.getGraalCapability(SnippetReflectionProvider.class));
    }
}

