/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.processor;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.processing.Filer;
import javax.annotation.processing.FilerException;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;
import jdk.graal.compiler.processor.SuppressFBWarnings;

@SuppressFBWarnings(value={"NM_SAME_SIMPLE_NAME_AS_SUPERCLASS"}, justification="We want this type to be found when someone is writing a new Graal annotation processor")
public abstract class AbstractProcessor
extends javax.annotation.processing.AbstractProcessor {
    private final Map<String, TypeElement> types = new HashMap<String, TypeElement>();
    private static final Pattern QUALIFIED_CLASS_NAME_RE = Pattern.compile("(?:[a-z]\\w*\\.)+([A-Z].*)");

    public ProcessingEnvironment env() {
        return this.processingEnv;
    }

    @Override
    public final SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        return this.doProcess(annotations, roundEnv);
    }

    protected abstract boolean doProcess(Set<? extends TypeElement> var1, RoundEnvironment var2);

    public TypeMirror getType(String className) {
        return this.getTypeElement(className).asType();
    }

    public TypeMirror getType(Class<?> element) {
        if (element.isArray()) {
            return this.processingEnv.getTypeUtils().getArrayType(this.getType(element.getComponentType()));
        }
        if (element.isPrimitive()) {
            TypeKind typeKind;
            if (element == Void.TYPE) {
                return this.processingEnv.getTypeUtils().getNoType(TypeKind.VOID);
            }
            if (element == Boolean.TYPE) {
                typeKind = TypeKind.BOOLEAN;
            } else if (element == Byte.TYPE) {
                typeKind = TypeKind.BYTE;
            } else if (element == Short.TYPE) {
                typeKind = TypeKind.SHORT;
            } else if (element == Character.TYPE) {
                typeKind = TypeKind.CHAR;
            } else if (element == Integer.TYPE) {
                typeKind = TypeKind.INT;
            } else if (element == Long.TYPE) {
                typeKind = TypeKind.LONG;
            } else if (element == Float.TYPE) {
                typeKind = TypeKind.FLOAT;
            } else if (element == Double.TYPE) {
                typeKind = TypeKind.DOUBLE;
            } else {
                assert (false);
                return null;
            }
            return this.processingEnv.getTypeUtils().getPrimitiveType(typeKind);
        }
        TypeElement typeElement = this.getTypeElement(element.getCanonicalName());
        if (typeElement == null) {
            return null;
        }
        return this.processingEnv.getTypeUtils().erasure(typeElement.asType());
    }

    public TypeMirror getTypeOrNull(String className) {
        TypeElement element = this.getTypeElementOrNull(className);
        if (element == null) {
            return null;
        }
        return element.asType();
    }

    public TypeElement getTypeElement(String className) {
        TypeElement type = this.getTypeElementOrNull(className);
        if (type == null) {
            throw new NoClassDefFoundError(className);
        }
        return type;
    }

    public TypeElement getTypeElementOrNull(String className) {
        TypeElement type = this.types.get(className);
        if (type == null) {
            type = this.processingEnv.getElementUtils().getTypeElement(className);
            if (type == null) {
                return null;
            }
            this.types.put(className, type);
        }
        return type;
    }

    public TypeElement asTypeElement(TypeMirror type) {
        Element element = this.processingEnv.getTypeUtils().asElement(type);
        if (element == null) {
            throw new ClassCastException(String.valueOf(type) + " cannot be converted to a " + TypeElement.class.getName());
        }
        return (TypeElement)element;
    }

    public static String getSimpleName(String className) {
        Matcher m = QUALIFIED_CLASS_NAME_RE.matcher(className);
        if (m.matches()) {
            return m.group(1);
        }
        throw new IllegalArgumentException("Class name \"" + className + "\" does not match pattern " + String.valueOf(QUALIFIED_CLASS_NAME_RE));
    }

    public static String getPackageName(String className) {
        String simpleName = AbstractProcessor.getSimpleName(className);
        return className.substring(0, className.length() - simpleName.length() - 1);
    }

    public AnnotationMirror getAnnotation(Element element, TypeMirror annotationType) {
        List<AnnotationMirror> mirrors = this.getAnnotations(element, annotationType);
        return mirrors.isEmpty() ? null : mirrors.get(0);
    }

    public List<AnnotationMirror> getAnnotations(Element element, TypeMirror typeMirror) {
        ArrayList<AnnotationMirror> result = new ArrayList<AnnotationMirror>();
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            if (!this.processingEnv.getTypeUtils().isSameType(annotationMirror.getAnnotationType(), typeMirror)) continue;
            result.add(annotationMirror);
        }
        return result;
    }

    public static <T> T getAnnotationValue(AnnotationMirror annotation, String name, Class<T> type) {
        ExecutableElement valueMethod = null;
        for (ExecutableElement method : ElementFilter.methodsIn(annotation.getAnnotationType().asElement().getEnclosedElements())) {
            if (!method.getSimpleName().toString().equals(name)) continue;
            valueMethod = method;
            break;
        }
        if (valueMethod == null) {
            throw new NoSuchElementException(String.valueOf(annotation.getAnnotationType()) + " has no element named " + name);
        }
        AnnotationValue value = annotation.getElementValues().get(valueMethod);
        if (value == null) {
            value = valueMethod.getDefaultValue();
        }
        return type.cast(value.getValue());
    }

    public static <T> List<T> getAnnotationValueList(AnnotationMirror annotation, String name, Class<T> componentType) {
        List values = AbstractProcessor.getAnnotationValue(annotation, name, List.class);
        ArrayList<T> result = new ArrayList<T>();
        for (AnnotationValue value : values) {
            result.add(componentType.cast(value.getValue()));
        }
        return result;
    }

    public static PackageElement getPackage(Element element) {
        Element e;
        for (e = element.getEnclosingElement(); e != null && e.getKind() != ElementKind.PACKAGE; e = e.getEnclosingElement()) {
        }
        return (PackageElement)e;
    }

    public static PrintWriter createSourceFile(String pkg, String relativeName, Filer filer, Element ... originatingElements) {
        try {
            String className = pkg + "." + relativeName;
            JavaFileObject sourceFile = filer.createSourceFile(className, originatingElements);
            return new PrintWriter(sourceFile.openWriter()){

                @Override
                public void println() {
                    this.print("\n");
                }
            };
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void createProviderFile(String providerClassName, String serviceClassName, Element ... originatingElements) {
        assert (originatingElements.length > 0);
        String filename = "META-INF/providers/" + providerClassName;
        try {
            FileObject file = this.processingEnv.getFiler().createResource(StandardLocation.CLASS_OUTPUT, "", filename, originatingElements);
            PrintWriter writer = new PrintWriter(new OutputStreamWriter(file.openOutputStream(), "UTF-8"));
            writer.println(serviceClassName);
            writer.close();
        }
        catch (IOException e) {
            this.processingEnv.getMessager().printMessage(AbstractProcessor.isBug367599(e) ? Diagnostic.Kind.NOTE : Diagnostic.Kind.ERROR, e.getMessage(), originatingElements[0]);
        }
    }

    protected static boolean isBug367599(Throwable t) {
        if (t instanceof FilerException) {
            for (StackTraceElement ste : t.getStackTrace()) {
                if (!ste.toString().contains("org.eclipse.jdt.internal.apt.pluggable.core.filer.IdeFilerImpl.create")) continue;
                return true;
            }
        }
        return t.getCause() != null && AbstractProcessor.isBug367599(t.getCause());
    }
}

