/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.agent.conditionalconfig;

import com.oracle.svm.agent.configwithorigins.ConfigurationWithOriginsTracer;
import com.oracle.svm.agent.tracing.core.TracingResultWriter;
import com.oracle.svm.configure.config.conditional.PartialConfigurationWithOrigins;
import java.io.IOException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import jdk.graal.compiler.util.json.JsonWriter;

public class ConditionalConfigurationPartialRunWriter
implements TracingResultWriter {
    private final ConfigurationWithOriginsTracer tracer;

    public ConditionalConfigurationPartialRunWriter(ConfigurationWithOriginsTracer tracer) {
        this.tracer = tracer;
    }

    @Override
    public boolean supportsPeriodicTraceWriting() {
        return false;
    }

    @Override
    public boolean supportsOnUnloadTraceWriting() {
        return true;
    }

    @Override
    public List<Path> writeToDirectory(Path directoryPath) throws IOException {
        Path resolvedPath = directoryPath.resolve("partial-config-with-origins.json");
        try (JsonWriter writer = new JsonWriter(resolvedPath, new OpenOption[0]);){
            new PartialConfigurationWithOrigins(this.tracer.getRootNode(), null).printJson(writer);
        }
        return Collections.singletonList(resolvedPath);
    }
}

