/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.espresso.classfile;

import com.oracle.svm.espresso.classfile.ConstantPool;
import com.oracle.svm.espresso.classfile.ParserException;
import com.oracle.svm.espresso.classfile.descriptors.Symbol;
import java.util.Arrays;

public final class ParserConstantPool
extends ConstantPool {
    public ParserConstantPool(byte[] tags, int[] entries, Symbol<?>[] symbols, int majorVersion, int minorVersion) {
        super(tags, entries, symbols, majorVersion, minorVersion);
    }

    @Override
    public RuntimeException classFormatError(String message) {
        throw new ParserException.ClassFormatError(message);
    }

    @Override
    public ParserConstantPool getParserConstantPool() {
        return this;
    }

    public ParserConstantPool patchForHiddenClass(int thisKlassIndex, Symbol<?> newName) {
        int newNameIndex = this.entries.length;
        int newSymbolIndex = this.symbols.length;
        byte[] newTags = Arrays.copyOf(this.tags, this.tags.length + 1);
        int[] newEntries = Arrays.copyOf(this.entries, this.entries.length + 1);
        Symbol[] newSymbols = Arrays.copyOf(this.symbols, this.symbols.length + 1);
        newSymbols[newSymbolIndex] = newName;
        newTags[newNameIndex] = 1;
        newEntries[newNameIndex] = newSymbolIndex;
        newEntries[thisKlassIndex] = newNameIndex;
        return new ParserConstantPool(newTags, newEntries, newSymbols, this.majorVersion, this.minorVersion);
    }
}

