/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.espresso.classfile.attributes;

import com.oracle.svm.espresso.classfile.ConstantPool;
import com.oracle.svm.espresso.classfile.descriptors.Name;
import com.oracle.svm.espresso.classfile.descriptors.ParserSymbols;
import com.oracle.svm.espresso.classfile.descriptors.Symbol;
import java.util.Arrays;
import java.util.Objects;

public abstract class Attribute {
    public static final Attribute[] EMPTY_ARRAY = new Attribute[0];
    public static final Attribute SYNTHETIC = Attribute.createRaw(ParserSymbols.ParserNames.Synthetic, null);

    public abstract Symbol<Name> getName();

    public byte[] getData() {
        return null;
    }

    public boolean isSame(Attribute other, ConstantPool thisPool, ConstantPool otherPool) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        return Objects.equals(this.getName(), other.getName()) && Arrays.equals(this.getData(), other.getData());
    }

    public static Attribute createRaw(final Symbol<Name> name, final byte[] data) {
        return new Attribute(){

            @Override
            public Symbol<Name> getName() {
                return name;
            }

            @Override
            public byte[] getData() {
                return data;
            }
        };
    }
}

