/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.espresso.classfile.attributes;

import com.oracle.svm.espresso.classfile.ExceptionHandler;
import com.oracle.svm.espresso.classfile.attributes.Attribute;
import com.oracle.svm.espresso.classfile.attributes.LineNumberTableAttribute;
import com.oracle.svm.espresso.classfile.attributes.LocalVariableTable;
import com.oracle.svm.espresso.classfile.attributes.StackMapTableAttribute;
import com.oracle.svm.espresso.classfile.descriptors.Name;
import com.oracle.svm.espresso.classfile.descriptors.ParserSymbols;
import com.oracle.svm.espresso.classfile.descriptors.Symbol;

public final class CodeAttribute
extends Attribute {
    public static final Symbol<Name> NAME = ParserSymbols.ParserNames.Code;
    private final char maxStack;
    private final char maxLocals;
    private final byte[] originalCode;
    private final ExceptionHandler[] exceptionHandlerEntries;
    private final Attribute[] attributes;

    public CodeAttribute(Symbol<Name> name, int maxStack, int maxLocals, byte[] code, ExceptionHandler[] exceptionHandlerEntries, Attribute[] attributes) {
        assert (name == NAME);
        this.maxStack = (char)maxStack;
        this.maxLocals = (char)maxLocals;
        this.originalCode = code;
        this.exceptionHandlerEntries = exceptionHandlerEntries;
        this.attributes = attributes;
    }

    public CodeAttribute(CodeAttribute copy) {
        this(copy.getName(), copy.getMaxStack(), copy.getMaxLocals(), copy.getOriginalCode(), copy.getExceptionHandlers(), copy.attributes);
    }

    public int getMaxStack() {
        return this.maxStack;
    }

    public int getMaxLocals() {
        return this.maxLocals;
    }

    public Attribute[] getAttributes() {
        return this.attributes;
    }

    public byte[] getOriginalCode() {
        return this.originalCode;
    }

    public ExceptionHandler[] getExceptionHandlers() {
        return this.exceptionHandlerEntries;
    }

    public StackMapTableAttribute getStackMapFrame() {
        for (Attribute attr : this.attributes) {
            if (attr.getName() != ParserSymbols.ParserNames.StackMapTable) continue;
            return (StackMapTableAttribute)attr;
        }
        return null;
    }

    public LineNumberTableAttribute getLineNumberTableAttribute() {
        for (Attribute attr : this.attributes) {
            if (attr.getName() != ParserSymbols.ParserNames.LineNumberTable) continue;
            return (LineNumberTableAttribute)attr;
        }
        return LineNumberTableAttribute.EMPTY;
    }

    public LocalVariableTable getLocalvariableTable() {
        for (Attribute attr : this.attributes) {
            if (attr.getName() != ParserSymbols.ParserNames.LocalVariableTable) continue;
            return (LocalVariableTable)attr;
        }
        return LocalVariableTable.EMPTY_LVT;
    }

    public LocalVariableTable getLocalvariableTypeTable() {
        for (Attribute attr : this.attributes) {
            if (attr.getName() != ParserSymbols.ParserNames.LocalVariableTypeTable) continue;
            return (LocalVariableTable)attr;
        }
        return LocalVariableTable.EMPTY_LVTT;
    }

    public int bciToLineNumber(int bci) {
        LineNumberTableAttribute lnt = this.getLineNumberTableAttribute();
        if (lnt == LineNumberTableAttribute.EMPTY) {
            return -1;
        }
        return lnt.getLineNumber(bci);
    }

    @Override
    public Symbol<Name> getName() {
        return NAME;
    }
}

