/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.espresso.classfile.attributes;

import com.oracle.svm.espresso.classfile.attributes.Attribute;
import com.oracle.svm.espresso.classfile.attributes.Local;
import com.oracle.svm.espresso.classfile.attributes.LocalVariableTableRef;
import com.oracle.svm.espresso.classfile.descriptors.Name;
import com.oracle.svm.espresso.classfile.descriptors.ParserSymbols;
import com.oracle.svm.espresso.classfile.descriptors.Symbol;
import java.util.ArrayList;

public final class LocalVariableTable
extends Attribute
implements LocalVariableTableRef {
    public static final LocalVariableTable EMPTY_LVT = new LocalVariableTable(ParserSymbols.ParserNames.LocalVariableTable, Local.EMPTY_ARRAY);
    public static final LocalVariableTable EMPTY_LVTT = new LocalVariableTable(ParserSymbols.ParserNames.LocalVariableTypeTable, Local.EMPTY_ARRAY);
    private final boolean isTypeTable;
    private final Local[] locals;

    public LocalVariableTable(Symbol<Name> name, Local[] locals) {
        assert (name == ParserSymbols.ParserNames.LocalVariableTable || name == ParserSymbols.ParserNames.LocalVariableTypeTable);
        this.isTypeTable = name == ParserSymbols.ParserNames.LocalVariableTypeTable;
        this.locals = locals;
    }

    public Local getLocal(int slot, int bci) {
        Local result = null;
        for (Local local : this.locals) {
            if (local.getSlot() != slot || local.getStartBCI() > bci || local.getEndBCI() < bci) continue;
            if (result == null) {
                result = local;
                continue;
            }
            throw new IllegalStateException("Locals overlap!");
        }
        return result;
    }

    public Local[] getLocals() {
        return (Local[])this.locals.clone();
    }

    public Local[] getLocalsAt(int bci) {
        ArrayList<Local> result = new ArrayList<Local>();
        for (Local l : this.locals) {
            if (l.getStartBCI() > bci || bci > l.getEndBCI()) continue;
            result.add(l);
        }
        return result.toArray(Local.EMPTY_ARRAY);
    }

    @Override
    public Symbol<Name> getName() {
        return this.isTypeTable ? ParserSymbols.ParserNames.LocalVariableTypeTable : ParserSymbols.ParserNames.LocalVariableTable;
    }
}

