/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.espresso.classfile.descriptors;

import com.oracle.svm.espresso.classfile.descriptors.Symbol;
import java.io.IOException;
import java.io.UTFDataFormatException;
import java.nio.ByteBuffer;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public class ModifiedUTF8 {
    private static final char REPLACEMENT_CHARACTER = '\ufffd';

    public static Symbol<ModifiedUTF8> fromSymbol(Symbol<? extends ModifiedUTF8> symbol) {
        return symbol;
    }

    public static int utfLength(String str) {
        return ModifiedUTF8.utfLength(str, 0, str.length());
    }

    public static int utfLength(String str, int start, int len) {
        char c;
        int i;
        int utflen = 0;
        for (i = 0; i < len && (c = str.charAt(start + i)) >= '\u0001' && c <= '\u007f'; ++i) {
            ++utflen;
        }
        while (i < len) {
            c = str.charAt(start + i);
            utflen = c >= '\u0001' && c <= '\u007f' ? ++utflen : (c > '\u07ff' ? (utflen += 3) : (utflen += 2));
            ++i;
        }
        return utflen;
    }

    public static byte[] fromJavaString(String str, boolean append0) {
        return ModifiedUTF8.fromJavaString(str, 0, str.length(), append0);
    }

    public static byte[] fromJavaString(String str, int start, int len, boolean append0) {
        return ModifiedUTF8.fromJavaString(str, start, len, append0, false);
    }

    static byte[] fromJavaString(String str, int start, int len, boolean append0, boolean addLSemi) {
        char c;
        int i;
        int utflen = ModifiedUTF8.utfLength(str, start, len);
        byte[] bytearr = new byte[utflen + (append0 ? 1 : 0) + (addLSemi ? 2 : 0)];
        int count = 0;
        if (addLSemi) {
            bytearr[count++] = 76;
        }
        for (i = 0; i < len && (c = str.charAt(start + i)) >= '\u0001' && c <= '\u007f'; ++i) {
            bytearr[count++] = (byte)c;
        }
        while (i < len) {
            c = str.charAt(start + i);
            if (c >= '\u0001' && c <= '\u007f') {
                bytearr[count++] = (byte)c;
            } else if (c > '\u07ff') {
                bytearr[count++] = (byte)(0xE0 | c >> 12 & 0xF);
                bytearr[count++] = (byte)(0x80 | c >> 6 & 0x3F);
                bytearr[count++] = (byte)(0x80 | c >> 0 & 0x3F);
            } else {
                bytearr[count++] = (byte)(0xC0 | c >> 6 & 0x1F);
                bytearr[count++] = (byte)(0x80 | c >> 0 & 0x3F);
            }
            ++i;
        }
        if (addLSemi) {
            bytearr[count++] = 59;
        }
        if (append0) {
            assert (count == bytearr.length - 1);
            bytearr[count++] = 0;
        }
        assert (count == bytearr.length);
        return bytearr;
    }

    public static byte[] fromJavaString(String string) {
        return ModifiedUTF8.fromJavaString(string, false);
    }

    public static String toJavaString(byte[] bytearr) throws IOException {
        return ModifiedUTF8.toJavaString(bytearr, 0, bytearr.length);
    }

    public static String toJavaString(byte[] bytearr, int offset, int utflen) throws IOException {
        return ModifiedUTF8.toJavaString(ByteBuffer.wrap(bytearr, offset, utflen));
    }

    public static String toJavaString(ByteBuffer buffer) throws IOException {
        int c;
        char[] chararr = new char[buffer.remaining()];
        int chararrCount = 0;
        while (buffer.hasRemaining()) {
            c = buffer.get() & 0xFF;
            if (c > 127) {
                buffer.position(buffer.position() - 1);
                break;
            }
            chararr[chararrCount++] = (char)c;
        }
        block6: while (buffer.hasRemaining()) {
            c = buffer.get() & 0xFF;
            switch (c >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    chararr[chararrCount++] = (char)c;
                    continue block6;
                }
                case 12: 
                case 13: {
                    if (!buffer.hasRemaining()) {
                        throw ModifiedUTF8.throwUTFDataFormatException("malformed input: partial character at end");
                    }
                    byte char2 = buffer.get();
                    if ((char2 & 0xC0) != 128) {
                        throw ModifiedUTF8.throwUTFDataFormatException(ModifiedUTF8.malformedInputMessage(buffer.position()));
                    }
                    chararr[chararrCount++] = (char)((c & 0x1F) << 6 | char2 & 0x3F);
                    continue block6;
                }
                case 14: {
                    if (buffer.remaining() < 2) {
                        throw ModifiedUTF8.throwUTFDataFormatException("malformed input: partial character at end");
                    }
                    byte char2 = buffer.get();
                    byte char3 = buffer.get();
                    if ((char2 & 0xC0) != 128 || (char3 & 0xC0) != 128) {
                        throw ModifiedUTF8.throwUTFDataFormatException(ModifiedUTF8.malformedInputMessage(buffer.position() - 1));
                    }
                    chararr[chararrCount++] = (char)((c & 0xF) << 12 | (char2 & 0x3F) << 6 | (char3 & 0x3F) << 0);
                    continue block6;
                }
            }
            throw ModifiedUTF8.throwUTFDataFormatException(ModifiedUTF8.malformedInputMessage(buffer.position()));
        }
        return new String(chararr, 0, chararrCount);
    }

    public static String toJavaStringSafe(ByteBuffer buffer) {
        int c;
        char[] chararr = new char[buffer.remaining()];
        int chararrCount = 0;
        while (buffer.hasRemaining()) {
            c = buffer.get() & 0xFF;
            if (c > 127) {
                buffer.position(buffer.position() - 1);
                break;
            }
            chararr[chararrCount++] = (char)c;
        }
        block6: while (buffer.hasRemaining()) {
            c = buffer.get() & 0xFF;
            switch (c >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    chararr[chararrCount++] = (char)c;
                    continue block6;
                }
                case 12: 
                case 13: {
                    if (!buffer.hasRemaining() && chararrCount < chararr.length) {
                        chararr[chararrCount] = 65533;
                        continue block6;
                    }
                    byte char2 = buffer.get();
                    if ((char2 & 0xC0) != 128) {
                        chararr[chararrCount++] = 65533;
                        continue block6;
                    }
                    chararr[chararrCount++] = (char)((c & 0x1F) << 6 | char2 & 0x3F);
                    continue block6;
                }
                case 14: {
                    if (buffer.remaining() < 2 && chararrCount < chararr.length) {
                        chararr[chararrCount] = 65533;
                        continue block6;
                    }
                    byte char2 = buffer.get();
                    byte char3 = buffer.get();
                    if ((char2 & 0xC0) != 128 || (char3 & 0xC0) != 128) {
                        chararr[chararrCount++] = 65533;
                        continue block6;
                    }
                    chararr[chararrCount++] = (char)((c & 0xF) << 12 | (char2 & 0x3F) << 6 | (char3 & 0x3F) << 0);
                    continue block6;
                }
            }
            chararr[chararrCount++] = 65533;
        }
        return new String(chararr, 0, chararrCount);
    }

    private static UTFDataFormatException throwUTFDataFormatException(String message) throws UTFDataFormatException {
        throw new UTFDataFormatException(message);
    }

    private static String malformedInputMessage(int count) {
        return "malformed input around byte " + count;
    }

    public static boolean isValid(byte[] bytearr, int offset, int length) {
        int c;
        int count;
        for (count = 0; count < length && (c = bytearr[count + offset] & 0xFF) != 0 && c <= 127; ++count) {
        }
        block6: while (count < length) {
            byte char2;
            c = bytearr[count + offset] & 0xFF;
            if (c == 0) {
                if ((count += 2) > length) {
                    return false;
                }
                char2 = bytearr[count - 1 + offset];
                if (char2 == 0) continue;
                return false;
            }
            switch (c >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++count;
                    continue block6;
                }
                case 12: 
                case 13: {
                    if ((count += 2) > length) {
                        return false;
                    }
                    char2 = bytearr[count - 1 + offset];
                    if ((char2 & 0xC0) == 128) continue block6;
                    return false;
                }
                case 14: {
                    if ((count += 3) > length) {
                        return false;
                    }
                    char2 = bytearr[count - 2 + offset];
                    byte char3 = bytearr[count - 1 + offset];
                    if ((char2 & 0xC0) == 128 && (char3 & 0xC0) == 128) continue block6;
                    return false;
                }
            }
            return false;
        }
        return true;
    }
}

