/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.espresso.classfile.descriptors;

import com.oracle.svm.espresso.classfile.descriptors.ByteSequence;
import com.oracle.svm.espresso.classfile.descriptors.Name;
import com.oracle.svm.espresso.classfile.descriptors.Symbol;
import com.oracle.svm.espresso.classfile.descriptors.Symbols;

public final class NameSymbols {
    private final Symbols symbols;

    public NameSymbols(Symbols symbols) {
        this.symbols = symbols;
    }

    public Symbol<Name> lookup(ByteSequence nameBytes) {
        return this.symbols.lookup(nameBytes);
    }

    public Symbol<Name> lookup(String nameString) {
        return this.lookup(ByteSequence.create(nameString));
    }

    public Symbol<Name> getOrCreate(String nameString) {
        return this.getOrCreate(ByteSequence.create(nameString));
    }

    public Symbol<Name> getOrCreate(ByteSequence nameBytes) {
        return this.getOrCreate(nameBytes, false);
    }

    public Symbol<Name> getOrCreate(ByteSequence nameBytes, boolean ensureStrongReference) {
        return this.symbols.getOrCreate(nameBytes, ensureStrongReference);
    }

    public static boolean isUnnamedPackage(Symbol<Name> pkg) {
        return pkg.length() == 0;
    }
}

