/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.espresso.classfile.descriptors;

import com.oracle.svm.espresso.classfile.descriptors.ByteSequence;
import com.oracle.svm.espresso.classfile.descriptors.ModifiedUTF8;
import com.oracle.svm.espresso.classfile.descriptors.Name;
import com.oracle.svm.espresso.classfile.descriptors.ParserSymbols;
import com.oracle.svm.espresso.classfile.descriptors.Signature;
import com.oracle.svm.espresso.classfile.descriptors.Type;
import com.oracle.svm.espresso.classfile.descriptors.Validation;
import com.oracle.svm.espresso.classfile.descriptors.ValidationException;

public final class Symbol<T>
extends ByteSequence {
    public static final Symbol[] EMPTY_ARRAY = new Symbol[0];
    private byte validationCache;
    private static final byte VALID_CLASS_NAME = 1;
    private static final byte VALID_METHOD_NAME = 2;
    private static final byte VALID_FIELD_NAME = 4;
    private static final byte VALID_SIGNATURE = 8;
    private static final byte VALID_TYPE = 16;
    private static final byte VALID_UTF8 = 32;

    Symbol(byte[] bytes, int hashCode) {
        super(bytes, hashCode);
    }

    Symbol(byte[] value) {
        this(value, ByteSequence.hashOfRange(value, 0, value.length));
    }

    public static <S> Symbol<S>[] emptyArray() {
        return EMPTY_ARRAY;
    }

    @Override
    public byte byteAt(int index) {
        return this.value[index];
    }

    @Override
    public int length() {
        return this.value.length;
    }

    @Override
    int offset() {
        return 0;
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof Symbol) {
            Symbol that = (Symbol)other;
            assert (this == that || !super.equals(that));
            return this == that;
        }
        return super.equals(other);
    }

    public Symbol<ModifiedUTF8> validate() throws ValidationException {
        return this.validateUTF8().unsafeCast();
    }

    public Symbol<? extends ModifiedUTF8> validateUTF8() throws ValidationException {
        if ((this.validationCache & 0x20) == 0) {
            if (!Validation.validModifiedUTF8(this)) {
                throw ValidationException.raise("Ill-formed modified-UTF8 entry");
            }
            this.validationCache = (byte)(this.validationCache | 0x20);
        }
        return this.unsafeCast();
    }

    private <R> Symbol<R> unsafeCast() {
        return this;
    }

    public Symbol<Name> validateClassName() throws ValidationException {
        this.validateUTF8();
        if ((this.validationCache & 1) == 0) {
            if (!Validation.validClassNameEntry(this)) {
                throw ValidationException.raise("Invalid class name entry: " + String.valueOf(this));
            }
            this.validationCache = (byte)(this.validationCache | 1);
        }
        return this.unsafeCast();
    }

    public Symbol<Type> validateType(boolean allowVoid) throws ValidationException {
        this.validateUTF8();
        if ((this.validationCache & 0x10) == 0) {
            if (!Validation.validTypeDescriptor(this, true)) {
                throw ValidationException.raise("Invalid type descriptor: " + String.valueOf(this));
            }
            this.validationCache = (byte)(this.validationCache | 0x10);
        }
        if (!allowVoid && this == ParserSymbols.ParserTypes._void) {
            throw ValidationException.raise("Invalid type descriptor (void not allowed)");
        }
        return this.unsafeCast();
    }

    public Symbol<Name> validateMethodName() throws ValidationException {
        this.validateUTF8();
        if ((this.validationCache & 2) == 0) {
            if (!Validation.validMethodName(this)) {
                throw ValidationException.raise("Invalid method name: " + String.valueOf(this));
            }
            this.validationCache = (byte)(this.validationCache | 2);
        }
        return this.unsafeCast();
    }

    public Symbol<Name> validateFieldName() throws ValidationException {
        this.validateUTF8();
        if ((this.validationCache & 4) == 0) {
            if (!Validation.validUnqualifiedName(this)) {
                throw ValidationException.raise("Invalid field name: " + String.valueOf(this));
            }
            this.validationCache = (byte)(this.validationCache | 4);
        }
        return this.unsafeCast();
    }

    public Symbol<Signature> validateSignature() throws ValidationException {
        this.validateUTF8();
        if ((this.validationCache & 8) == 0) {
            if (!Validation.validSignatureDescriptor(this)) {
                throw ValidationException.raise("Invalid signature descriptor: " + String.valueOf(this));
            }
            this.validationCache = (byte)(this.validationCache | 8);
        }
        return this.unsafeCast();
    }

    public int validateSignatureGetSlots() throws ValidationException {
        this.validateUTF8();
        int slots = Validation.validSignatureDescriptorGetSlots(this);
        if (slots < 0) {
            throw ValidationException.raise("Invalid signature descriptor: " + String.valueOf(this));
        }
        if ((this.validationCache & 1) == 0) {
            this.validationCache = (byte)(this.validationCache | 8);
        }
        return slots;
    }
}

