/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.espresso.classfile.tables;

import com.oracle.svm.espresso.classfile.descriptors.Name;
import com.oracle.svm.espresso.classfile.descriptors.Symbol;
import com.oracle.svm.espresso.classfile.tables.AbstractModuleTable;
import com.oracle.svm.espresso.classfile.tables.EntryTable;
import java.util.ArrayList;
import java.util.concurrent.locks.ReadWriteLock;

public abstract class AbstractPackageTable<M, PE extends AbstractPackageEntry<M, ME>, ME extends AbstractModuleTable.AbstractModuleEntry<M>>
extends EntryTable<PE, ME> {
    public AbstractPackageTable(ReadWriteLock lock) {
        super(lock);
    }

    public static abstract class AbstractPackageEntry<M, ME extends AbstractModuleTable.AbstractModuleEntry<M>>
    extends EntryTable.NamedEntry {
        private final ME module;
        private ArrayList<ME> exports;
        private boolean isUnqualifiedExported;
        private boolean isExportedAllUnnamed;
        private String bootClasspathLocation;

        protected AbstractPackageEntry(Symbol<Name> name, ME module) {
            super(name);
            this.module = module;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addExports(ME m) {
            if (this.isUnqualifiedExported()) {
                return;
            }
            AbstractPackageEntry abstractPackageEntry = this;
            synchronized (abstractPackageEntry) {
                if (m == null) {
                    this.setUnqualifiedExports();
                }
                if (this.exports == null) {
                    this.exports = new ArrayList();
                }
                if (!this.contains(m)) {
                    this.exports.add(m);
                }
            }
        }

        public boolean isQualifiedExportTo(ME m) {
            if (this.isExportedAllUnnamed() && !((AbstractModuleTable.AbstractModuleEntry)m).isNamed()) {
                return true;
            }
            if (this.isUnqualifiedExported() || this.exports == null) {
                return false;
            }
            return this.contains(m);
        }

        public boolean isUnqualifiedExported() {
            return ((AbstractModuleTable.AbstractModuleEntry)this.module()).isOpen() || this.isUnqualifiedExported;
        }

        public void setUnqualifiedExports() {
            if (this.isUnqualifiedExported()) {
                return;
            }
            this.isUnqualifiedExported = true;
            this.isExportedAllUnnamed = true;
            this.exports = null;
        }

        public boolean isExportedAllUnnamed() {
            return ((AbstractModuleTable.AbstractModuleEntry)this.module()).isOpen() || this.isExportedAllUnnamed;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setExportedAllUnnamed() {
            if (this.isExportedAllUnnamed()) {
                return;
            }
            AbstractPackageEntry abstractPackageEntry = this;
            synchronized (abstractPackageEntry) {
                this.isExportedAllUnnamed = true;
            }
        }

        public boolean contains(ME m) {
            return this.exports.contains(m);
        }

        public ME module() {
            return this.module;
        }

        public void setBootClasspathLocation(String bootClasspathLocation) {
            this.bootClasspathLocation = bootClasspathLocation;
        }

        public String getBootClasspathLocation() {
            return this.bootClasspathLocation;
        }
    }
}

