/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.espresso.shared.verifier;

import com.oracle.svm.espresso.classfile.descriptors.ParserSymbols;
import com.oracle.svm.espresso.shared.meta.FieldAccess;
import com.oracle.svm.espresso.shared.meta.MethodAccess;
import com.oracle.svm.espresso.shared.meta.RuntimeAccess;
import com.oracle.svm.espresso.shared.meta.TypeAccess;
import com.oracle.svm.espresso.shared.verifier.MethodVerifier;
import com.oracle.svm.espresso.shared.verifier.Operand;
import com.oracle.svm.espresso.shared.verifier.ReferenceOperand;
import com.oracle.svm.espresso.shared.verifier.ReturnAddressOperand;
import com.oracle.svm.espresso.shared.verifier.StackFrame;
import com.oracle.svm.espresso.shared.verifier.SubroutineModificationStack;
import com.oracle.svm.espresso.shared.verifier.UninitReferenceOperand;

final class Locals<R extends RuntimeAccess<C, M, F>, C extends TypeAccess<C, M, F>, M extends MethodAccess<C, M, F>, F extends FieldAccess<C, M, F>> {
    final MethodVerifier<R, C, M, F> mv;
    Operand<R, C, M, F>[] registers;
    SubroutineModificationStack subRoutineModifications;

    Locals(MethodVerifier<R, C, M, F> mv) {
        this.mv = mv;
        Operand<R, C, M, F>[] parsedSig = mv.getOperandSig(mv.getSig());
        int sigSize = mv.isStatic() ? 0 : 1;
        for (int i = 0; i < parsedSig.length - 1; ++i) {
            Operand<R, C, M, F> op = parsedSig[i];
            sigSize += op.isType2() ? 2 : 1;
        }
        MethodVerifier.formatGuarantee(sigSize <= mv.getMaxLocals(), "Too many method arguments for the number of locals !");
        this.registers = new Operand[mv.getMaxLocals()];
        int index = 0;
        if (!mv.isStatic()) {
            this.registers[index++] = ParserSymbols.ParserNames._init_.equals(mv.getMethodName()) ? new UninitReferenceOperand(mv.getThisKlass()) : new ReferenceOperand(mv.getThisKlass());
        }
        for (int i = 0; i < parsedSig.length - 1; ++i) {
            Operand<R, C, M, F> op = parsedSig[i];
            this.registers[index++] = op.getKind().isStackInt() ? mv.intOp : op;
            if (!op.isType2()) continue;
            this.registers[index++] = mv.invalidOp;
        }
        while (index < mv.getMaxLocals()) {
            this.registers[index] = mv.invalidOp;
            ++index;
        }
    }

    Locals(MethodVerifier<R, C, M, F> mv, Operand<R, C, M, F>[] registers) {
        this.mv = mv;
        this.registers = registers;
    }

    Operand<R, C, M, F>[] extract() {
        return (Operand[])this.registers.clone();
    }

    Operand<R, C, M, F> load(int index, Operand<R, C, M, F> expected) {
        Operand<R, C, M, F> op = this.registers[index];
        MethodVerifier.verifyGuarantee(op.compliesWith(expected, this.mv), "Incompatible register type. Expected: " + String.valueOf(expected) + ", found: " + String.valueOf(op));
        if (expected.isType2()) {
            MethodVerifier.verifyGuarantee(this.registers[index + 1].isTopOperand(), "Loading corrupted long primitive from locals!");
        }
        return op;
    }

    Operand<R, C, M, F> loadRef(int index) {
        Operand<R, C, M, F> op = this.registers[index];
        MethodVerifier.verifyGuarantee(op.isReference(), "Incompatible register type. Expected a reference, found: " + String.valueOf(op));
        return op;
    }

    ReturnAddressOperand<R, C, M, F> loadReturnAddress(int index) {
        Operand<R, C, M, F> op = this.registers[index];
        MethodVerifier.verifyGuarantee(op.isReturnAddress(), "Incompatible register type. Expected a ReturnAddress, found: " + String.valueOf(op));
        return (ReturnAddressOperand)op;
    }

    void store(int index, Operand<R, C, M, F> op) {
        boolean subRoutine = this.subRoutineModifications != null;
        this.registers[index] = op;
        if (subRoutine) {
            this.subRoutineModifications.subRoutineModifications[index] = true;
        }
        if (index >= 1 && this.registers[index - 1].isType2()) {
            this.registers[index - 1] = this.mv.invalidOp;
            if (subRoutine) {
                this.subRoutineModifications.subRoutineModifications[index - 1] = true;
            }
        }
        if (op.isType2()) {
            this.registers[index + 1] = this.mv.invalidOp;
            if (subRoutine) {
                this.subRoutineModifications.subRoutineModifications[index + 1] = true;
            }
        }
    }

    int mergeInto(StackFrame<R, C, M, F> frame) {
        assert (this.registers.length == frame.locals.length);
        Operand<R, C, M, F>[] frameLocals = frame.locals;
        for (int i = 0; i < this.registers.length; ++i) {
            if (this.registers[i].compliesWithInMerge(frameLocals[i], this.mv)) continue;
            return i;
        }
        return -1;
    }

    void initUninit(UninitReferenceOperand<R, C, M, F> toInit, Operand<R, C, M, F> stackOp) {
        for (int i = 0; i < this.registers.length; ++i) {
            if (!this.registers[i].isUninit() || ((UninitReferenceOperand)this.registers[i]).newBCI != toInit.newBCI) continue;
            this.registers[i] = stackOp;
        }
    }
}

