/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.objectfile.dwarf;

import com.oracle.objectfile.debugentry.ClassEntry;
import com.oracle.objectfile.debugentry.DebugInfoBase;
import com.oracle.objectfile.debugentry.MethodEntry;
import com.oracle.objectfile.debugentry.StructureTypeEntry;
import com.oracle.objectfile.debugentry.TypeEntry;
import com.oracle.objectfile.debugentry.range.Range;
import com.oracle.objectfile.debuginfo.DebugInfoProvider;
import com.oracle.objectfile.dwarf.constants.DwarfLanguage;
import com.oracle.objectfile.dwarf.constants.DwarfSectionName;
import java.nio.ByteOrder;
import org.graalvm.collections.EconomicMap;

public abstract class DwarfDebugInfo
extends DebugInfoBase {
    public static final String HEAP_BEGIN_NAME = "__svm_heap_begin";
    public static final DwarfLanguage LANG_ENCODING = DwarfLanguage.DW_LANG_Java;
    public static final byte rheapbase_aarch64 = 27;
    public static final byte rthread_aarch64 = 28;
    public static final byte rheapbase_x86 = 14;
    public static final byte rthread_x86 = 15;
    public static final String COMPRESSED_PREFIX = "_z_.";
    public static final String LAYOUT_PREFIX = "_layout_.";
    public static final String HUB_TYPE_NAME = "Encoded$Dynamic$Hub";
    private final EconomicMap<TypeEntry, DwarfClassProperties> classPropertiesIndex = EconomicMap.create();
    private final EconomicMap<MethodEntry, DwarfMethodProperties> methodPropertiesIndex = EconomicMap.create();
    private final EconomicMap<Range, DwarfLocalProperties> rangeLocalPropertiesIndex = EconomicMap.create();

    public DwarfDebugInfo(ByteOrder byteOrder) {
        super(byteOrder);
    }

    private DwarfClassProperties addClassProperties(StructureTypeEntry entry) {
        DwarfClassProperties classProperties = new DwarfClassProperties(entry);
        this.classPropertiesIndex.put((Object)entry, (Object)classProperties);
        return classProperties;
    }

    private DwarfMethodProperties addMethodProperties(MethodEntry methodEntry) {
        assert (this.methodPropertiesIndex.get((Object)methodEntry) == null);
        DwarfMethodProperties methodProperties = new DwarfMethodProperties();
        this.methodPropertiesIndex.put((Object)methodEntry, (Object)methodProperties);
        return methodProperties;
    }

    private DwarfClassProperties lookupClassProperties(StructureTypeEntry entry) {
        DwarfClassProperties classProperties = (DwarfClassProperties)this.classPropertiesIndex.get((Object)entry);
        if (classProperties == null) {
            classProperties = this.addClassProperties(entry);
        }
        return classProperties;
    }

    private DwarfMethodProperties lookupMethodProperties(MethodEntry methodEntry) {
        DwarfMethodProperties methodProperties = (DwarfMethodProperties)this.methodPropertiesIndex.get((Object)methodEntry);
        if (methodProperties == null) {
            methodProperties = this.addMethodProperties(methodEntry);
        }
        return methodProperties;
    }

    public void setCUIndex(ClassEntry classEntry, int idx) {
        assert (idx >= 0);
        DwarfClassProperties classProperties = this.lookupClassProperties(classEntry);
        assert (classProperties.getTypeEntry() == classEntry);
        assert (classProperties.cuIndex == -1 || classProperties.cuIndex == idx);
        classProperties.cuIndex = idx;
    }

    public int getCUIndex(ClassEntry classEntry) {
        DwarfClassProperties classProperties = this.lookupClassProperties(classEntry);
        assert (classProperties.getTypeEntry() == classEntry);
        assert (classProperties.cuIndex >= 0);
        return classProperties.cuIndex;
    }

    public void setCodeRangesIndex(ClassEntry classEntry, int idx) {
        assert (idx >= 0);
        DwarfClassProperties classProperties = this.lookupClassProperties(classEntry);
        assert (classProperties.getTypeEntry() == classEntry);
        assert (classProperties.codeRangesIndex == -1 || classProperties.codeRangesIndex == idx);
        classProperties.codeRangesIndex = idx;
    }

    public int getCodeRangesIndex(ClassEntry classEntry) {
        DwarfClassProperties classProperties = this.lookupClassProperties(classEntry);
        assert (classProperties.getTypeEntry() == classEntry);
        assert (classProperties.codeRangesIndex >= 0);
        return classProperties.codeRangesIndex;
    }

    public void setLocationListIndex(ClassEntry classEntry, int idx) {
        assert (idx >= 0);
        DwarfClassProperties classProperties = this.lookupClassProperties(classEntry);
        assert (classProperties.getTypeEntry() == classEntry);
        assert (classProperties.locationListIndex == 0 || classProperties.locationListIndex == idx);
        classProperties.locationListIndex = idx;
    }

    public int getLocationListIndex(ClassEntry classEntry) {
        DwarfClassProperties classProperties = this.lookupClassProperties(classEntry);
        assert (classProperties.getTypeEntry() == classEntry);
        return classProperties.locationListIndex;
    }

    public void setLineIndex(ClassEntry classEntry, int idx) {
        assert (idx >= 0);
        DwarfClassProperties classProperties = this.lookupClassProperties(classEntry);
        assert (classProperties.getTypeEntry() == classEntry);
        assert (classProperties.lineIndex == -1 || classProperties.lineIndex == idx);
        classProperties.lineIndex = idx;
    }

    public int getLineIndex(ClassEntry classEntry) {
        DwarfClassProperties classProperties = this.lookupClassProperties(classEntry);
        assert (classProperties.getTypeEntry() == classEntry);
        assert (classProperties.lineIndex >= 0);
        return classProperties.lineIndex;
    }

    public void setLinePrologueSize(ClassEntry classEntry, int size) {
        assert (size >= 0);
        DwarfClassProperties classProperties = this.lookupClassProperties(classEntry);
        assert (classProperties.getTypeEntry() == classEntry);
        assert (classProperties.linePrologueSize == -1 || classProperties.linePrologueSize == size);
        classProperties.linePrologueSize = size;
    }

    public int getLinePrologueSize(ClassEntry classEntry) {
        DwarfClassProperties classProperties = this.lookupClassProperties(classEntry);
        assert (classProperties.getTypeEntry() == classEntry);
        assert (classProperties.linePrologueSize >= 0);
        return classProperties.linePrologueSize;
    }

    public void setFieldDeclarationIndex(StructureTypeEntry entry, String fieldName, int pos) {
        DwarfClassProperties classProperties = this.lookupClassProperties(entry);
        assert (classProperties.getTypeEntry() == entry);
        EconomicMap fieldDeclarationIndex = classProperties.fieldDeclarationIndex;
        if (fieldDeclarationIndex == null) {
            classProperties.fieldDeclarationIndex = fieldDeclarationIndex = EconomicMap.create();
        }
        if (fieldDeclarationIndex.get((Object)fieldName) != null) {
            assert ((Integer)fieldDeclarationIndex.get((Object)fieldName) == pos) : entry.getTypeName() + fieldName;
        } else {
            fieldDeclarationIndex.put((Object)fieldName, (Object)pos);
        }
    }

    public int getFieldDeclarationIndex(StructureTypeEntry entry, String fieldName) {
        DwarfClassProperties classProperties = this.lookupClassProperties(entry);
        assert (classProperties.getTypeEntry() == entry);
        EconomicMap<String, Integer> fieldDeclarationIndex = classProperties.fieldDeclarationIndex;
        assert (fieldDeclarationIndex != null) : fieldName;
        assert (fieldDeclarationIndex.get((Object)fieldName) != null) : entry.getTypeName() + fieldName;
        return (Integer)fieldDeclarationIndex.get((Object)fieldName);
    }

    public void setMethodDeclarationIndex(MethodEntry methodEntry, int pos) {
        DwarfMethodProperties methodProperties = this.lookupMethodProperties(methodEntry);
        methodProperties.setMethodDeclarationIndex(pos);
    }

    public int getMethodDeclarationIndex(MethodEntry methodEntry) {
        DwarfMethodProperties methodProperties = this.lookupMethodProperties(methodEntry);
        return methodProperties.getMethodDeclarationIndex();
    }

    public void setAbstractInlineMethodIndex(ClassEntry classEntry, MethodEntry methodEntry, int pos) {
        this.lookupMethodProperties(methodEntry).setAbstractInlineMethodIndex(classEntry, pos);
    }

    public int getAbstractInlineMethodIndex(ClassEntry classEntry, MethodEntry methodEntry) {
        return this.lookupMethodProperties(methodEntry).getAbstractInlineMethodIndex(classEntry);
    }

    private DwarfLocalProperties addRangeLocalProperties(Range range) {
        DwarfLocalProperties localProperties = new DwarfLocalProperties();
        this.rangeLocalPropertiesIndex.put((Object)range, (Object)localProperties);
        return localProperties;
    }

    public DwarfLocalProperties lookupLocalProperties(ClassEntry classEntry, MethodEntry methodEntry) {
        return this.lookupMethodProperties(methodEntry).getLocalProperties(classEntry);
    }

    public void setMethodLocalIndex(ClassEntry classEntry, MethodEntry methodEntry, DebugInfoProvider.DebugLocalInfo localInfo, int index) {
        DwarfLocalProperties localProperties = this.lookupLocalProperties(classEntry, methodEntry);
        localProperties.setIndex(localInfo, index);
    }

    public int getMethodLocalIndex(ClassEntry classEntry, MethodEntry methodEntry, DebugInfoProvider.DebugLocalInfo localInfo) {
        DwarfLocalProperties localProperties = this.lookupLocalProperties(classEntry, methodEntry);
        assert (localProperties != null) : "get of non-existent local index";
        int index = localProperties.getIndex(localInfo);
        assert (index >= 0) : "get of local index before it was set";
        return index;
    }

    public void setRangeLocalIndex(Range range, DebugInfoProvider.DebugLocalInfo localInfo, int index) {
        DwarfLocalProperties rangeProperties = (DwarfLocalProperties)this.rangeLocalPropertiesIndex.get((Object)range);
        if (rangeProperties == null) {
            rangeProperties = this.addRangeLocalProperties(range);
        }
        rangeProperties.setIndex(localInfo, index);
    }

    public int getRangeLocalIndex(Range range, DebugInfoProvider.DebugLocalInfo localinfo) {
        DwarfLocalProperties rangeProperties = (DwarfLocalProperties)this.rangeLocalPropertiesIndex.get((Object)range);
        assert (rangeProperties != null) : "get of non-existent local index";
        int index = rangeProperties.getIndex(localinfo);
        assert (index >= 0) : "get of local index before it was set";
        return index;
    }

    public abstract byte getHeapbaseRegister();

    public abstract boolean isAarch64();

    public abstract boolean isAMD64();

    public abstract DwarfSectionName textSectionName();

    public abstract DwarfSectionName lineSectionName();

    public abstract DwarfSectionName strSectionName();

    public abstract DwarfSectionName locSectionName();

    public abstract DwarfSectionName rangesSectionName();

    public abstract DwarfSectionName arangesSectionName();

    public abstract DwarfSectionName frameSectionName();

    public abstract DwarfSectionName abbrevSectionName();

    public abstract DwarfSectionName infoSectionName();

    public boolean layoutDependsOnVaddr() {
        return false;
    }

    public boolean isDebugSectionName(String name) {
        return name.startsWith(".debug");
    }

    public long relocatableLong(long l) {
        return 0L;
    }

    public int relocatableInt(int l) {
        return 0;
    }

    static class DwarfClassProperties {
        private final StructureTypeEntry typeEntry;
        private int cuIndex;
        private int codeRangesIndex;
        private int locationListIndex;
        private int lineIndex;
        private int linePrologueSize;
        private EconomicMap<String, Integer> fieldDeclarationIndex;

        public StructureTypeEntry getTypeEntry() {
            return this.typeEntry;
        }

        DwarfClassProperties(StructureTypeEntry typeEntry) {
            this.typeEntry = typeEntry;
            this.cuIndex = -1;
            this.codeRangesIndex = -1;
            this.locationListIndex = 0;
            this.lineIndex = -1;
            this.linePrologueSize = -1;
            this.fieldDeclarationIndex = null;
        }
    }

    static class DwarfMethodProperties {
        private int methodDeclarationIndex = -1;
        private EconomicMap<ClassEntry, DwarfLocalProperties> localPropertiesMap = null;
        private EconomicMap<ClassEntry, Integer> abstractInlineMethodIndex = null;

        DwarfMethodProperties() {
        }

        public int getMethodDeclarationIndex() {
            assert (this.methodDeclarationIndex >= 0) : "unset declaration index";
            return this.methodDeclarationIndex;
        }

        public void setMethodDeclarationIndex(int pos) {
            assert (this.methodDeclarationIndex == -1 || this.methodDeclarationIndex == pos) : "bad declaration index";
            this.methodDeclarationIndex = pos;
        }

        public DwarfLocalProperties getLocalProperties(ClassEntry classEntry) {
            DwarfLocalProperties localProperties;
            if (this.localPropertiesMap == null) {
                this.localPropertiesMap = EconomicMap.create();
            }
            if ((localProperties = (DwarfLocalProperties)this.localPropertiesMap.get((Object)classEntry)) == null) {
                localProperties = new DwarfLocalProperties();
                this.localPropertiesMap.put((Object)classEntry, (Object)localProperties);
            }
            return localProperties;
        }

        public void setAbstractInlineMethodIndex(ClassEntry classEntry, int pos) {
            if (this.abstractInlineMethodIndex == null) {
                this.abstractInlineMethodIndex = EconomicMap.create();
            }
            Integer val = (Integer)this.abstractInlineMethodIndex.put((Object)classEntry, (Object)pos);
            assert (val == null || val == pos);
        }

        public int getAbstractInlineMethodIndex(ClassEntry classEntry) {
            return (Integer)this.abstractInlineMethodIndex.get((Object)classEntry);
        }
    }

    static final class DwarfLocalProperties {
        private EconomicMap<DebugInfoProvider.DebugLocalInfo, Integer> locals = EconomicMap.create();

        private DwarfLocalProperties() {
        }

        int getIndex(DebugInfoProvider.DebugLocalInfo localInfo) {
            return (Integer)this.locals.get((Object)localInfo);
        }

        void setIndex(DebugInfoProvider.DebugLocalInfo localInfo, int index) {
            if (this.locals.get((Object)localInfo) != null) {
                assert ((Integer)this.locals.get((Object)localInfo) == index);
            } else {
                this.locals.put((Object)localInfo, (Object)index);
            }
        }
    }

    static enum AbbrevCode {
        NULL,
        CLASS_CONSTANT_UNIT,
        CLASS_UNIT_1,
        CLASS_UNIT_2,
        CLASS_UNIT_3,
        TYPE_UNIT,
        PRIMITIVE_TYPE,
        VOID_TYPE,
        OBJECT_HEADER,
        CLASS_CONSTANT,
        NAMESPACE,
        CLASS_LAYOUT_TU,
        CLASS_LAYOUT_CU,
        CLASS_LAYOUT_ARRAY,
        TYPE_POINTER_SIG,
        TYPE_POINTER,
        FOREIGN_TYPEDEF,
        FOREIGN_STRUCT,
        METHOD_LOCATION,
        STATIC_FIELD_LOCATION,
        ARRAY_LAYOUT,
        INTERFACE_LAYOUT,
        COMPRESSED_LAYOUT,
        METHOD_DECLARATION,
        METHOD_DECLARATION_STATIC,
        METHOD_DECLARATION_SKELETON,
        FIELD_DECLARATION_1,
        FIELD_DECLARATION_2,
        FIELD_DECLARATION_3,
        FIELD_DECLARATION_4,
        STRUCT_FIELD_SIG,
        STRUCT_FIELD,
        ARRAY_DATA_TYPE_1,
        ARRAY_DATA_TYPE_2,
        ARRAY_SUBRANGE,
        SUPER_REFERENCE,
        INTERFACE_IMPLEMENTOR,
        INLINED_SUBROUTINE,
        INLINED_SUBROUTINE_WITH_CHILDREN,
        ABSTRACT_INLINE_METHOD,
        METHOD_PARAMETER_DECLARATION_1,
        METHOD_PARAMETER_DECLARATION_2,
        METHOD_PARAMETER_DECLARATION_3,
        METHOD_PARAMETER_DECLARATION_4,
        METHOD_PARAMETER_DECLARATION_5,
        METHOD_LOCAL_DECLARATION_1,
        METHOD_LOCAL_DECLARATION_2,
        METHOD_PARAMETER_LOCATION_1,
        METHOD_PARAMETER_LOCATION_2,
        METHOD_LOCAL_LOCATION_1,
        METHOD_LOCAL_LOCATION_2;

    }
}

