/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.objectfile.pecoff.cv;

import com.oracle.objectfile.debugentry.CompiledMethodEntry;
import com.oracle.objectfile.debugentry.FileEntry;
import com.oracle.objectfile.debugentry.range.PrimaryRange;
import com.oracle.objectfile.debugentry.range.Range;
import com.oracle.objectfile.debugentry.range.SubRange;
import com.oracle.objectfile.pecoff.cv.CVDebugInfo;
import com.oracle.objectfile.pecoff.cv.CVLineRecord;
import java.util.Iterator;

public class CVLineRecordBuilder {
    private final CVDebugInfo cvDebugInfo;
    private CVLineRecord lineRecord;
    private CompiledMethodEntry compiledEntry;

    CVLineRecordBuilder(CVDebugInfo cvDebugInfo) {
        this.cvDebugInfo = cvDebugInfo;
    }

    public void debug(String format, Object ... args) {
        this.cvDebugInfo.getCVSymbolSection().verboseLog(format, args);
    }

    CVLineRecord build(CompiledMethodEntry entry) {
        this.compiledEntry = entry;
        PrimaryRange primaryRange = this.compiledEntry.getPrimary();
        this.debug("DEBUG_S_LINES linerecord for 0x%05x file: %s:%d", primaryRange.getLo(), primaryRange.getFileName(), primaryRange.getLine());
        this.lineRecord = new CVLineRecord(this.cvDebugInfo, primaryRange.getSymbolName());
        this.debug("CVLineRecord.computeContents: processing primary range %s", primaryRange);
        this.processRange(primaryRange);
        Iterator<SubRange> iterator = this.compiledEntry.leafRangeIterator();
        while (iterator.hasNext()) {
            SubRange subRange = iterator.next();
            this.debug("CVLineRecord.computeContents: processing range %s", subRange);
            this.processRange(subRange);
        }
        return this.lineRecord;
    }

    private void processRange(Range range) {
        FileEntry file = range.getFileEntry();
        if (file == null) {
            this.debug("  processRange: range has no file: %s", range);
            return;
        }
        if (range.getLine() < 0) {
            this.debug("  processRange: ignoring: bad line number: %d", range.getLine());
            return;
        }
        int fileId = this.cvDebugInfo.getCVSymbolSection().getFileTableRecord().addFile(file);
        if (this.lineRecord.isEmpty() || this.lineRecord.getCurrentFileId() != fileId) {
            this.debug("  processRange: addNewFile: %s", file);
            this.lineRecord.addNewFile(fileId);
        }
        long lineLoAddr = range.getLo() - this.compiledEntry.getPrimary().getLo();
        int line = Math.max(range.getLine(), 1);
        this.debug("  processRange:   addNewLine: 0x%05x-0x%05x %s", lineLoAddr, range.getHi() - this.compiledEntry.getPrimary().getLo(), line);
        this.lineRecord.addNewLine(lineLoAddr, line);
    }
}

