/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.shaded.org.capnproto;

import com.oracle.svm.shaded.org.capnproto.BufferedInputStream;
import com.oracle.svm.shaded.org.capnproto.DecodeException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;

public final class BufferedInputStreamWrapper
implements BufferedInputStream {
    private final ReadableByteChannel inner;
    private final ByteBuffer buf;

    public BufferedInputStreamWrapper(ReadableByteChannel chan) {
        this.inner = chan;
        this.buf = ByteBuffer.allocate(8192);
        this.buf.limit(0);
    }

    @Override
    public final int read(ByteBuffer dst) throws IOException {
        int numBytes = dst.remaining();
        if (numBytes < this.buf.remaining()) {
            ByteBuffer slice = this.buf.slice();
            slice.limit(numBytes);
            dst.put(slice);
            this.buf.position(this.buf.position() + numBytes);
            return numBytes;
        }
        int fromFirstBuffer = this.buf.remaining();
        ByteBuffer slice = this.buf.slice();
        slice.limit(fromFirstBuffer);
        dst.put(slice);
        if ((numBytes -= fromFirstBuffer) <= this.buf.capacity()) {
            this.buf.clear();
            int n = BufferedInputStreamWrapper.readAtLeast(this.inner, this.buf, numBytes);
            this.buf.rewind();
            ByteBuffer slice2 = this.buf.slice();
            slice2.limit(numBytes);
            dst.put(slice2);
            this.buf.limit(n);
            this.buf.position(numBytes);
            return fromFirstBuffer + numBytes;
        }
        this.buf.clear();
        this.buf.limit(0);
        return fromFirstBuffer + BufferedInputStreamWrapper.readAtLeast(this.inner, dst, numBytes);
    }

    @Override
    public final ByteBuffer getReadBuffer() throws IOException {
        if (this.buf.remaining() == 0) {
            this.buf.clear();
            int n = BufferedInputStreamWrapper.readAtLeast(this.inner, this.buf, 1);
            this.buf.rewind();
            this.buf.limit(n);
        }
        return this.buf;
    }

    @Override
    public final void close() throws IOException {
        this.inner.close();
    }

    @Override
    public final boolean isOpen() {
        return this.inner.isOpen();
    }

    public static int readAtLeast(ReadableByteChannel reader, ByteBuffer buf, int minBytes) throws IOException {
        int numRead;
        int res;
        for (numRead = 0; numRead < minBytes; numRead += res) {
            res = reader.read(buf);
            if (res >= 0) continue;
            throw new DecodeException("premature EOF");
        }
        return numRead;
    }
}

