/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.jdwp.server;

import com.oracle.svm.core.util.VMError;
import com.oracle.svm.interpreter.metadata.InterpreterUniverseImpl;
import com.oracle.svm.interpreter.metadata.serialization.SerializationContext;
import com.oracle.svm.interpreter.metadata.serialization.Serializers;
import com.oracle.svm.jdwp.bridge.DebugOptions;
import com.oracle.svm.jdwp.bridge.HSToNativeJDWPBridge;
import com.oracle.svm.jdwp.bridge.JDWPEventHandlerBridge;
import com.oracle.svm.jdwp.bridge.JDWPJNIConfig;
import com.oracle.svm.jdwp.bridge.nativebridge.JNIConfig;
import com.oracle.svm.jdwp.bridge.nativebridge.NativeIsolate;
import com.oracle.svm.jdwp.server.ClassUtils;
import com.oracle.svm.jdwp.server.JDWPHandler;
import com.oracle.svm.jdwp.server.impl.ServerJDWP;
import java.io.IOException;
import java.nio.file.Path;
import org.graalvm.nativeimage.ImageInfo;
import org.graalvm.nativeimage.VMRuntime;

public class JDWPServer
implements JDWPEventHandlerBridge {
    public static final String DEBUGGER_HELP_MESSAGE = "                  Native Image JDWP Debugger\n                  --------------------------\n\n  (See the \"VM Invocation Options\" section of the JPDA\n   \"Connection and Invocation Details\" document for more information.)\n\njdwp usage: foobar -XX:JDWPOptions=[help]|[<option>=<value>, ...]\n\nOption Name and Value            Description                       Default\n---------------------            -----------                       -------\nsuspend=y|n                      wait on startup?                  y\ntransport=<name>                 transport spec                    none\naddress=<listen/attach address>  transport spec                    \"\"\nserver=y|n                       listen for debugger?              n\ntimeout=<timeout value>          for listen/attach in milliseconds n\n\nExamples\n--------\n  - Using sockets connect to a debugger at a specific address:\n    foobar -XX:JDWPOptions=transport=dt_socket,address=localhost:8000 ...\n  - Using sockets listen for a debugger to attach:\n    foobar -XX:JDWPOptions=transport=dt_socket,server=y,suspend=y ...\n\nNotes\n-----\n  - A timeout value of 0 (the default) is no timeout.\n\n".replaceAll("\n", System.lineSeparator());
    private JDWPHandler jdwpHandler = null;
    private static final SerializationContext.Builder DEFAULT_UNIVERSE_BUILDER = Serializers.newBuilderForInterpreterMetadata();

    public static JDWPEventHandlerBridge createInstance() {
        if (ImageInfo.isSharedLibrary() && ImageInfo.inImageRuntimeCode()) {
            VMRuntime.initialize();
        }
        return new JDWPServer();
    }

    public void spawnServer(String jdwpOptions, String additionalOptions, long isolate, long initialThreadId, long jdwpBridgeHandle, String metadataHashString, String metadataPath, boolean tracing) {
        DebugOptions.Options options;
        try {
            options = DebugOptions.parse((String)jdwpOptions, (String)additionalOptions, (boolean)true, (boolean)tracing);
        }
        catch (IllegalArgumentException e) {
            System.err.println("ERROR: JDWP option syntax error: " + jdwpOptions);
            System.exit(1);
            return;
        }
        if (options.help()) {
            System.out.println(DEBUGGER_HELP_MESSAGE);
            System.exit(0);
            return;
        }
        if ("jvm".equals(options.mode())) {
            VMError.guarantee((!ImageInfo.inImageRuntimeCode() ? 1 : 0) != 0, (String)"JDWP server is not running on HotSpot");
            System.loadLibrary("DEFAULT_NAMESPACE");
        } else {
            VMError.guarantee((boolean)ImageInfo.inImageRuntimeCode(), (String)"JDWP server is not running on SubstrateVM");
        }
        try {
            ClassUtils.UNIVERSE = InterpreterUniverseImpl.loadFrom((SerializationContext.Builder)DEFAULT_UNIVERSE_BUILDER, (boolean)true, (String)metadataHashString, (Path)Path.of(metadataPath, new String[0]));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.jdwpHandler = new JDWPHandler(initialThreadId);
        NativeIsolate nativeIsolate = NativeIsolate.forIsolateId((long)isolate, (JNIConfig)JDWPJNIConfig.getInstance());
        ServerJDWP.BRIDGE = HSToNativeJDWPBridge.createHSToNative((NativeIsolate)nativeIsolate, (long)jdwpBridgeHandle);
        ServerJDWP.initLogging(options.tracing());
        this.jdwpHandler.doConnect(options);
    }

    public void onEventAt(long threadId, long classId, byte typeTag, long methodId, int bci, byte resultTag, long resultPrimitiveOrId, int eventKindFlags) {
        this.jdwpHandler.getController().getEventListener().onEventAt(threadId, classId, typeTag, methodId, bci, resultTag, resultPrimitiveOrId, eventKindFlags);
    }

    public void onThreadStart(long threadId) {
        this.jdwpHandler.getController().getEventListener().onThreadStart(threadId);
    }

    public void onThreadDeath(long threadId) {
        this.jdwpHandler.getController().getEventListener().onThreadDeath(threadId);
    }

    public void onVMDeath() {
        this.jdwpHandler.getController().getEventListener().onVMDeath();
    }
}

