/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.jdwp.server;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.jdwp.bridge.jniutils.JNIEntryPoint;
import com.oracle.svm.jdwp.server.JDWPServer;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import org.graalvm.nativeimage.AnnotationAccess;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.hosted.RuntimeJNIAccess;

final class JDWPServerJNIEntryPointsFeature
implements InternalFeature {
    JDWPServerJNIEntryPointsFeature() {
    }

    public String getDescription() {
        return "Registers JNI entry points for the JDWP server";
    }

    public boolean isInConfiguration(Feature.IsInConfigurationAccess access) {
        return (Boolean)SubstrateOptions.JNI.getValue();
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        JDWPServerJNIEntryPointsFeature.registerNativeMethods(access);
    }

    private static void registerNativeMethods(Feature.BeforeAnalysisAccess access) {
        try {
            ArrayList<Method> methodsToRegister = new ArrayList<Method>();
            methodsToRegister.addAll(JDWPServerJNIEntryPointsFeature.findAnnotatedMethodsInClass("com.oracle.svm.jdwp.bridge.jniutils.JNIExceptionWrapperEntryPoints", JNIEntryPoint.class));
            methodsToRegister.addAll(JDWPServerJNIEntryPointsFeature.findAnnotatedMethodsInClass("com.oracle.svm.jdwp.bridge.nativebridge.ForeignExceptionEndPoints", JNIEntryPoint.class));
            methodsToRegister.add(ClassLoader.class.getDeclaredMethod("getPlatformClassLoader", new Class[0]));
            methodsToRegister.add(ClassLoader.class.getDeclaredMethod("getSystemClassLoader", new Class[0]));
            methodsToRegister.add(ClassLoader.class.getDeclaredMethod("loadClass", String.class));
            methodsToRegister.addAll(JDWPServerJNIEntryPointsFeature.findAnnotatedMethodsInClass("com.oracle.svm.jdwp.bridge.NativeToHSJDWPEventHandlerBridgeGen$EndPoint", JNIEntryPoint.class));
            methodsToRegister.add(JDWPServer.class.getDeclaredMethod("createInstance", new Class[0]));
            methodsToRegister.add(JDWPServer.class.getDeclaredMethod("spawnServer", String.class, String.class, Long.TYPE, Long.TYPE, Long.TYPE, String.class, String.class, Boolean.TYPE));
            methodsToRegister.stream().map(Method::getDeclaringClass).distinct().forEach(xva$0 -> RuntimeJNIAccess.register((Class[])new Class[]{xva$0}));
            methodsToRegister.forEach(xva$0 -> RuntimeJNIAccess.register((Executable[])new Executable[]{xva$0}));
        }
        catch (ReflectiveOperationException re) {
            throw UserError.abort((Throwable)re, (String)"Failed to register JNI entry points.", (Object[])new Object[0]);
        }
    }

    private static Collection<Method> findAnnotatedMethodsInClass(String className, Class<? extends Annotation> annotation) throws ReflectiveOperationException {
        ArrayList<Method> res = new ArrayList<Method>();
        Class<?> clazz = Class.forName(className);
        for (Method method : clazz.getDeclaredMethods()) {
            if (AnnotationAccess.getAnnotation((AnnotatedElement)method, annotation) == null) continue;
            res.add(method);
        }
        return res;
    }
}

