/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.jdwp.server.impl;

import com.oracle.svm.interpreter.metadata.MetadataUtil;
import com.oracle.svm.jdwp.bridge.CheckedReader;
import com.oracle.svm.jdwp.bridge.ErrorCode;
import com.oracle.svm.jdwp.bridge.InvokeOptions;
import com.oracle.svm.jdwp.bridge.JDWP;
import com.oracle.svm.jdwp.bridge.JDWPBridge;
import com.oracle.svm.jdwp.bridge.JDWPException;
import com.oracle.svm.jdwp.bridge.Logger;
import com.oracle.svm.jdwp.bridge.Packet;
import com.oracle.svm.jdwp.bridge.SymbolicRefs;
import com.oracle.svm.jdwp.bridge.TypeTag;
import com.oracle.svm.jdwp.bridge.WritablePacket;
import com.oracle.svm.jdwp.server.ClassUtils;
import com.oracle.svm.jdwp.server.MethodUtils;
import com.oracle.svm.jdwp.server.impl.CallFrame;
import com.oracle.svm.jdwp.server.impl.DebuggerController;
import com.oracle.svm.jdwp.server.impl.ServerSymbolicRefs;
import com.oracle.svm.jdwp.server.impl.SuspendedInfo;
import com.oracle.svm.jdwp.server.impl.ThreadRef;
import java.io.File;
import java.util.Collection;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.LineNumberTable;
import jdk.vm.ci.meta.Local;
import jdk.vm.ci.meta.LocalVariableTable;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;

public final class ServerJDWP
implements JDWP {
    public static final boolean CAN_WATCH_FIELD_MODIFICATION = false;
    public static final boolean CAN_WATCH_FIELD_ACCESS = false;
    public static final boolean CAN_GET_BYTECODES = false;
    public static final boolean CAN_GET_SYNTHETIC_ATTRIBUTE = false;
    public static final boolean CAN_GET_OWNED_MONITOR_INFO = false;
    public static final boolean CAN_GET_CURRENT_CONTENDED_MONITOR = false;
    public static final boolean CAN_GET_MONITOR_INFO = false;
    public static final boolean CAN_REDEFINE_CLASSES = false;
    public static final boolean CAN_ADD_METHOD = false;
    public static final boolean CAN_UNRESTRICTEDLY_REDEFINE_CLASSES = false;
    public static final boolean CAN_POP_FRAMES = false;
    public static final boolean CAN_USE_INSTANCE_FILTERS = true;
    public static final boolean CAN_GET_SOURCE_DEBUG_EXTENSION = false;
    public static final boolean CAN_REQUEST_VMDEATH_EVENT = false;
    public static final boolean CAN_SET_DEFAULT_STRATUM = false;
    public static final boolean CAN_GET_INSTANCE_INFO = false;
    public static final boolean CAN_REQUEST_MONITOR_EVENTS = false;
    public static final boolean CAN_GET_MONITOR_FRAME_INFO = false;
    public static final boolean CAN_USE_SOURCE_NAME_FILTERS = false;
    public static final boolean CAN_GET_CONSTANT_POOL = false;
    public static final boolean CAN_FORCE_EARLY_RETURN = false;
    public static JDWPBridge BRIDGE = null;
    public static final SymbolicRefs SYMBOLIC_REFS = new ServerSymbolicRefs();
    static final CheckedReader CHECKED_READER = new CheckedReader(SYMBOLIC_REFS);
    private final DebuggerController controller;
    public static Logger LOGGER = new Logger(false, "[JDWPServer]", System.err);
    private static final int ACC_SYNTHETIC = 4096;
    private static final int JDWP_SYNTHETIC = -268435456;
    static final String VERSION_NAME = "Java Debug Wire Protocol (Substrate VM)";

    public ServerJDWP(DebuggerController controller) {
        this.controller = controller;
    }

    public static void initLogging(boolean enabled) {
        LOGGER = new Logger(enabled, "[JDWPServer]", System.err);
    }

    private static int extractMajorVersion(String javaVersion) {
        int index;
        for (index = 0; index < javaVersion.length() && Character.isDigit(javaVersion.charAt(index)); ++index) {
        }
        return Integer.parseInt(javaVersion.substring(0, index));
    }

    public Packet VirtualMachine_Version(Packet packet) throws JDWPException {
        WritablePacket reply = WritablePacket.newReplyTo((Packet)packet);
        Packet.Writer data = reply.dataWriter();
        String vmName = BRIDGE.getSystemProperty("java.vm.name");
        String vmVersion = BRIDGE.getSystemProperty("java.vm.version");
        String vmInfo = BRIDGE.getSystemProperty("java.vm.info");
        String javaVersion = BRIDGE.getSystemProperty("java.version");
        int majorVersion = ServerJDWP.extractMajorVersion(javaVersion);
        int minorVersion = 0;
        String verboseVersionMessage = MetadataUtil.fmt((String)"%s version %s.%s%nJVM Debug Interface version %s.%s%nJVM version %s (%s, %s)", (Object[])new Object[]{VERSION_NAME, majorVersion, minorVersion, majorVersion, minorVersion, vmVersion, vmName, vmInfo});
        data.writeString(verboseVersionMessage);
        data.writeInt(majorVersion);
        data.writeInt(minorVersion);
        data.writeString(vmVersion);
        data.writeString(vmName);
        return reply;
    }

    public Packet VirtualMachine_IDSizes(Packet packet) throws JDWPException {
        WritablePacket reply = WritablePacket.newReplyTo((Packet)packet);
        Packet.Writer data = reply.dataWriter();
        data.writeInt(8);
        data.writeInt(8);
        data.writeInt(8);
        data.writeInt(8);
        data.writeInt(8);
        return reply;
    }

    public Packet VirtualMachine_AllClasses(Packet packet) throws JDWPException {
        return BRIDGE.dispatch(packet);
    }

    public Packet VirtualMachine_AllClassesWithGeneric(Packet packet) throws JDWPException {
        return BRIDGE.dispatch(packet);
    }

    static boolean isSynthetic(int mod) {
        return (mod & 0x1000) != 0;
    }

    private static int checkSyntheticFlag(int modBits) {
        int mod = modBits;
        if (ServerJDWP.isSynthetic(modBits)) {
            mod &= 0xFFFFEFFF;
            mod |= 0xF0000000;
        }
        return mod;
    }

    private static Packet methodsHelper(Packet packet, boolean includeGenericSignature) throws JDWPException {
        Packet.Reader reader = packet.newDataReader();
        WritablePacket reply = WritablePacket.newReplyTo((Packet)packet);
        Packet.Writer data = reply.dataWriter();
        ResolvedJavaType type = CHECKED_READER.readTypeRef(reader);
        Collection declaredMethods = ClassUtils.UNIVERSE.getAllDeclaredMethods(type);
        int numDeclaredMethods = declaredMethods.size();
        data.writeInt(numDeclaredMethods);
        for (ResolvedJavaMethod method : declaredMethods) {
            data.writeLong(SYMBOLIC_REFS.toMethodRef(method));
            data.writeString(method.getName());
            data.writeString(MethodUtils.getSignatureAsString(method));
            if (includeGenericSignature) {
                data.writeString(MethodUtils.getGenericSignatureAsString(method));
            }
            int modBits = ServerJDWP.checkSyntheticFlag(method.getModifiers());
            data.writeInt(modBits);
        }
        return reply;
    }

    public Packet ReferenceType_MethodsWithGeneric(Packet packet) throws JDWPException {
        return ServerJDWP.methodsHelper(packet, true);
    }

    public Packet ReferenceType_Methods(Packet packet) throws JDWPException {
        return ServerJDWP.methodsHelper(packet, false);
    }

    public Packet VirtualMachine_AllThreads(Packet packet) throws JDWPException {
        return BRIDGE.dispatch(packet);
    }

    public Packet EventRequest_Set(Packet packet) throws JDWPException {
        return this.controller.getRequestedJDWPEvents().registerRequest(packet);
    }

    public Packet EventRequest_Clear(Packet packet) throws JDWPException {
        return this.controller.getRequestedJDWPEvents().clearRequest(packet);
    }

    public Packet EventRequest_ClearAllBreakpoints(Packet packet) throws JDWPException {
        return this.controller.getRequestedJDWPEvents().clearAllBreakpoints(packet);
    }

    public Packet VirtualMachine_ClassPaths(Packet packet) throws JDWPException {
        WritablePacket reply = WritablePacket.newReplyTo((Packet)packet);
        Packet.Writer data = reply.dataWriter();
        String baseDirectory = BRIDGE.currentWorkingDirectory();
        data.writeString(baseDirectory);
        String classpath = BRIDGE.getSystemProperty("java.class.path");
        String[] classpathParts = classpath != null ? classpath.split(File.pathSeparator) : new String[]{};
        data.writeInt(classpathParts.length);
        for (String part : classpathParts) {
            data.writeString(part);
        }
        String bootClasspath = BRIDGE.getSystemProperty("sun.boot.class.path");
        String[] bootClasspathParts = bootClasspath != null ? bootClasspath.split(File.pathSeparator) : new String[]{};
        data.writeInt(bootClasspathParts.length);
        for (String part : bootClasspathParts) {
            data.writeString(part);
        }
        return reply;
    }

    public Packet VirtualMachine_Capabilities(Packet packet) throws JDWPException {
        WritablePacket reply = WritablePacket.newReplyTo((Packet)packet);
        Packet.Writer data = reply.dataWriter();
        data.writeBoolean(false);
        data.writeBoolean(false);
        data.writeBoolean(false);
        data.writeBoolean(false);
        data.writeBoolean(false);
        data.writeBoolean(false);
        data.writeBoolean(false);
        return reply;
    }

    public Packet VirtualMachine_CapabilitiesNew(Packet packet) throws JDWPException {
        WritablePacket reply = WritablePacket.newReplyTo((Packet)packet);
        Packet.Writer data = reply.dataWriter();
        data.writeBoolean(false);
        data.writeBoolean(false);
        data.writeBoolean(false);
        data.writeBoolean(false);
        data.writeBoolean(false);
        data.writeBoolean(false);
        data.writeBoolean(false);
        data.writeBoolean(false);
        data.writeBoolean(false);
        data.writeBoolean(false);
        data.writeBoolean(false);
        data.writeBoolean(true);
        data.writeBoolean(false);
        data.writeBoolean(false);
        data.writeBoolean(false);
        data.writeBoolean(false);
        data.writeBoolean(false);
        data.writeBoolean(false);
        data.writeBoolean(false);
        data.writeBoolean(false);
        data.writeBoolean(false);
        data.writeBoolean(false);
        data.writeBoolean(false);
        data.writeBoolean(false);
        data.writeBoolean(false);
        data.writeBoolean(false);
        data.writeBoolean(false);
        data.writeBoolean(false);
        data.writeBoolean(false);
        data.writeBoolean(false);
        data.writeBoolean(false);
        data.writeBoolean(false);
        return reply;
    }

    public Packet Method_LineTable(Packet packet) throws JDWPException {
        WritablePacket reply = WritablePacket.newReplyTo((Packet)packet);
        Packet.Reader input = packet.newDataReader();
        Packet.Writer data = reply.dataWriter();
        CHECKED_READER.readTypeRef(input);
        ResolvedJavaMethod method = CHECKED_READER.readMethodRef(input);
        LineNumberTable table = method.getLineNumberTable();
        int lastBCI = method.getCodeSize();
        long start = lastBCI > 0 ? 0L : -1L;
        long end = lastBCI > 0 ? (long)lastBCI : -1L;
        data.writeLong(start);
        data.writeLong(end);
        if (table == null) {
            data.writeInt(0);
        } else {
            int[] lines = table.getLineNumbers();
            int[] bcis = table.getBcis();
            assert (lines.length == bcis.length);
            data.writeInt(lines.length);
            for (int i = 0; i < lines.length; ++i) {
                int bci = bcis[i];
                int line = lines[i];
                data.writeLong((long)bci);
                data.writeInt(line);
            }
        }
        return reply;
    }

    private static Packet variableTableHelper(Packet packet, boolean includeGenericSignatures) throws JDWPException {
        Packet.Reader reader = packet.newDataReader();
        ResolvedJavaType declaringType = CHECKED_READER.readTypeRef(reader);
        ResolvedJavaMethod method = CHECKED_READER.readMethodRef(reader);
        assert (declaringType.equals((Object)method.getDeclaringClass()));
        LocalVariableTable table = method.getLocalVariableTable();
        if (table == null) {
            throw JDWPException.raise((ErrorCode)ErrorCode.ABSENT_INFORMATION);
        }
        int slotsForArguments = 0;
        if (!method.isStatic()) {
            slotsForArguments += JavaKind.Object.getSlotCount();
        }
        for (JavaType parameterType : method.toParameterTypes()) {
            int slotCount = parameterType.getJavaKind().getSlotCount();
            slotsForArguments += slotCount;
        }
        WritablePacket reply = WritablePacket.newReplyTo((Packet)packet);
        Packet.Writer writer = reply.dataWriter();
        writer.writeInt(slotsForArguments);
        Local[] locals = table.getLocals();
        writer.writeInt(locals.length);
        for (Local local : locals) {
            long codeIndex = local.getStartBCI();
            writer.writeLong(codeIndex);
            writer.writeString(local.getName());
            String signature = local.getType().getName();
            writer.writeString(signature);
            if (includeGenericSignatures) {
                String genericSignature = "";
                writer.writeString(genericSignature);
            }
            int length = local.getEndBCI() - local.getStartBCI() + 1;
            writer.writeInt(length);
            writer.writeInt(local.getSlot());
        }
        return reply;
    }

    public Packet Method_VariableTable(Packet packet) throws JDWPException {
        return ServerJDWP.variableTableHelper(packet, false);
    }

    public Packet Method_VariableTableWithGeneric(Packet packet) throws JDWPException {
        return ServerJDWP.variableTableHelper(packet, true);
    }

    public Packet Method_IsObsolete(Packet packet) throws JDWPException {
        Packet.Reader reader = packet.newDataReader();
        ResolvedJavaType declaringType = CHECKED_READER.readTypeRef(reader);
        ResolvedJavaMethod method = CHECKED_READER.readMethodRef(reader);
        assert (declaringType.equals((Object)method.getDeclaringClass()));
        WritablePacket reply = WritablePacket.newReplyTo((Packet)packet);
        Packet.Writer writer = reply.dataWriter();
        writer.writeBoolean(false);
        return reply;
    }

    public Packet Method_Bytecodes(Packet packet) throws JDWPException {
        throw JDWPException.raise((ErrorCode)ErrorCode.NOT_IMPLEMENTED);
    }

    public Packet VirtualMachine_Resume(Packet packet) throws JDWPException {
        this.controller.getContext().getThreadsCollector().resumeAll();
        return WritablePacket.newReplyTo((Packet)packet);
    }

    public Packet VirtualMachine_Suspend(Packet packet) throws JDWPException {
        this.controller.getContext().getThreadsCollector().suspendAll();
        return WritablePacket.newReplyTo((Packet)packet);
    }

    public Packet VirtualMachine_Dispose(Packet packet) throws JDWPException {
        this.controller.disposeDebugger((Packet)WritablePacket.newReplyTo((Packet)packet));
        return BRIDGE.dispatch(packet);
    }

    public Packet VirtualMachine_Exit(Packet packet) throws JDWPException {
        Packet.Reader input = packet.newDataReader();
        int exitCode = input.readInt();
        this.controller.disposeConnection((Packet)WritablePacket.newReplyTo((Packet)packet));
        System.exit(exitCode);
        return null;
    }

    public Packet ThreadReference_Name(Packet packet) throws JDWPException {
        return BRIDGE.dispatch(packet);
    }

    public Packet ThreadReference_Suspend(Packet packet) throws JDWPException {
        Packet.Reader input = packet.newDataReader();
        long threadId = input.readLong();
        if (threadId == 0L) {
            throw JDWPException.raise((ErrorCode)ErrorCode.INVALID_THREAD);
        }
        ThreadRef threadRef = this.controller.getContext().getThreadRef(threadId);
        threadRef.suspend();
        return WritablePacket.newReplyTo((Packet)packet);
    }

    public Packet ThreadReference_Resume(Packet packet) throws JDWPException {
        Packet.Reader input = packet.newDataReader();
        long threadId = input.readLong();
        if (threadId == 0L) {
            throw JDWPException.raise((ErrorCode)ErrorCode.INVALID_THREAD);
        }
        ThreadRef threadRef = this.controller.getContext().getThreadRefIfExists(threadId);
        if (threadRef != null) {
            threadRef.resume(false);
        } else {
            BRIDGE.getThreadStatus(threadId);
        }
        return WritablePacket.newReplyTo((Packet)packet);
    }

    public Packet ThreadReference_Status(Packet packet) throws JDWPException {
        Packet.Reader input = packet.newDataReader();
        long threadId = input.readLong();
        int status = BRIDGE.getThreadStatus(threadId);
        ThreadRef threadRef = this.controller.getContext().getThreadRefIfExists(threadId);
        int suspendStatus = threadRef != null ? (threadRef.getSuspendCount() > 0 ? 1 : 0) : 0;
        WritablePacket reply = WritablePacket.newReplyTo((Packet)packet);
        Packet.Writer data = reply.dataWriter();
        data.writeInt(status);
        data.writeInt(suspendStatus);
        return reply;
    }

    public Packet ThreadReference_Frames(Packet packet) throws JDWPException {
        CallFrame[] frames;
        Packet.Reader input = packet.newDataReader();
        long threadId = input.readLong();
        int startFrame = input.readInt();
        int length = input.readInt();
        if (threadId == 0L) {
            throw JDWPException.raise((ErrorCode)ErrorCode.INVALID_THREAD);
        }
        ThreadRef threadRef = this.controller.getContext().getThreadRefIfExists(threadId);
        if (threadRef == null) {
            BRIDGE.getThreadStatus(threadId);
            length = 0;
            frames = null;
        } else {
            SuspendedInfo suspendedInfo = threadRef.getSuspendedInfo();
            if (suspendedInfo == null) {
                throw JDWPException.raise((ErrorCode)ErrorCode.INVALID_THREAD);
            }
            frames = suspendedInfo.getStackFrames();
            if (length == -1 || length > frames.length) {
                length = frames.length;
            }
        }
        WritablePacket reply = WritablePacket.newReplyTo((Packet)packet);
        Packet.Writer data = reply.dataWriter();
        data.writeInt(length);
        for (int i = startFrame; i < startFrame + length; ++i) {
            CallFrame frame = frames[i];
            data.writeLong(frame.getFrameId());
            data.writeByte((int)frame.getTypeTag());
            data.writeLong(frame.getClassId());
            data.writeLong(frame.getMethodId());
            data.writeLong(frame.getCodeIndex());
        }
        return reply;
    }

    public Packet ThreadReference_FrameCount(Packet packet) throws JDWPException {
        int length;
        Packet.Reader input = packet.newDataReader();
        long threadId = input.readLong();
        if (threadId == 0L) {
            throw JDWPException.raise((ErrorCode)ErrorCode.INVALID_THREAD);
        }
        ThreadRef threadRef = this.controller.getContext().getThreadRefIfExists(threadId);
        if (threadRef == null) {
            BRIDGE.getThreadStatus(threadId);
            length = 0;
        } else {
            SuspendedInfo suspendedInfo = threadRef.getSuspendedInfo();
            if (suspendedInfo == null) {
                throw JDWPException.raise((ErrorCode)ErrorCode.INVALID_THREAD);
            }
            CallFrame[] frames = suspendedInfo.getStackFrames();
            length = frames.length;
        }
        WritablePacket reply = WritablePacket.newReplyTo((Packet)packet);
        Packet.Writer data = reply.dataWriter();
        data.writeInt(length);
        return reply;
    }

    public Packet ThreadReference_SuspendCount(Packet packet) throws JDWPException {
        int suspendCount;
        Packet.Reader input = packet.newDataReader();
        long threadId = input.readLong();
        ThreadRef thread = this.controller.getContext().getThreadRefIfExists(threadId);
        if (thread != null) {
            suspendCount = thread.getSuspendCount();
        } else {
            BRIDGE.getThreadStatus(threadId);
            suspendCount = 0;
        }
        WritablePacket reply = WritablePacket.newReplyTo((Packet)packet);
        Packet.Writer data = reply.dataWriter();
        data.writeInt(suspendCount);
        return reply;
    }

    public Packet ThreadReference_ThreadGroup(Packet packet) throws JDWPException {
        return BRIDGE.dispatch(packet);
    }

    public Packet VirtualMachine_TopLevelThreadGroups(Packet packet) throws JDWPException {
        return BRIDGE.dispatch(packet);
    }

    public Packet ThreadGroupReference_Name(Packet packet) throws JDWPException {
        return BRIDGE.dispatch(packet);
    }

    public Packet ThreadGroupReference_Children(Packet packet) throws JDWPException {
        return BRIDGE.dispatch(packet);
    }

    public Packet ThreadGroupReference_Parent(Packet packet) throws JDWPException {
        return BRIDGE.dispatch(packet);
    }

    public Packet ObjectReference_ReferenceType(Packet packet) throws JDWPException {
        return BRIDGE.dispatch(packet);
    }

    public Packet VirtualMachine_DisposeObjects(Packet packet) throws JDWPException {
        return BRIDGE.dispatch(packet);
    }

    public Packet VirtualMachine_HoldEvents(Packet packet) throws JDWPException {
        this.controller.getEventListener().holdEvents();
        return WritablePacket.newReplyTo((Packet)packet);
    }

    public Packet VirtualMachine_ReleaseEvents(Packet packet) throws JDWPException {
        this.controller.getEventListener().releaseEvents();
        return WritablePacket.newReplyTo((Packet)packet);
    }

    public Packet ObjectReference_DisableCollection(Packet packet) throws JDWPException {
        return BRIDGE.dispatch(packet);
    }

    public Packet ObjectReference_EnableCollection(Packet packet) throws JDWPException {
        return BRIDGE.dispatch(packet);
    }

    public Packet ObjectReference_IsCollected(Packet packet) throws JDWPException {
        return BRIDGE.dispatch(packet);
    }

    public Packet StringReference_Value(Packet packet) throws JDWPException {
        return BRIDGE.dispatch(packet);
    }

    public Packet VirtualMachine_CreateString(Packet packet) throws JDWPException {
        return BRIDGE.dispatch(packet);
    }

    public Packet ReferenceType_SourceFile(Packet packet) throws JDWPException {
        Packet.Reader reader = packet.newDataReader();
        ResolvedJavaType type = CHECKED_READER.readTypeRef(reader);
        String sourceFileName = type.getSourceFileName();
        if (sourceFileName == null) {
            throw JDWPException.raise((ErrorCode)ErrorCode.ABSENT_INFORMATION);
        }
        WritablePacket reply = WritablePacket.newReplyTo((Packet)packet);
        Packet.Writer writer = reply.dataWriter();
        writer.writeString(sourceFileName);
        return reply;
    }

    public Packet VirtualMachine_ClassesBySignature(Packet packet) throws JDWPException {
        Packet.Reader reader = packet.newDataReader();
        String signature = reader.readString();
        ResolvedJavaType[] matchingTypes = (ResolvedJavaType[])ClassUtils.UNIVERSE.getTypes().stream().filter(type -> signature.equals(type.getName())).filter(type -> !type.isPrimitive()).toArray(ResolvedJavaType[]::new);
        WritablePacket reply = WritablePacket.newReplyTo((Packet)packet);
        Packet.Writer writer = reply.dataWriter();
        writer.writeInt(matchingTypes.length);
        for (ResolvedJavaType type2 : matchingTypes) {
            writer.writeByte((int)TypeTag.getKind((ResolvedJavaType)type2));
            long typeId = SYMBOLIC_REFS.toTypeRef(type2);
            writer.writeLong(typeId);
            int[] status = BRIDGE.typeStatus(new long[]{typeId});
            writer.writeInt(status[0]);
        }
        return reply;
    }

    public Packet ClassType_Superclass(Packet packet) throws JDWPException {
        Packet.Reader reader = packet.newDataReader();
        ResolvedJavaType type = CHECKED_READER.readTypeRef(reader);
        ResolvedJavaType superclass = type.getSuperclass();
        WritablePacket reply = WritablePacket.newReplyTo((Packet)packet);
        Packet.Writer writer = reply.dataWriter();
        if (superclass == null) {
            writer.writeLong(0L);
        } else {
            writer.writeLong(SYMBOLIC_REFS.toTypeRef(superclass));
        }
        return reply;
    }

    public Packet ReferenceType_Interfaces(Packet packet) throws JDWPException {
        Packet.Reader reader = packet.newDataReader();
        ResolvedJavaType type = CHECKED_READER.readTypeRef(reader);
        ResolvedJavaType[] interfaces = type.getInterfaces();
        WritablePacket reply = WritablePacket.newReplyTo((Packet)packet);
        Packet.Writer writer = reply.dataWriter();
        writer.writeInt(interfaces.length);
        for (ResolvedJavaType interfaceType : interfaces) {
            long typeId = SYMBOLIC_REFS.toTypeRef(interfaceType);
            writer.writeLong(typeId);
        }
        return reply;
    }

    private static Packet referenceSignatureHelper(Packet packet, boolean includeGenericSignature) {
        Packet.Reader reader = packet.newDataReader();
        ResolvedJavaType type = CHECKED_READER.readTypeRef(reader);
        WritablePacket reply = WritablePacket.newReplyTo((Packet)packet);
        Packet.Writer writer = reply.dataWriter();
        String signature = type.getName();
        writer.writeString(signature);
        if (includeGenericSignature) {
            String genericSignature = "";
            writer.writeString(genericSignature);
        }
        return reply;
    }

    public Packet ReferenceType_Signature(Packet packet) throws JDWPException {
        return ServerJDWP.referenceSignatureHelper(packet, false);
    }

    public Packet ReferenceType_SignatureWithGeneric(Packet packet) throws JDWPException {
        return ServerJDWP.referenceSignatureHelper(packet, true);
    }

    public Packet ReferenceType_Modifiers(Packet packet) throws JDWPException {
        Packet.Reader reader = packet.newDataReader();
        ResolvedJavaType type = CHECKED_READER.readTypeRef(reader);
        WritablePacket reply = WritablePacket.newReplyTo((Packet)packet);
        Packet.Writer writer = reply.dataWriter();
        int modBits = type.getModifiers();
        writer.writeInt(modBits);
        return reply;
    }

    private static Packet fieldsHelper(Packet packet, boolean includeGenericSignature) {
        Packet.Reader reader = packet.newDataReader();
        ResolvedJavaType type = CHECKED_READER.readTypeRef(reader);
        Collection allDeclaredFields = ClassUtils.UNIVERSE.getAllDeclaredFields(type);
        WritablePacket reply = WritablePacket.newReplyTo((Packet)packet);
        Packet.Writer writer = reply.dataWriter();
        writer.writeInt(allDeclaredFields.size());
        for (ResolvedJavaField field : allDeclaredFields) {
            writer.writeLong(SYMBOLIC_REFS.toFieldRef(field));
            writer.writeString(field.getName());
            String signature = field.getType().getName();
            writer.writeString(signature);
            if (includeGenericSignature) {
                String genericSignature = "";
                writer.writeString(genericSignature);
            }
            int modBits = field.getModifiers();
            writer.writeInt(modBits);
        }
        return reply;
    }

    public Packet ReferenceType_Fields(Packet packet) throws JDWPException {
        return ServerJDWP.fieldsHelper(packet, false);
    }

    public Packet ReferenceType_FieldsWithGeneric(Packet packet) throws JDWPException {
        return ServerJDWP.fieldsHelper(packet, true);
    }

    public Packet ReferenceType_Status(Packet packet) throws JDWPException {
        Packet.Reader reader = packet.newDataReader();
        long typeId = reader.readLong();
        ResolvedJavaType type = SYMBOLIC_REFS.toResolvedJavaType(typeId);
        int[] status = BRIDGE.typeStatus(new long[]{typeId});
        WritablePacket reply = WritablePacket.newReplyTo((Packet)packet);
        Packet.Writer writer = reply.dataWriter();
        writer.writeInt(status[0]);
        return reply;
    }

    public Packet ObjectReference_ReferringObjects(Packet packet) throws JDWPException {
        throw JDWPException.raise((ErrorCode)ErrorCode.NOT_IMPLEMENTED);
    }

    public Packet VirtualMachine_SetDefaultStratum(Packet packet) throws JDWPException {
        throw JDWPException.raise((ErrorCode)ErrorCode.NOT_IMPLEMENTED);
    }

    public Packet VirtualMachine_InstanceCounts(Packet packet) throws JDWPException {
        throw JDWPException.raise((ErrorCode)ErrorCode.NOT_IMPLEMENTED);
    }

    public Packet ReferenceType_Instances(Packet packet) throws JDWPException {
        throw JDWPException.raise((ErrorCode)ErrorCode.NOT_IMPLEMENTED);
    }

    public Packet ReferenceType_ConstantPool(Packet packet) throws JDWPException {
        throw JDWPException.raise((ErrorCode)ErrorCode.NOT_IMPLEMENTED);
    }

    public Packet ReferenceType_SourceDebugExtension(Packet packet) throws JDWPException {
        throw JDWPException.raise((ErrorCode)ErrorCode.NOT_IMPLEMENTED);
    }

    public Packet ReferenceType_ClassObject(Packet packet) throws JDWPException {
        return BRIDGE.dispatch(packet);
    }

    public Packet ClassObjectReference_ReflectedType(Packet packet) throws JDWPException {
        return BRIDGE.dispatch(packet);
    }

    public Packet ReferenceType_ClassLoader(Packet packet) throws JDWPException {
        return BRIDGE.dispatch(packet);
    }

    public Packet ReferenceType_Module(Packet packet) throws JDWPException {
        return BRIDGE.dispatch(packet);
    }

    public Packet ModuleReference_Name(Packet packet) throws JDWPException {
        return BRIDGE.dispatch(packet);
    }

    public Packet VirtualMachine_AllModules(Packet packet) throws JDWPException {
        return BRIDGE.dispatch(packet);
    }

    public Packet ModuleReference_ClassLoader(Packet packet) throws JDWPException {
        return BRIDGE.dispatch(packet);
    }

    public Packet ReferenceType_NestedTypes(Packet packet) throws JDWPException {
        return BRIDGE.dispatch(packet);
    }

    public Packet ThreadReference_IsVirtual(Packet packet) throws JDWPException {
        return BRIDGE.dispatch(packet);
    }

    public Packet ArrayReference_Length(Packet packet) throws JDWPException {
        return BRIDGE.dispatch(packet);
    }

    public Packet ArrayReference_GetValues(Packet packet) throws JDWPException {
        return BRIDGE.dispatch(packet);
    }

    public Packet ArrayReference_SetValues(Packet packet) throws JDWPException {
        return BRIDGE.dispatch(packet);
    }

    public Packet ArrayType_NewInstance(Packet packet) throws JDWPException {
        return BRIDGE.dispatch(packet);
    }

    private ThreadRef validateThread(long threadId, boolean mustBeSuspended) throws JDWPException {
        if (threadId == 0L) {
            throw JDWPException.raise((ErrorCode)ErrorCode.INVALID_THREAD);
        }
        ThreadRef threadRef = this.controller.getContext().getThreadRef(threadId);
        if (mustBeSuspended && threadRef.getSuspendCount() <= 0) {
            throw JDWPException.raise((ErrorCode)ErrorCode.THREAD_NOT_SUSPENDED);
        }
        return threadRef;
    }

    private ThreadRef validateThread(long threadId) throws JDWPException {
        return this.validateThread(threadId, false);
    }

    private static void validateFrameId(ThreadRef threadRef, long frameId) throws JDWPException {
        if (threadRef == null || threadRef.getSuspendCount() <= 0) {
            throw JDWPException.raise((ErrorCode)ErrorCode.INVALID_THREAD);
        }
        if (!threadRef.isValidFrameId(frameId)) {
            throw JDWPException.raise((ErrorCode)ErrorCode.INVALID_FRAMEID);
        }
    }

    public Packet StackFrame_ThisObject(Packet packet) throws JDWPException {
        Packet.Reader reader = packet.newDataReader();
        long threadId = reader.readLong();
        long frameId = reader.readLong();
        assert (reader.isEndOfInput());
        ThreadRef threadRef = this.validateThread(threadId, true);
        ServerJDWP.validateFrameId(threadRef, frameId);
        return BRIDGE.dispatch(packet);
    }

    public Packet StackFrame_GetValues(Packet packet) throws JDWPException {
        Packet.Reader reader = packet.newDataReader();
        long threadId = reader.readLong();
        long frameId = reader.readLong();
        ThreadRef threadRef = this.validateThread(threadId, true);
        ServerJDWP.validateFrameId(threadRef, frameId);
        return BRIDGE.dispatch(packet);
    }

    public Packet ObjectReference_GetValues(Packet packet) throws JDWPException {
        return BRIDGE.dispatch(packet);
    }

    public Packet ReferenceType_GetValues(Packet packet) throws JDWPException {
        return BRIDGE.dispatch(packet);
    }

    public Packet ClassLoaderReference_VisibleClasses(Packet packet) throws JDWPException {
        return BRIDGE.dispatch(packet);
    }

    public Packet ClassType_SetValues(Packet packet) throws JDWPException {
        return BRIDGE.dispatch(packet);
    }

    public Packet ObjectReference_SetValues(Packet packet) throws JDWPException {
        return BRIDGE.dispatch(packet);
    }

    public Packet StackFrame_SetValues(Packet packet) throws JDWPException {
        Packet.Reader reader = packet.newDataReader();
        long threadId = reader.readLong();
        long frameId = reader.readLong();
        ThreadRef threadRef = this.validateThread(threadId, true);
        ServerJDWP.validateFrameId(threadRef, frameId);
        return BRIDGE.dispatch(packet);
    }

    private static void skipArguments(Packet.Reader reader) {
        int argCount = reader.readInt();
        assert (argCount >= 0);
        block11: for (int i = 0; i < argCount; ++i) {
            byte tag = JDWP.readTag((Packet.Reader)reader);
            switch (tag) {
                case 66: {
                    reader.readByte();
                    continue block11;
                }
                case 90: {
                    reader.readBoolean();
                    continue block11;
                }
                case 83: {
                    reader.readShort();
                    continue block11;
                }
                case 67: {
                    reader.readChar();
                    continue block11;
                }
                case 73: {
                    reader.readInt();
                    continue block11;
                }
                case 74: {
                    reader.readLong();
                    continue block11;
                }
                case 70: {
                    reader.readFloat();
                    continue block11;
                }
                case 68: {
                    reader.readDouble();
                    continue block11;
                }
                case 86: {
                    continue block11;
                }
                default: {
                    reader.readLong();
                }
            }
        }
    }

    public Packet ClassType_InvokeMethod(Packet packet) throws JDWPException {
        return this.sharedInvokeMethod(false, packet);
    }

    public Packet ObjectReference_InvokeMethod(Packet packet) throws JDWPException {
        return this.sharedInvokeMethod(true, packet);
    }

    public Packet InterfaceType_InvokeMethod(Packet packet) throws JDWPException {
        return this.sharedInvokeMethod(false, packet);
    }

    public Packet ClassType_NewInstance(Packet packet) throws JDWPException {
        return this.sharedInvokeMethod(false, packet);
    }

    private Packet sharedInvokeMethod(boolean readReceiver, Packet packet) {
        ResolvedJavaType type;
        Packet.Reader reader = packet.newDataReader();
        if (readReceiver) {
            long receiverId = reader.readLong();
            assert (receiverId != 0L);
        } else {
            type = CHECKED_READER.readTypeRef(reader);
            assert (type != null);
        }
        long threadId = reader.readLong();
        ThreadRef threadRef = this.validateThread(threadId, true);
        if (readReceiver) {
            type = CHECKED_READER.readTypeRef(reader);
            assert (type != null);
        }
        ResolvedJavaMethod method = CHECKED_READER.readMethodRef(reader);
        assert (!readReceiver || !method.isStatic());
        ServerJDWP.skipArguments(reader);
        int options = reader.readInt();
        assert (reader.isEndOfInput());
        boolean invokeSingleThreaded = InvokeOptions.singleThreaded((int)options);
        Packet[] invokeReply = new Packet[1];
        threadRef.invoke(() -> {
            invokeReply[0] = ServerJDWP.dispatchInvokeWithExceptions(packet);
        }, () -> this.controller.getEventListener().sendEvent(invokeReply[0]), invokeSingleThreaded);
        return null;
    }

    private static Packet dispatchInvokeWithExceptions(Packet packet) {
        try {
            return BRIDGE.dispatch(packet);
        }
        catch (JDWPException e) {
            LOGGER.log((Throwable)e, "JDWP exception during method invocation");
            WritablePacket reply = WritablePacket.newReplyTo((Packet)packet);
            reply.errorCode(e.getError());
            return reply;
        }
        catch (Throwable t) {
            LOGGER.log(t, "internal exception during method invocation");
            WritablePacket reply = WritablePacket.newReplyTo((Packet)packet);
            reply.errorCode(ErrorCode.INTERNAL);
            return reply;
        }
    }
}

