/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.jdwp.server.impl;

import com.oracle.svm.jdwp.bridge.ErrorCode;
import com.oracle.svm.jdwp.bridge.FrameId;
import com.oracle.svm.jdwp.bridge.JDWPException;
import com.oracle.svm.jdwp.bridge.StackFrame;
import com.oracle.svm.jdwp.server.impl.CallFrame;
import com.oracle.svm.jdwp.server.impl.ServerJDWP;
import com.oracle.svm.jdwp.server.impl.SuspendedInfo;
import com.oracle.svm.jdwp.server.impl.ThreadsCollector;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public final class ThreadRef {
    private static final AtomicLong FRAME_GENERATION = new AtomicLong(1L);
    private final long threadId;
    private final ThreadsCollector collector;
    private final Lock readLock;
    private final Lock writeLock;
    private int suspendCount;
    private boolean suspendedInResident;
    private SuspendedInfo suspendedInfo;
    private Thread parkedThread;
    private Semaphore parkedSemaphore = new Semaphore(0);
    private boolean parked;
    private CallFrame[] stack;
    private volatile InvokeTask invokeTask;

    ThreadRef(long threadId, ThreadsCollector collector) {
        this.threadId = threadId;
        this.collector = collector;
        ReentrantReadWriteLock threadLock = new ReentrantReadWriteLock();
        this.readLock = threadLock.readLock();
        this.writeLock = new ThreadWriteLock(collector.getRWLock().readLock(), threadLock.writeLock());
    }

    private static long getFrameGeneration(long threadId) {
        return FRAME_GENERATION.get();
    }

    private static void incrementFrameGeneration(long threadId) {
        FRAME_GENERATION.incrementAndGet();
    }

    public long getFrameGeneration() {
        return ThreadRef.getFrameGeneration(this.getThreadId());
    }

    public boolean isValidFrameId(long frameId) {
        return this.getFrameGeneration() == FrameId.getFrameGeneration((long)frameId);
    }

    public long getThreadId() {
        return this.threadId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspendedAt(SuspendedInfo si, Runnable eventSender) {
        this.writeLock.lock();
        try {
            this.suspendedInfo = si;
            this.resumeResidentIfSuspended();
            ++this.suspendCount;
            this.parkedThread = Thread.currentThread();
            this.parked = true;
        }
        finally {
            this.writeLock.unlock();
        }
        if (eventSender != null) {
            eventSender.run();
        }
        while (true) {
            assert (this.collector.getRWLock().getReadHoldCount() == 0);
            assert (this.collector.getRWLock().getWriteHoldCount() == 0);
            try {
                this.parkedSemaphore.acquire();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.doInvoke();
            this.writeLock.lock();
            if (this.suspendCount == 0) break;
            this.writeLock.unlock();
        }
        try {
            this.parkedThread = null;
            this.suspendedInfo = null;
            if (this.stack != null) {
                si.context().unregisterCallFrames(this.stack);
            }
            this.stack = null;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(Runnable doInvokeTask, Runnable invokeReplyTask, boolean singleThreaded) {
        this.writeLock.lock();
        try {
            if (this.parkedThread == null) {
                throw JDWPException.raise((ErrorCode)ErrorCode.THREAD_NOT_SUSPENDED);
            }
            this.invokeTask = new InvokeTask(doInvokeTask, invokeReplyTask, singleThreaded);
            this.parkedSemaphore.release();
            this.parkedThread = null;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doInvoke() {
        InvokeTask task = this.invokeTask;
        if (task != null) {
            int sc;
            SuspendedInfo si;
            this.writeLock.lock();
            try {
                si = this.suspendedInfo;
                sc = this.suspendCount;
                this.suspendedInfo = null;
                this.suspendCount = 0;
            }
            finally {
                this.writeLock.unlock();
            }
            if (!task.singleThreaded()) {
                this.collector.resumeAllBut(this);
            }
            try {
                task.invoke().run();
            }
            finally {
                if (!task.singleThreaded()) {
                    this.collector.suspendAllBut(this);
                }
                this.writeLock.lock();
                try {
                    this.suspendedInfo = si;
                    this.suspendCount = sc;
                    this.parkedThread = Thread.currentThread();
                    this.invokeTask = null;
                }
                finally {
                    this.writeLock.unlock();
                }
                task.reply().run();
            }
        }
    }

    public int getSuspendCount() {
        this.readLock.lock();
        try {
            int n = this.suspendCount;
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public boolean isParked() {
        this.readLock.lock();
        try {
            boolean bl = this.parked;
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public SuspendedInfo getSuspendedInfo() {
        this.readLock.lock();
        try {
            SuspendedInfo suspendedInfo = this.suspendedInfo;
            return suspendedInfo;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CallFrame[] getStackFrames() {
        this.readLock.lock();
        try {
            SuspendedInfo si = this.suspendedInfo;
            if (si == null) {
                CallFrame[] callFrameArray = null;
                return callFrameArray;
            }
            if (this.stack == null) {
                if (si.stackDepth() == 0) {
                    this.stack = new CallFrame[0];
                } else {
                    StackFrame[] frames = ServerJDWP.BRIDGE.getThreadFrames(si.thread().getThreadId());
                    this.stack = new CallFrame[frames.length];
                    for (int i = 0; i < frames.length; ++i) {
                        this.stack[i] = CallFrame.fromStackFrame(this, frames[i]);
                    }
                    si.context().registerCallFrames(this.stack);
                }
            }
            CallFrame[] callFrameArray = this.stack;
            return callFrameArray;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void suspend() throws JDWPException {
        this.writeLock.lock();
        try {
            if (this.suspendCount == 0) {
                if (this.parkedThread != null) {
                    this.parked = true;
                } else {
                    long suspended = ServerJDWP.BRIDGE.threadSuspend(this.threadId);
                    if (suspended == -1L) {
                        throw JDWPException.raise((ErrorCode)ErrorCode.INVALID_THREAD);
                    }
                    if (suspended < 0L) {
                        throw JDWPException.raise((ErrorCode)ErrorCode.INVALID_OBJECT);
                    }
                    this.suspendedInResident = true;
                }
            }
            ++this.suspendCount;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void resume(boolean forceRelease) {
        this.writeLock.lock();
        try {
            if (this.suspendCount == 0) {
                return;
            }
            if (forceRelease) {
                this.suspendCount = 1;
            }
            if (--this.suspendCount == 0) {
                if (this.parkedThread != null) {
                    this.parkedSemaphore.release();
                    this.parked = false;
                } else {
                    this.suspendedInResident = false;
                    this.collector.getCallToResidentThread().threadResume(this.threadId);
                }
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public boolean canParkOrIncreaseSuspend() {
        this.writeLock.lock();
        try {
            if (this.suspendCount == 0) {
                if (this.parkedThread != null) {
                    this.parked = true;
                } else {
                    boolean bl = false;
                    return bl;
                }
            }
            ++this.suspendCount;
            boolean bl = true;
            return bl;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void notifySuspended() {
        this.writeLock.lock();
        try {
            if (this.suspendCount == 0) {
                this.suspendedInResident = true;
            }
            ++this.suspendCount;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void notifyResumed() {
        this.writeLock.lock();
        try {
            assert (this.suspendCount > 0);
            assert (this.parkedThread == null) : this.parkedThread;
            assert (!this.parked);
            assert (this.suspendedInfo == null);
            --this.suspendCount;
            if (this.suspendCount == 0) {
                this.suspendedInResident = false;
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void resumeResidentIfSuspended() {
        if (this.suspendedInResident) {
            this.suspendedInResident = false;
            this.collector.getCallToResidentThread().threadResume(this.threadId);
        }
    }

    private record ThreadWriteLock(Lock collectorLock, Lock threadWriteLock) implements Lock
    {
        @Override
        public void lock() {
            this.collectorLock.lock();
            this.threadWriteLock.lock();
        }

        @Override
        public void lockInterruptibly() throws InterruptedException {
            this.collectorLock.lockInterruptibly();
            this.threadWriteLock.lockInterruptibly();
        }

        @Override
        public void unlock() {
            this.threadWriteLock.unlock();
            this.collectorLock.unlock();
        }

        @Override
        public boolean tryLock() {
            throw new UnsupportedOperationException("Not supported.");
        }

        @Override
        public boolean tryLock(long time, TimeUnit unit) {
            throw new UnsupportedOperationException("Not supported.");
        }

        @Override
        public Condition newCondition() {
            throw new UnsupportedOperationException("Not supported.");
        }
    }

    record InvokeTask(Runnable invoke, Runnable reply, boolean singleThreaded) {
    }
}

